#!/usr/local/bin/perl
#
# cafPage.pm 25/08/2002
#
# cafeterra : data flow and data replication management
# Copyright (C) 2001  Abdellaziz TALEB
#
#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
use 5.005;
use strict;
package Attrdef;

@Attrdef::ISA = ('cafPage');

# fName => "attrdefid", fType => "atom", fMand => 1, fMin =>, fMax =>, fisList =>,
my $editfields = [
	{ fName => "attrdefid", fType => "atom", fMand => 1, fMin => 3, fMax => 30 },
	{ fName => "attrdeflabel" },
	{ fName => "protocolid", fType => "atom", fMand => 1, fMin => 3, fMax => 30 },
	{ fName => "driverid", fType => "atom", fMand => 1, fMin => 3, fMax => 30 },
	{ fName => "objtype", fType => "atom", fMand => 1, fMin => 3, fMax => 30 },
	{ fName => "datatype", fType => "atom", fMand => 1, fMin => 3, fMax => 30 },
	{ fName => "attrdefault", }, 

	];
 
sub startpage {
	my $self = shift;

	$self->_hiddenvar ("_pagetype", "NORMAL");
	my $cgi =  $self->{_system}{_cgi};
	my $dbh =  $self->{_system}{_dbh};
	my $conf =  $self->{_system}{_conf};
	$self->_hiddenvar ("_pagetype", "SEARCH") if $cgi->param("_searchcall");
	my $curraction = $self->_hiddenvar ("_curraction");
	unless ($curraction) { $curraction = 'search', $self->_hiddenvar ("_curraction", $curraction); }
	my $meth_name = "meth_$curraction";

	my $actiondetail = $self->_hiddenvar ("_actiondetail");
	unless ($actiondetail) { $actiondetail = 'search', $self->_hiddenvar ("_actiondetail", $actiondetail); }

	$self->$meth_name($cgi, $dbh, $conf);

}

sub meth_search {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;
	my $query = $dbh->newquery();
	$query->sprotocollist();
	$self->{_protocollist} = $dbh->hexecfetchall($query);
	unshift @{$self->{_protocollist}}, { protocolid => "all", protocollabel => "All protocols" };

	($self->{search1} = $cgi->param("search1")) =~ s/ *//g;
	($self->{search2} = $cgi->param("search2")) =~ s/ *//g;
	($self->{search3} = $cgi->param("search3")) =~ s/ *//g;

	my $cond = [];
	my $icond = -1;
	if ($self->{search1}) { $cond->[++$icond] = [ "attrdefid", "like", $self->{search1} ]; }
	if ($self->{search2}) { $cond->[++$icond] = [ "attrdeflabel", "like", $self->{search2} ]; }
	if ($self->{search3}) { $cond->[++$icond] = [ "protocolid", "like", $self->{search3} ]; }

	my ($rowscount, $lastrow, $maxlistdisplay) = $self->_getnavinfo ("attrdef", $cond);
	my $rowscount = $self->_hiddenvar("_rowscount");
	my $lastrow = $self->_hiddenvar("_lastrow");
	my $maxlistdisplay = $conf->maxlistdisplay();
	
	my $query = $dbh->newquery({attrdefid => $self->{search1}, attrdeflabel => $self->{search2}, protocolid => $self->{search3}  });
	$query->sattrdeflist();

	$self->{_list1} = $dbh->hexecfetchset($query, $lastrow - 1, $maxlistdisplay);
	$self->{list1count} = $query->hrowcount();

	$self->{list1count} = -1 unless (defined($self->{list1count}));
	$self->{list1count} += 1;
	$self->_hiddenvar ("_lastrow",  $lastrow + $self->{list1count});
	$self->_hiddenvar ("_objectid", "");
	$self->_setnavinfo("list1");
#	print "<BR>\nlist1count = $self->{list1count}";
}

sub meth_edit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	$self->_getcheckfields ($cgi, $editfields);
	$self->_hiddenvar ("search1", $cgi->param("search1"));
	$self->_hiddenvar ("search2", $cgi->param("search2"));
	$self->_hiddenvar ("search3", $cgi->param("search3"));

	my $actiondetail = $self->_hiddenvar ("_actiondetail");

	if ($actiondetail =~ /^v/) { $self->_initmeth_edit($cgi, $dbh, $conf); }
	elsif ($actiondetail eq 'new') { $self->{_system}{noselect} = 1; }
	else { $self->_datavar("attrdefid", $cgi->param("_objectid")) unless ($self->_datavar("attrdefid")); }

        $actiondetail = $self->_hiddenvar ("_actiondetail");

	unless ($self->{_system}{noselect}) {
		my $query = $dbh->newquery({ attrdefid => $self->_datavar("attrdefid") });
		$query->sattrdeflist ();
		my $row = $dbh->hexecfetchrow($query, 1);
		$self->{_data} = {};
		foreach my $field (%{$row}) { $self->{_data}{$field} = $row->{$field}; }
	}
	if ($actiondetail eq 'copy') { $self->_datavar("attrdefid", undef); }
	$self->_hiddenvar ("_objectid", $self->_datavar("attrdefid"));

	my $query = $dbh->newquery();
	$query->sprotocollist();
	$self->{_protocollist} = $dbh->hexecfetchall($query);
	unshift @{$self->{_protocollist}}, { protocolid => "all", protocollabel => "All protocols" };
	foreach my $proto (@{$self->{_protocollist}}) {
		if ($proto->{protocolid} eq $self->_datavar("protocolid")) { $self->_datavar("protocollabel", $proto->{protocollabel}); }
	}
	my $driverslist;
#	if ($self->_datavar("protocolid")) {
#		$query = $dbh->newquery({ protocolid => $self->_datavar("protocolid") });
		$query = $dbh->newquery();
		$query->sdriverlistuniq();
		$self->{_driverlist} = $dbh->hexecfetchall($query);
		unshift @{$self->{_driverlist}}, { driverid => "all", driverlabel => "All drivers" };
		foreach my $drv (@{$self->{_driverlist}}) {
			if ($drv->{driverid} eq $self->_datavar("driverid")) { $self->_datavar("driverlabel", $drv->{driverlabel}); }
		}
#	}
}

sub meth_vnew () {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $ret;
	if ($self->_datavar("driverid")) {
		my $query = $dbh->newquery($self->_getmyfields());
		$query->iattrdef();

		$ret = $dbh->executefinish($query);
		$dbh->commit();
	}
	else { return undef; }
	return ($ret);
}

sub meth_vedit {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->uattrdef();

	my $ret = $dbh->executefinish($query);
	$dbh->commit();
	return ($ret);
}

sub meth_vdrop {
	my $self = shift;
	my $cgi = shift;
	my $dbh = shift;
	my $conf = shift;

	my $query = $dbh->newquery($self->_getmyfields());
	$query->dattrdef();

	my $ret = $dbh->executefinish($query);
	return ($ret);
}


1;
