<?php
//
// test calpp configuration settings
//
require "/usr/local/httpd/htdocs/calpp/src/base/calpp_config.inc";
echo '
<style type="text/css">
<!--
body {background-color: #ffffff; color: #000000;}
body, td, th, h1, h2 {font-family: sans-serif;}
pre {margin: 0px; font-family: monospace;}
a:link {color: #000099; text-decoration: none;}
a:hover {text-decoration: underline;}
table {border-collapse: collapse;}
.center {text-align: center;}
.center table { margin-left: auto; margin-right: auto; text-align: left;}
.center th { text-align: center; !important }
td, th { border: 1px solid #000000; font-size: 75%; vertical-align: baseline;}
h1 {font-size: 150%;}
h2 {font-size: 125%;}
.p {text-align: left;}
.k {background-color: #ccccff; font-weight: bold;}
.h {background-color: #9999cc; font-weight: bold;}
.v {background-color: #cccccc;}
i {color: #666666;}
img {float: right; border: 0px;}
hr {width: 600px; align: center; background-color: #cccccc; border: 0px; height: 1px;}
//--></style>';

function test_pgsql_connection(){
    // to check if pgsql connection works
    global $CLP_DEBUG;
    global $DSN_TYPE;
    global $DSN_USERNAME;
    global $DSN_PASSWORD;
    global $DSN_HOSTSPEC;
    global $DSN_DATABASE;
    global $DSN_PORT;
    $CLP_DEBUG[]="starting test_pgsql_connection()...";
    $dbsource = pg_connect("host=$DSN_HOSTSPEC port=$DSN_PORT dbname=$DSN_DATABASE user=$DSN_USERNAME password=$DSN_PASSWORD") or die('pg_connect failed');
    $CLP_DEBUG[]="test_pgsql_connection() returns TRUE";
    return TRUE;

}

function test_pear_connection(){
    // to check if db pear connection works
    require_once('DB.php');
    global $CLP_DEBUG;
    global $DSN_TYPE;
    global $DSN_USERNAME;
    global $DSN_PASSWORD;
    global $DSN_HOSTSPEC;
    global $DSN_DATABASE;
    //$dbsource = "pgsql://ramanraj:password@localhost/calpp";
    $dbsource = "$DSN_TYPE://$DSN_USERNAME:$DSN_PASSWORD@$DSN_HOSTSPEC/$DSN_DATABASE";
    $CLP_DEBUG[]="starting test_pear_connection() ...";
    $CLP_DEBUG[]="dbsource: $dbsource";
    $db = DB::connect($dbsource);
    if (DB::isError($db)){
	$CLP_DEBUG[]=($db->getMessage());
        $CLP_DEBUG[]="test_pear_connection() returns FALSE";
	return FALSE;
    } else {
        $CLP_DEBUG[]="test_pear_connection() returns TRUE";
	$db->disconnect();
	return TRUE;
    }
}

// 
// DATA SOURCE NAME (DSN) Configuration
//
echo "<h3>DATA SOURCE NAME (DSN) Configuration</h3>";
echo "<table>
<tr><td class=k>DSN_TYPE	<td class=v>$DSN_TYPE
<tr><td class=k>DSN_USERNAME	<td class=v>$DSN_USERNAME
<tr><td class=k>DSN_PASSWORD    <td class=v>$DSN_PASSWORD
<tr><td class=k>DSN_PROTOCOL	<td class=v>$DSN_PROTOCOL
<tr><td class=k>DSN_HOSTSPEC	<td class=v>$DSN_HOSTSPEC 
<tr><td class=k>DSN_DATABASE	<td class=v>$DSN_DATABASE 
<tr><td class=k>DSN_PORT	<td class=v>$DSN_PORT 
";

// check if db pear connection works
$DSN_PEAR_CONNECTION = test_pear_connection();
echo "<tr><td class=k>DSN_PEAR_CONNECTION <td class=v>$DSN_PEAR_CONNECTION";

// check if pgsql connection works
$DSN_PGSQL_CONNECTION = test_pgsql_connection();
echo "<tr><td class=k>DSN_PGSQL_CONNECTION <td class=v>$DSN_PGSQL_CONNECTION";

echo "</table>";

//
// CALPP ELEMENTS
//
echo "<h3>CALPP ELEMENTS</h3>";
echo "<table>
<tr><td class=k>CLP_DIR		<td class=v colspan=2>$CLP_DIR
<tr><td class=k>CLP_LOGO_TINY	<td class=v>$CLP_LOGO_TINY	<td><img src=\"$CLP_LOGO_TINY\">
<tr><td class=k>CLP_LOGO_SMALL	<td class=v>$CLP_LOGO_SMALL	<td><img src=$CLP_LOGO_SMALL>
<tr><td class=k>CLP_LOGO_BIG	<td class=v>$CLP_LOGO_BIG	<td><img src=$CLP_LOGO_BIG>
<tr><td class=k>CLP_LOGO_EXPANDED<td class=v>$CLP_LOGO_EXPANDED	<td><img src=$CLP_LOGO_EXPANDED>
</table>";


//
// YOUR ORGANISATION DETAILS
//
echo "<h3>YOUR ORGANISATION DETAILS</h3>";
echo "<table>
<tr><td class=k>ORG_LOGO	<td class=v>$ORG_LOGO    <td><img src=\"$ORG_LOGO\">
<tr><td class=k>ORG_NAME	<td class=v colspan=2>$ORG_NAME 
<tr><td class=k>ORG_ADDRESS	<td class=v colspan=2>$ORG_ADDRESS
<tr><td class=k>ORG_PHONE	<td class=v colspan=2>$ORG_PHONE 
<tr><td class=k>ORG_WEBSITE	<td class=v colspan=2>$ORG_WEBSITE
<tr><td class=k>ORG_EMAIL	<td class=v colspan=2>$ORG_EMAIL
</table>";

//
// DEBUG MESSAGES
//
echo "<h3>DEBUG MESSAGES</h3>";
echo "<table>";
while (list ($key, $value)=each($CLP_DEBUG)){
    echo "<tr><td class=k>$key	<td class=v>$value";
}
echo "</table>"; 
?>

