# $Id: person_cat_adm.pm,v 1.5 2003/12/20 04:14:51 mig Exp $
######################################
# Comas - Conference Management System
######################################
# Copyright 2003 CONSOL
# Congreso Nacional de Software Libre (http://www.consol.org.mx/)
#   Gunnar Wolf <gwolf@gwolf.cx>
#   Manuel Rabade <mig@mig-29.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################

######################################
# Module: Comas::Admin::person_cat_adm
# Manage Comas person catalogs
######################################
# Depends on:
#
# Comas::Common - Common functions for various Comas modules
# Comas::Admin - Manage administrative tasks for a Comas database

# This module is not meant to be called on its own, it should be called from
# Comas::Admin.
package Comas::Admin::person_cat_adm;

use strict;
use warnings;
use Carp;
use Comas::Admin;
use Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(create_studies create_person_type create_state
		    create_country create_pers_status set_studies
		    set_person_type set_state set_country set_pers_status
		    delete_studies delete_person_type delete_state
		    delete_country delete_pers_status);
our %EXPORT_TAGS = (studies => [qw(create_studies set_studies 
				   delete_studies)], 
		    person_type => [qw(create_person_type 
				       delete_person_type 
				       set_person_type)], 
		    state => [qw(create_state set_state delete_state)],
		    country => [qw(create_country set_country 
				   delete_country)],
		    pers_status => [qw(create_pers_status set_pers_status
				       delete_pers_status)]);

=head1 NAME

Comas::Admin::person_cat_adm - Manage Comas person catalogs

=head1 SYNOPSIS

This module is not meant to be used by itself, but as an auxiliary to
L<Comas::Admin|Comas::Admin>. Please check L<Comas::Admin|Comas::Admin>'s
documentation, in the B<Person-related catalog administration> section, for
further details on the usage for this functions.

=head1 SEE ALSO

L<Comas::Admin|Comas::Admin> module documentation

=head1 AUTHOR

Gunnar Wolf, gwolf@gwolf.cx

Manuel Rabade, mig@mig-29.net

Comas has been developed for CONSOL, Congreso Nacional de Software Libre,
http://www.consol.org.mx/

=head1 COPYRIGHT

Copyright 2003 Gunnar Wolf and Manuel Rabade

This library is free software, you can redistribute it and/or modify it
under the terms of the GPL version 2 or later.

=cut

sub create_studies {
    my ($adm, $descr);
    $adm = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_create_record($adm->{-db}, 'studies', $descr);
}

sub create_person_type {
    my ($adm, $descr);
    $adm = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_create_record($adm->{-db}, 'person_type', $descr);
}

sub create_state {
    my ($adm, $descr);
    $adm = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_create_record($adm->{-db}, 'state', $descr);
}

sub create_country {
    my ($adm, $descr);
    $adm = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_create_record($adm->{-db}, 'country', $descr);
}

sub create_pers_status {
    my ($adm, $descr);
    $adm = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_create_record($adm->{-db}, 'pers_status', $descr);
}

sub set_studies {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_set_record($adm->{-db}, 'studies', $id, $descr);
}

sub set_person_type {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_set_record($adm->{-db}, 'person_type', $id, $descr);
}

sub set_state {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_set_record($adm->{-db}, 'state', $id, $descr);
}

sub set_country {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_set_record($adm->{-db}, 'country', $id, $descr);
}

sub set_pers_status {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    $descr = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_set_record($adm->{-db}, 'pers_status', $id, $descr);
}

sub delete_studies {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_delete_record($adm->{-db}, 'studies', $id);
}

sub delete_person_type {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_delete_record($adm->{-db}, 'person_type', $id);
}

sub delete_state {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_delete_record($adm->{-db}, 'state', $id);
}

sub delete_country {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_delete_record($adm->{-db}, 'country', $id);
}

sub delete_pers_status {
    my ($adm, $id, $descr);
    $adm = shift;
    $id = shift;
    unless ($adm->ck_admin_task(-task=>'person_cat_adm')) {
	carp 'Access denied';
	return undef;
    }
    return Comas::Admin::_delete_record($adm->{-db}, 'pers_status', $id);
}


1;

# $Log: person_cat_adm.pm,v $
# Revision 1.5  2003/12/20 04:14:51  mig
# - Agrego tags Id y Log que expanda el CVS
#
