# $Id: common.pm,v 1.1 2004/02/07 00:11:17 mig Exp $
######################################
# Comas - Conference Management System
######################################
# Copyright 2003 CONSOL
# Congreso Nacional de Software Libre (http://www.consol.org.mx/)
#   Gunnar Wolf <gwolf@gwolf.cx>
#   Manuel Rabade <mig@mig-29.net>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
######################################

######################################
# Module: Comas::HTML::committee::common
# Common functions fot the committee HTML FrontEnd
######################################
# Depends on:



# This module is not meant to be called on its own, it should be called from
# Comas::HTML.

package Comas::HTML::committee::common;

use strict;
use warnings;
use Carp;

use Exporter;

our @ISA = qw(Exporter);
our @EXPORT_OK = qw( _select_person _search_person );
our %EXPORT_TAGS = (all => [@EXPORT_OK]);

=head1 NAME
    
Comas::HTML::committee::common - Common functions for the committee HTML FrontEnd

=head1 SYNOPSIS

This module is not meant to be used by itself, but as an auxiliary to
L<Comas::HTML|Comas::HTML>. Please check L<Comas::HTML|Comas::HTML>'s
documentation, in the B<Front End Tasks> section, for further details on the
usage for this functions.

=head1 SEE ALSO

L<Comas::HTML|Comas::HTML> module documentation

=head1 AUTHOR

Gunnar Wolf, gwolf@gwolf.cx

Manuel Rabade, mig@mig-29.net

Comas has been developed for CONSOL, Congreso Nacional de Software Libre,
http://www.consol.org.mx/

=head1 COPYRIGHT

Copyright 2003 Gunnar Wolf and Manuel Rabade

This library is free software, you can redistribute it and/or modify it
under the terms of the GPL version 2 or later.

=cut


sub _select_person {
    my $h = shift;
    my ($template, $person);

    unless($h->_ck_committee_task) {
        return $h->committee_menu('NOT_AUTHORIZED');
    }

    $template = HTML::Template->new(filename=>
                                    'committee/select_person.tmpl',
                                    path => $h->{-config}->{-tmpl_path},
                                    die_on_bad_params => 0, cache => 1);

    $template->param(-section => $h->{-path}->[1]);

    if ($h->{-params}->{-posted}) {
        $h->{-params}->{-login} =~ s/^\ +//;
        if ($h->{-params}->{-login} eq '') {
            $template->param(HAS_MISSING => 1);
        } else {
            unless ($person = Comas::Person->new(-db => $h->{-db}, 
                                                 -login => 
                                                 $h->{-params}->{-login})) {
                $template->param(LOGIN_NOT_FOUND => 1);
            } else {
                return ($template, $person->{-id});
            }
        }
    }
    return ($template, undef);
}

sub _search_person {
    my ($template, $input_profile, $validator, $val_results, @person_ids,
        @persons);

    my $h = shift;

    unless($h->_ck_committee_task) {
        return $h->committee_menu('NOT_AUTHORIZED');
    }

    $input_profile = {
        optional => [ qw( -nickname -email -firstname -famname ) ],
        filters => [ qw( trim ) ] };
    
    $template = HTML::Template->new(filename=>
                                    'committee/search_person.tmpl',
                                    path => $h->{-config}->{-tmpl_path},
                                    die_on_bad_params => 0, cache => 1);
    
    $validator = Data::FormValidator->new;
    $val_results = $validator->check ( $h->{-params}, $input_profile);
    @person_ids = Comas::Person->search(-db => $h->{-db},
                                        %{$val_results->valid});
    foreach my $id (@person_ids) {
        my ($person_temp, %row, %person_data);
        $person_temp = Comas::Person->new(-db => $h->{-db},
                                          -id => $id);
        %person_data = $person_temp->get_data;
        $row{-id} = $person_temp->{-id};
        $row{-login} = $person_data{-login};
        $row{-famname} = $person_data{-famname};
        $row{-firstname} = $person_data{-firstname};
        $row{-email} = $person_data{-email};
        $row{-nick} = $person_data{-nickname};
        $row{-section} = $h->{-path}->[1];
        push (@persons, \%row);
    }
    $template->param(PERSONS => \@persons);

    return $template;

}

# $Log: common.pm,v $
# Revision 1.1  2004/02/07 00:11:17  mig
# - Funciones generalizadas para committee
#
