/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.awt.Point;
import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;
import org.postgresql.util.PSQLException;

public class PGpoint
extends PGobject
implements Serializable,
Cloneable {
    public double x;
    public double y;

    public PGpoint() {
        this.setType("point");
    }

    public PGpoint(double d, double d2) {
        this();
        this.x = d;
        this.y = d2;
    }

    public PGpoint(String string) throws SQLException {
        this();
        this.setValue(string);
    }

    public Object clone() {
        return new PGpoint(this.x, this.y);
    }

    public boolean equals(Object object) {
        if (object instanceof PGpoint) {
            PGpoint pGpoint = (PGpoint)object;
            return this.x == pGpoint.x && this.y == pGpoint.y;
        }
        return false;
    }

    public String getValue() {
        return "(" + this.x + "," + this.y + ")";
    }

    public void move(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void move(int n, int n2) {
        this.setLocation(n, n2);
    }

    public void setLocation(int n, int n2) {
        this.move((double)n, (double)n2);
    }

    public void setLocation(Point point) {
        this.setLocation(point.x, point.y);
    }

    public void setValue(String string) throws SQLException {
        PGtokenizer pGtokenizer = new PGtokenizer(PGtokenizer.removePara(string), ',');
        try {
            this.x = Double.valueOf(pGtokenizer.getToken(0));
            this.y = Double.valueOf(pGtokenizer.getToken(1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PSQLException("postgresql.geo.point", (Object)numberFormatException.toString());
        }
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void translate(int n, int n2) {
        this.translate((double)n, (double)n2);
    }
}

