#! /bin/bash

case $DEBUG in
  1) set -x
     ;;
  *)
     ;;
esac

error() { # juste pour usage
		echo $1 1>&2
}

usage() {
		error "usage : replic-db.sh [-h] [-c] -s <source db> -d <dest db> -u <user> -p <password> -l <log file>"
		error "    -c : compact dump"
		error "example : replic-db.sh -s barbie@bonnie -d barbie@clyde -u pimentech -p \"\" -l replic-db.log"
}

DUMPDBOPTIONS=""

while true
do
  case $1 in
    -s) srcdb=$2
        shift 2
				;;
    -d) destdb=$2
        shift 2
				;;
    -h) usage
		exit 0
		;;
	-u) user="$2"
		shift 2
		;;
	-p) password="$2"
		shift 2
		;;
	-c) DUMPDBOPTIONS="-c"
		shift 1
		;;
	-l) logfile=$2
		shift 2
		;;
     *)
		break
		;;
  esac
done

if [ -z "$srcdb" -o -z "$destdb" -o -z "$user" -o -z "$logfile" ] 
then
		usage
		exit 1
fi

date=`date '+%d-%m-%Y'`
error() {
		echo "ERROR:replic-db.sh:$date: $1" 1>&2
		echo "ERROR:replic-db.sh:$date: $1" >> $logfile
}

TMPDIR=/tmp/`whoami`
mkdir -p ${TMPDIR}
if [ $? -ne 0 ]
then
	error "cannot mkdir -p ${TMPDIR}"
	exit 1
fi

srchost=`echo $srcdb | awk -F'@' '{ print $2 }'`
srcdbname=`echo $srcdb | awk -F'@' '{ print $1 }'`

exec-sql.sh -H $srchost -d $srcdbname -u $user -p "$password" -c "vacuum analyze;" -l $logfile -o /dev/null
if [ $? -ne 0 ]
then
		error "cannot vacuum in $srcdb"
fi

dump=${TMPDIR}/dump_${srcdb}_$date.sql
psqllog=${TMPDIR}/psql_$$.log

dump-db.sh $DUMPDBOPTIONS -H $srchost -d $srcdbname -u "$user" -p "$password" -l $logfile > $dump
if [ $? -ne 0 ]
then
	error "cannot dump $srcdb"
	exit 1
fi

desthost=`echo $destdb | awk -F'@' '{ print $2 }'`
destdbname=`echo $destdb | awk -F'@' '{ print $1 }'`

destroy-db.sh -H $desthost -d $destdbname -u $user -p "$password" -l $logfile
if [ $? -ne 0 ]
then
		error "cannot destroy $destdb"
fi

create-db.sh -H $desthost -d $destdbname -u $user -p "$password" -l $logfile
if [ $? -ne 0 ]
then
		error "cannot create $destdb"
		exit 1
fi

exec-sql.sh -H $desthost -d $destdbname -u $user -p "$password" -f "$dump" -l $logfile -o /dev/null > /dev/null
if [ $? -ne 0 ]
then
		error "cannot load $dump in $destdb"
		exit 1
fi

exec-sql.sh -H $desthost -d $destdbname -u $user -p "$password" -c "vacuum analyze;" -l $logfile -o /dev/null
if [ $? -ne 0 ]
then
		error "cannot vacuum in $destdb"
fi

rm -f $psqllog

exit 0
