namespace eval ::process {
	package require Expect
}

proc ::process::Kill {pProcessIDList args} {
	set lPGroup 0
	set lSignal 15
	
	foreach lOption $args {
		if {($lOption == "-pgroup")} {
			set lPGroup 1
		} else {
			set lSignal $lOption
		}
	}
	
	set lResult ""
	
	foreach lProcessID $pProcessIDList {
		if {($lPgroup == 1)} {
			set lProcessID "-$lProcessID"
		}
		set lError [exec /bin/kill "-$lSignal $lProcessID]
		if {($lError != 0)} {
			lappend lResult {$lProcessID $lError}			
		}
	}

	return $lResult
}

proc ::process::Get {pProcessInfo} {
	set lProcessList [exec /bin/ps -e -o "uid pid ppid cmd"]
	set lProcessList [split $lProcessList "\n"]

	set lNewProcessList ""
	
	foreach lProcess $lProcessList {
		if {([lsearch -glob $lProcess "*$pProcessInfo*"] != -1)} {
			set lNewProcess ""
			foreach lElement [split [string trim $lProcess] " "] {
				if {($lElement != "")} {
					lappend lNewProcess $lElement
				}
			}

			if {($lNewProcess != "")} {
				set lNewProcess [linsert $lNewProcess 0 "user_id"]
				set lNewProcess [linsert $lNewProcess 2 "process_id"]
				set lNewProcess [linsert $lNewProcess 4 "parent_process_id"]
				set lNewProcess [linsert $lNewProcess 6 "command"]
				set lCommand [join [lrange $lNewProcess 7 end] " "]
				set lNewProcess [lreplace $lNewProcess 7 end $lCommand]
				lappend lNewProcessList $lNewProcess
			}
		}
	}
	return $lNewProcessList
}
	
proc ::process::Top {} {
	set lTopList [exec /usr/local/bin/top]
	set lTopList [split $lTopList "\n"]
	
	set lTopList [lreplace $lTopList 0 6]
	set lTopList [lreplace $lTopList end end]
	
	return $lTopList
}

proc ::process::CountInstances {pProcessInfo} {
	return [llength [::process::Get $pProcessInfo]]
}

proc ::process::BackGround {} {
		trap SIG_IGN {TTIN TSTP}

		if {([catch {set lFork [fork]}] != 0)} {
			error "background:  failed to fork process" {} \
				[list BACKGROUND 1]
		}

		if {($lFork == -1)} {
			error "background:  failed to fork process" {} \
				[list BACKGROUND 1]
		} elseif {($lFork > 0)} {
			exit
		}

		disconnect
		
		trap SIG_IGN HUP
		
		if {([catch {set lFork [fork]}] != 0)} {
			error "background:  failed to fork process" {} \
				[list BACKGROUND 2]
		}

		if {($lFork == -1)} {
			error "background:  failed to fork process" {} \
				[list BACKGROUND 2]
		} elseif {($lFork > 0)} {
			exit
		}

		if {([catch {cd /}] != 0)} {
			error "background:  unable to move to root (/)" {} \
				[list BACKGROUND 3]
		}
		
		trap SIG_IGN CHLD
}
