/***************************************************************************
                          conf.l  -  description                              
                             -------------------                                         
    begin                : Wed Sep 11 2002                                           
    copyright            : (C) 2002 by Shridhar Daithankar                         
    email                : shridhar_daithankar@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

%{
/* Comments and definitions goes here. So does options. */
/* Specifically, if you want to use more than one lexical file in each */
/* project you will have to use the option '%option prefix="whatever"'.*/
/* This will replace the "yy" part in function and variable names with */
/* the string "whatever". For more information, as well as documentation */
/* of other options, see the GNU Flex manual. */


#include "base.h"
#include "conf.tab.h"

%}

%x comment
%option noyywrap

%%

"#"				{BEGIN(comment);}
<comment>.			{;}
<comment>\n			{BEGIN(INITIAL);}


[0-9]+				{yylval.num=atoi(yytext);return NUM;}

[" "\t\n]	 		{;}
username     			{return USERNAME;}
password 					{return PASSWORD;}
interval 					{return INTERVAL;}
unit 							{return UNIT;}
insertthreshold	 	{return INSERTTHRESHOLD;}
insertThreshold	 	{return INSERTTHRESHOLD;}

updatethreshold	 	{return UPDATETHRESHOLD;}
updateThreshold	 	{return UPDATETHRESHOLD;}

deletethreshold	 	{return DELETETHRESHOLD;}
deleteThreshold	 	{return DELETETHRESHOLD;}

database	 				{return DATABASE;}
end		 						{return ENDDATABASE;}

[a-zA-Z0-9]{1,50}	{strncpy(yylval.str,yytext,50);return STRING;}
.									{strncpy(yylval.str,yytext,50); return yytext[0];}
%%




