/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Wed Sep 11 20:06:35 IST 2002
    copyright            : (C) 2002 by Shridhar Daithankar
    email                : shridhar_daithankar@yahoo.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream.h>
#include <stdlib.h>
#include "init.h"

int main(int argc, char *argv[])
{
 node *n;
 database *d;

 if(signal(SIGHUP,sig_handler)==SIG_ERR)
 {
  fprintf(stderr,"Can not install signal handler for SIGHUP. Quitting..\n");
  exit(-1);
 }
 if(signal(SIGTERM,sig_handler)==SIG_ERR)
 {
  fprintf(stderr,"Can not install signal handler for SIGHUP. Quitting..\n");
  exit(-1);
 }

 init();

 /*fprintf(stderr,"Global settings:\nInterval=%d\tIT=%d\tUT=%d\tDT=%d\n",
 global->interval,global->insertThreshold,global->updateThreshold,global->deleteThreshold);

 fprintf(stderr,"User %s\tPassword %s\n",
 global->username,global->password);*/

 while(1)
 {
  sleep(unit);

  //Check if we need to reread the resource file, as indicated by SIGHUP
  if(reInit)
  {
   init();
   reInit=false;
  }

  if(quit)break;

  for(n=databaseList->head;n;n=n->next)
  {
   d=(database *)n->ptr;
   d->count++;

   if(d->count>=d->interval)
   {
    d->autoVacuum();
    d->count=0;
   }
  }
 }

 return EXIT_SUCCESS;
}
