/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.User;

public class Sequence
extends DBObject {
    private long last_value = 0L;
    private long increment_by = 0L;
    private long max_value = 0L;
    private long min_value = 0L;
    private long cache_value = 0L;
    private boolean cycled = false;
    private boolean called = false;
    private long start = 0L;
    private String description = null;

    public Sequence(DBObject owner, String _name) {
        super(owner);
        this.search(_name);
    }

    public Sequence(DBObject owner) {
        super(owner);
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP SEQUENCE ");
        retorno.append(this.getName()).append(";\n");
        return retorno.toString();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE SEQUENCE ");
        retorno.append(this.getName()).append(" ");
        if (this.getIncrementBy() > 1L) {
            retorno.append("\n\tINCREMENT ").append(this.getIncrementBy()).append(" ");
        }
        if (this.getMinValue() > 0L) {
            retorno.append("\n\tMINVALUE ").append(this.getMinValue()).append(" ");
        }
        if (this.getMaxValue() > 0L) {
            retorno.append("\n\tMAXVALUE ").append(this.getMaxValue()).append(" ");
        }
        if (this.getStart() > 0L) {
            retorno.append("\n\tSTART ").append(this.getStart()).append(" ");
        }
        if (this.getCacheValue() > 0L) {
            retorno.append("\n\tCACHE ").append(this.getCacheValue()).append(" ");
        }
        if (this.isCycled()) {
            retorno.append("\n\tCYCLE ");
        }
        retorno.append(";\n");
        retorno.append(this.getCommentSQL());
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(String _name) {
        boolean retorno = false;
        try {
            this.initialize();
            PreparedStatement prep = this.getConnection().prepareStatement("SELECT * FROM PG_CLASS WHERE RELNAME=?");
            prep.setString(1, _name);
            ResultSet rs = prep.executeQuery();
            if (rs.next()) {
                this.setName(rs.getString("RELNAME"));
                this.setCreator(new User(this, rs.getLong("RELOWNER")));
                PreparedStatement prep1 = this.getConnection().prepareStatement("SELECT * FROM " + this.getName());
                ResultSet rs1 = prep1.executeQuery();
                if (rs1.next()) {
                    this.setLastValue(rs1.getLong("LAST_VALUE"));
                    this.setIncrementBy(rs1.getLong("INCREMENT_BY"));
                    this.setMaxValue(rs1.getLong("MAX_VALUE"));
                    this.setMinValue(rs1.getLong("MIN_VALUE"));
                    this.setCacheValue(rs1.getLong("CACHE_VALUE"));
                    this.setCycled(rs1.getBoolean("IS_CYCLED"));
                    this.setCalled(rs1.getBoolean("IS_CALLED"));
                    retorno = true;
                }
                rs1.close();
                prep1.close();
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            this.initialize();
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.start = 0L;
        this.last_value = 0L;
        this.increment_by = 0L;
        this.max_value = 0L;
        this.min_value = 0L;
        this.cache_value = 0L;
        this.cycled = false;
        this.called = false;
        this.description = null;
    }

    public long getLastValue() {
        return this.last_value;
    }

    private void setLastValue(long _last_value) {
        this.last_value = _last_value;
    }

    public long getIncrementBy() {
        return this.increment_by;
    }

    public void setIncrementBy(long _increment_by) {
        this.increment_by = _increment_by;
    }

    public long getMaxValue() {
        return this.max_value;
    }

    public void setMaxValue(long _max_value) {
        this.max_value = _max_value;
    }

    public long getMinValue() {
        return this.min_value;
    }

    public void setMinValue(long _min_value) {
        this.min_value = _min_value;
    }

    public long getCacheValue() {
        return this.cache_value;
    }

    public void setCacheValue(long _cache_value) {
        this.cache_value = _cache_value;
    }

    public boolean isCycled() {
        return this.cycled;
    }

    public void setCycled(boolean _cycled) {
        this.cycled = _cycled;
    }

    public boolean isCalled() {
        return this.called;
    }

    private void setCalled(boolean _called) {
        this.called = _called;
    }

    private long getStart() {
        return this.start;
    }

    public void setStart(long _start) {
        this.start = _start;
    }

    private String getCommentSQL() {
        String retorno = new String();
        if (this.getDescription().length() > 0) {
            retorno = "COMMENT ON SEQUENCE " + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return retorno;
    }

    public String getDescription() {
        if (this.description == null) {
            try {
                PreparedStatement prep = this.getConnection().getDatabaseVersion() < 7.2 ? this.getConnection().prepareStatement("select obj_description(oid) as DESCRIPTION from pg_class where RELNAME=? ") : this.getConnection().prepareStatement("select obj_description(oid, relname) as DESCRIPTION from pg_class where RELNAME=? ");
                prep.setString(1, this.getName());
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    this.setDescription(rs.getString("DESCRIPTION"));
                } else {
                    this.setDescription(new String());
                }
                rs.close();
                prep.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description != null ? _description : new String();
    }

    public void refresh() {
        this.search(this.getName());
    }
}

