/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import pgclibrary.objects.AttributeType;
import pgclibrary.objects.DBObject;

public class TableColumn
extends DBObject {
    private int col_number = 0;
    private int size = 0;
    private boolean allow_nulls = false;
    private AttributeType column_type = null;
    private String default_value = null;
    private String description = null;

    public TableColumn(DBObject owner, String _name) {
        super(owner);
        this.search(_name);
    }

    public String getDeleteSQL() {
        return new String();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer(30);
        retorno.append(this.getName());
        retorno.append(" ");
        if (this.getColumnType() != null) {
            retorno.append(this.getColumnType().getName().toUpperCase());
            retorno.append(" ");
            if (this.getColumnType().getSize() < 0) {
                retorno.append("(");
                retorno.append(this.getSize());
                retorno.append(") ");
            }
        }
        if (!this.allowNulls()) {
            retorno.append("NOT NULL ");
        }
        if (this.getDefaultValue() != null && this.getDefaultValue().trim().length() > 0) {
            retorno.append("DEFAULT ");
            retorno.append(this.getDefaultValue());
        }
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(String _name) {
        boolean retorno = false;
        try {
            this.initialize();
            PreparedStatement prep = this.getConnection().prepareStatement("select pg_attribute.*,  case when pg_attribute.attlen > 0 then pg_attribute.attlen                  else pg_attribute.atttypmod-4 end as colsize  from pg_class, pg_attribute  where pg_attribute.attrelid=pg_class.oid AND pg_class.relname=? and pg_attribute.ATTNAME=? ");
            prep.setString(1, this.getOwner().getName());
            prep.setString(2, _name);
            ResultSet rs = prep.executeQuery();
            if (rs != null && rs.next()) {
                this.setName(rs.getString("ATTNAME"));
                this.setColumnNumber(rs.getInt("attnum"));
                this.setSize(rs.getInt("COLSIZE"));
                this.setAllowNulls(!rs.getBoolean("attnotnull"));
                this.setColumnType(AttributeType.searchObject(rs.getLong("atttypid")));
                retorno = true;
            }
            rs.close();
            prep.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.col_number = 0;
        this.size = 0;
        this.allow_nulls = false;
        this.column_type = null;
        this.default_value = null;
        this.description = null;
    }

    private void setDefaultValue(String _value) {
        this.default_value = _value;
    }

    public String getDefaultValue() {
        if (this.default_value == null) {
            this.default_value = new String();
            try {
                PreparedStatement preps = this.getConnection().prepareStatement("select   adsrc as DEFAULT  from pg_attrdef, pg_class, pg_attribute  WHERE pg_attribute.attrelid = pg_attrdef.adrelid   and pg_attribute.attnum = pg_attrdef.adnum   and pg_attribute.attrelid = pg_class.oid   and pg_class.relname= ? AND pg_attribute.ATTNAME=? ");
                preps.setString(1, this.getOwner().getName());
                preps.setString(2, this.getName());
                ResultSet rs = preps.executeQuery();
                if (rs != null && rs.next()) {
                    this.default_value = rs.getString("DEFAULT");
                }
                rs.close();
                preps.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.default_value;
    }

    private void setColumnNumber(int _col_number) {
        this.col_number = _col_number;
    }

    public int getColumnNumber() {
        return this.col_number;
    }

    private void setSize(int _size) {
        this.size = _size;
    }

    public int getSize() {
        if (this.size > 0) {
            return this.size;
        }
        return this.column_type.getSize();
    }

    private void setAllowNulls(boolean _allow_nulls) {
        this.allow_nulls = _allow_nulls;
    }

    public boolean allowNulls() {
        return this.allow_nulls;
    }

    public AttributeType getColumnType() {
        return this.column_type;
    }

    private void setColumnType(AttributeType _column_type) {
        this.column_type = _column_type;
    }

    public String getDescription() {
        if (this.description == null) {
            try {
                PreparedStatement prep = this.getConnection().getDatabaseVersion() < 7.2 ? this.getConnection().prepareStatement("select obj_description(pg_attribute.oid) as DESCRIPTION from pg_attribute, pg_class where pg_class.oid = pg_attribute.attrelid and RELNAME=? AND ATTNAME=? ") : this.getConnection().prepareStatement("select col_description(attrelid, ATTNUM) as DESCRIPTION from pg_attribute, pg_class where pg_class.oid = pg_attribute.attrelid and RELNAME=? AND ATTNAME=? ");
                prep.setString(1, this.getOwner().getName());
                prep.setString(2, this.getName());
                ResultSet rs = prep.executeQuery();
                if (rs.next()) {
                    this.setDescription(rs.getString("DESCRIPTION"));
                } else {
                    this.setDescription(new String());
                }
                rs.close();
                prep.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description != null ? _description : new String();
    }

    protected String getCommentSQL() {
        String retorno = new String();
        if (this.getDescription().length() > 0) {
            retorno = "COMMENT ON COLUMN " + this.getOwner().getName() + "." + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return retorno;
    }

    public void refresh() {
        this.search(this.getName());
    }
}

