/*
 * TableColumn.java
 *
 * Created on 31 de julio de 2002, 09:20
 */

package pgclibrary.objects;
import java.util.*;
import java.sql.*;
import pgclibrary.dataaccess.*;

/**
 *
 * @author  nestor
 */
public class TableColumn extends DBObject {
    private int col_number = 0;
    private int size = 0;
    private boolean allow_nulls = false;
    private AttributeType column_type = null;
    private String default_value = null;
    private String description = null;
    
    public TableColumn(DBObject owner, String _name) {
        super(owner);
        search(_name);
    }
    
    /** Retrieve the SQL string that eliminate this object from
     * the database.
     * @return SQL DML string.
     */
    public String getDeleteSQL() {
        return new String();
    }
    
    /** Returns the SQL string that
     * generate this object.
     * @return SQL DML instruction for generation.
     */
    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer(30);
        retorno.append(getName());
        retorno.append(" ");
        
        if(getColumnType() != null){
            retorno.append(getColumnType().getName().toUpperCase());
            retorno.append(" ");
            if(getColumnType().getSize() < 0){
                retorno.append("(");
                retorno.append(getSize());
                retorno.append(") ");
            }
        }
        if(!allowNulls()){
            retorno.append("NOT NULL ");
        }
        if ((getDefaultValue() != null) && (getDefaultValue().trim().length() > 0)){
            retorno.append("DEFAULT ");
            retorno.append(getDefaultValue());
        }
        return retorno.toString();
    }
    
    /** Retrieve the SQL String that implements this
     * object modifications.
     * @return SQL DML String.
     */
    public String getUpdateSQL() {
        return new String();
    }
    
    /** Find the object asociated with the ATTNUM.
     * @param _attnum ATTTNUM to search.
     * @return true if the object was found
     */
    public boolean search(String _name) {
        boolean retorno = false;
        try{
            initialize();
            
            PreparedStatement prep = getConnection().prepareStatement("select pg_attribute.*, "
            + " case when pg_attribute.attlen > 0 then pg_attribute.attlen "
            + "                 else pg_attribute.atttypmod-4 end as colsize "
            + " from pg_class, pg_attribute "
            + " where pg_attribute.attrelid=pg_class.oid AND pg_class.relname=? and pg_attribute.ATTNAME=? ");
            prep.setString(1, getOwner().getName());
            prep.setString(2, _name);
            ResultSet rs = prep.executeQuery();
            if((rs != null) && (rs.next())){
                setName(rs.getString("ATTNAME"));
                setColumnNumber(rs.getInt("attnum"));
                setSize(rs.getInt("COLSIZE"));
                setAllowNulls(!rs.getBoolean("attnotnull"));
                setColumnType(AttributeType.searchObject(rs.getLong("atttypid")));
                retorno = true;
            }
            rs.close();
            prep.close();
        } catch (SQLException e){
            e.printStackTrace();
        }
        return retorno;
    }
    
    public void initialize(){
        super.initialize();
        col_number = 0;
        size = 0;
        allow_nulls = false;
        column_type = null;
        default_value = null;
        description = null;
    }
    
    // ---------SET AND GET-------------
    private void setDefaultValue(String _value){
         default_value = _value;
    }
    public String getDefaultValue(){
        if (default_value == null){
            default_value = new String();
            try{
                PreparedStatement preps = getConnection().prepareStatement("select  "
                + " adsrc as DEFAULT "
                + " from pg_attrdef, pg_class, pg_attribute "
                + " WHERE pg_attribute.attrelid = pg_attrdef.adrelid "
                + "  and pg_attribute.attnum = pg_attrdef.adnum "
                + "  and pg_attribute.attrelid = pg_class.oid "
                + "  and pg_class.relname= ? AND pg_attribute.ATTNAME=? ");
                preps.setString(1, getOwner().getName());
                preps.setString(2, getName());
                ResultSet rs = preps.executeQuery();
                if((rs != null)  && rs.next()){
                    default_value = rs.getString("DEFAULT");
                }
                rs.close();
                preps.close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return default_value;
    }
    
    private void setColumnNumber(int _col_number){
        col_number = _col_number;
    }
    public int getColumnNumber(){
        return col_number;
    }
    
    private void setSize(int _size){
        size = _size;
    }
    public int getSize(){
        if(size > 0){
            return size;
        } else {
            return column_type.getSize();
        }
    }
    
    private void setAllowNulls(boolean _allow_nulls){
        allow_nulls = _allow_nulls;
    }
    public boolean allowNulls(){
        return allow_nulls;
    }
    
    public AttributeType getColumnType(){
        return column_type;
    }
    private void setColumnType(AttributeType _column_type){
        column_type = _column_type;
    }
    
    public String getDescription(){
        if(description == null){
            try{
                PreparedStatement prep;
                
                if(getConnection().getDatabaseVersion() < 7.2){
                    prep = getConnection().prepareStatement("select obj_description(pg_attribute.oid) as DESCRIPTION from pg_attribute, pg_class where pg_class.oid = pg_attribute.attrelid and RELNAME=? AND ATTNAME=? ");
                } else {
                    prep = getConnection().prepareStatement("select col_description(attrelid, ATTNUM) as DESCRIPTION from pg_attribute, pg_class where pg_class.oid = pg_attribute.attrelid and RELNAME=? AND ATTNAME=? ");
                }
                prep.setString(1, getOwner().getName());
                prep.setString(2, getName());
                
                ResultSet rs = prep.executeQuery();
                if(rs.next()){
                    setDescription(rs.getString("DESCRIPTION"));
                } else {
                    setDescription(new String());
                }
                rs.close();
                prep.close();
            } catch (SQLException e){
                e.printStackTrace();
            }
        }
        return description;
    }
    public void setDescription(String _description){
        if(_description != null){
            description = _description;
        } else {
            description = new String();
        }
    }
    
    protected String getCommentSQL(){
        String retorno = new String();
        if(getDescription().length() > 0){
            retorno = "COMMENT ON COLUMN " + getOwner().getName() + "." 
                + getName() + " IS '" + getDescription() + "'; \n"; 
        }
        return retorno;
    }
    
    /** refresh the data from database.
     */
    public void refresh() {
        search(getName());
    }
    
}
