/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Vector;
import pgclibrary.dataaccess.dataSource;
import pgclibrary.dataaccess.dataSourceVector;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.TableColumn;
import pgclibrary.objects.TableIndex;
import pgclibrary.objects.User;
import pgclibrary.utilities.Utilities;

public class Table
extends DBObject {
    private long pages_number = 0L;
    private Vector columns = null;
    private Vector index = null;
    private String description = null;

    public Table(DBObject owner, String _name) {
        super(owner);
        this.search(_name);
    }

    public Table(DBObject owner) {
        super(owner);
    }

    public void insertRecord(Vector values) throws SQLException {
        PreparedStatement prep = this.prepareInsertStatement();
        int i = 0;
        while (i < this.getColumns().size()) {
            this.setStatementValue(prep, (String)values.get(i), (TableColumn)this.getColumns().get(i), i + 1);
            ++i;
        }
        prep.executeUpdate();
        prep.close();
    }

    public void updateRecord(Vector values) throws SQLException {
        PreparedStatement prep = this.prepareUpdateStatement();
        int values_idx = 0;
        int i = 0;
        while (i < this.getColumns().size()) {
            this.setStatementValue(prep, (String)values.get(values_idx), (TableColumn)this.getColumns().get(i), values_idx + 1);
            ++values_idx;
            ++i;
        }
        Vector cols = ((TableIndex)this.getPrimaryKeys().get(0)).getColumns();
        int i2 = 0;
        while (i2 < cols.size()) {
            this.setStatementValue(prep, (String)values.get(values_idx), (TableColumn)cols.get(i2), values_idx + 1);
            ++values_idx;
            ++i2;
        }
        prep.executeUpdate();
        prep.close();
    }

    public void deleteRecord(Vector values) throws SQLException {
        PreparedStatement prep = this.prepareDeleteStatement();
        Vector cols = ((TableIndex)this.getPrimaryKeys().get(0)).getColumns();
        int i = 0;
        while (i < cols.size()) {
            this.setStatementValue(prep, (String)values.get(i), (TableColumn)cols.get(i), i + 1);
            ++i;
        }
        prep.executeUpdate();
        prep.close();
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("DROP TABLE ");
        retorno.append(this.getName());
        retorno.append("; \n\t");
        return retorno.toString();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        retorno.append("CREATE TABLE ");
        retorno.append(this.getName());
        retorno.append(" ( \n\t");
        int i = 0;
        while (i < this.getColumns().size()) {
            TableColumn tc = (TableColumn)this.getColumns().get(i);
            retorno.append(tc.getInsertSQL());
            retorno.append(", \n\t");
            ++i;
        }
        Vector tmp = this.getPrimaryKeys();
        int i2 = 0;
        while (i2 < tmp.size()) {
            retorno.append(((TableIndex)tmp.get(i2)).getInsertSQL());
            ++i2;
        }
        retorno.append(" );\n");
        tmp = this.getNotPrimaryKeyIndex();
        int i3 = 0;
        while (i3 < tmp.size()) {
            retorno.append(((TableIndex)tmp.get(i3)).getInsertSQL());
            retorno.append("\n");
            ++i3;
        }
        retorno.append(this.getCommentSQL());
        int i4 = 0;
        while (i4 < this.getColumns().size()) {
            TableColumn tc = (TableColumn)this.getColumns().get(i4);
            retorno.append(tc.getCommentSQL());
            ++i4;
        }
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(String _name) {
        boolean retorno = false;
        try {
            this.initialize();
            ResultSet rs = this.getConnection().getQueryGenerator().getTable(_name);
            if (rs != null && rs.next()) {
                this.setName(rs.getString("TABLE_NAME"));
                this.setNumberOfPages(rs.getLong("TABLE_PAGES"));
                this.setCreator(new User((DBObject)this, rs.getString("TABLE_OWNER")));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.pages_number = 0L;
        this.columns = null;
        this.index = null;
        this.description = null;
    }

    public dataSource getColumnsTable() {
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Col #");
        dsve.addColumnName("Name");
        dsve.addColumnName("Type");
        dsve.addColumnName("Size");
        dsve.addColumnName("Nulls");
        dsve.addColumnName("Default");
        dsve.addColumnName("Description");
        dsve.addColumnSize(10);
        dsve.addColumnSize(20);
        dsve.addColumnSize(15);
        dsve.addColumnSize(5);
        dsve.addColumnSize(5);
        dsve.addColumnSize(30);
        dsve.addColumnSize(30);
        Vector temp = this.getColumns();
        int i = 0;
        while (i < temp.size()) {
            TableColumn tc = (TableColumn)temp.get(i);
            Vector<String> elem = new Vector<String>();
            elem.add(String.valueOf(tc.getColumnNumber()));
            elem.add(tc.getName());
            elem.add(tc.getColumnType().getName());
            elem.add(String.valueOf(tc.getSize()));
            elem.add(Utilities.formatBoolean(tc.allowNulls()));
            elem.add(tc.getDefaultValue());
            elem.add(tc.getDescription());
            dsve.addElement(elem);
            ++i;
        }
        return dsve;
    }

    public dataSource getIndexTable() {
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Name");
        dsve.addColumnName("Primary");
        dsve.addColumnName("Unique");
        dsve.addColumnName("Cluster");
        dsve.addColumnName("Columns");
        dsve.addColumnSize(20);
        dsve.addColumnSize(6);
        dsve.addColumnSize(6);
        dsve.addColumnSize(6);
        dsve.addColumnSize(30);
        Vector temp = this.getIndexes();
        int i = 0;
        while (i < temp.size()) {
            TableIndex ti = (TableIndex)this.index.get(i);
            Vector<String> elem = new Vector<String>();
            elem.add(ti.getName());
            elem.add(Utilities.formatBoolean(ti.isPrimary()));
            elem.add(Utilities.formatBoolean(ti.isUnique()));
            elem.add(Utilities.formatBoolean(ti.isClustered()));
            elem.add(ti.getColumnsText());
            dsve.addElement(elem);
            ++i;
        }
        return dsve;
    }

    private void setNumberOfPages(long _pages_number) {
        this.pages_number = _pages_number;
    }

    public long getNumberOfPages() {
        return this.pages_number;
    }

    public Vector getColumns() {
        if (this.columns == null) {
            this.columns = new Vector();
            try {
                ResultSet rs = this.getConnection().getQueryGenerator().getColumnNames(this.getName());
                while (rs != null && rs.next()) {
                    TableColumn tc = new TableColumn(this, rs.getString("COLUMN_NAME"));
                    this.columns.add(tc);
                }
                rs.close();
                rs.getStatement().close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.columns;
    }

    public int getColumnIndex(String _column) {
        _column = _column.toUpperCase();
        int retorno = -1;
        Vector cols = this.getColumns();
        int i = 0;
        while (i < cols.size() && retorno < 0) {
            if (((TableColumn)cols.get(i)).getName().equals(_column)) {
                retorno = i;
            }
            ++i;
        }
        return retorno;
    }

    private Vector getIndexes() {
        if (this.index == null) {
            this.index = new Vector();
            try {
                ResultSet rs = this.getConnection().getQueryGenerator().getIndexNames(this.getName());
                while (rs != null && rs.next()) {
                    TableIndex ti = new TableIndex(this, rs.getString("INDEX_NAME"));
                    this.index.add(ti);
                }
                rs.close();
                rs.getStatement().close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.index;
    }

    public Vector getPrimaryKeys() {
        Vector retorno = new Vector();
        Vector tmp = this.getIndexes();
        int i = 0;
        while (i < tmp.size()) {
            if (((TableIndex)tmp.get(i)).isPrimary()) {
                retorno.add(tmp.get(i));
            }
            ++i;
        }
        return retorno;
    }

    public Vector getNotPrimaryKeyIndex() {
        Vector retorno = new Vector();
        Vector tmp = this.getIndexes();
        int i = 0;
        while (i < tmp.size()) {
            if (!((TableIndex)tmp.get(i)).isPrimary()) {
                retorno.add(tmp.get(i));
            }
            ++i;
        }
        return retorno;
    }

    private PreparedStatement prepareInsertStatement() throws SQLException {
        StringBuffer sqlComm = new StringBuffer();
        sqlComm.append("INSERT INTO ");
        sqlComm.append(this.getName());
        sqlComm.append(" ( ");
        int i = 0;
        while (i < this.getColumns().size()) {
            TableColumn tc = (TableColumn)this.getColumns().get(i);
            sqlComm.append(tc.getName());
            if (i < this.getColumns().size() - 1) {
                sqlComm.append(", ");
            }
            ++i;
        }
        sqlComm.append(" ) VALUES ( ");
        int i2 = 0;
        while (i2 < this.getColumns().size()) {
            sqlComm.append(" ?");
            if (i2 < this.getColumns().size() - 1) {
                sqlComm.append(", ");
            }
            ++i2;
        }
        sqlComm.append(" )");
        return this.getConnection().prepareStatement(sqlComm.toString());
    }

    private PreparedStatement prepareUpdateStatement() throws SQLException {
        StringBuffer sqlComm = new StringBuffer();
        sqlComm.append("UPDATE ");
        sqlComm.append(this.getName());
        sqlComm.append(" SET ");
        int i = 0;
        while (i < this.getColumns().size()) {
            TableColumn tc = (TableColumn)this.getColumns().get(i);
            sqlComm.append(tc.getName());
            sqlComm.append("= ? ");
            if (i < this.getColumns().size() - 1) {
                sqlComm.append(", ");
            }
            ++i;
        }
        sqlComm.append(" WHERE ");
        Vector cols = ((TableIndex)this.getPrimaryKeys().get(0)).getColumns();
        int i2 = 0;
        while (i2 < cols.size()) {
            TableColumn tc = (TableColumn)cols.get(i2);
            sqlComm.append(tc.getName());
            sqlComm.append("=? ");
            if (i2 < cols.size() - 1) {
                sqlComm.append(" and ");
            }
            ++i2;
        }
        return this.getConnection().prepareStatement(sqlComm.toString());
    }

    private PreparedStatement prepareDeleteStatement() throws SQLException {
        StringBuffer sqlComm = new StringBuffer();
        sqlComm.append("DELETE FROM ");
        sqlComm.append(this.getName());
        sqlComm.append(" WHERE ");
        Vector cols = ((TableIndex)this.getPrimaryKeys().get(0)).getColumns();
        int i = 0;
        while (i < cols.size()) {
            TableColumn tc = (TableColumn)cols.get(i);
            sqlComm.append(tc.getName());
            sqlComm.append("=? ");
            if (i < cols.size() - 1) {
                sqlComm.append(" and ");
            }
            ++i;
        }
        return this.getConnection().prepareStatement(sqlComm.toString());
    }

    private void setStatementValue(PreparedStatement prep, String value, TableColumn tc, int _prepcolumn) {
        int type = (int)tc.getColumnType().getSQLType();
        if (type < 0) {
            type = 1;
        }
        try {
            if (value != null && value.length() > 0) {
                switch (type) {
                    case -7: {
                        prep.setBoolean(_prepcolumn, Utilities.parseBoolean(value));
                        break;
                    }
                    case 1: {
                        prep.setString(_prepcolumn, value);
                        break;
                    }
                    case 4: {
                        prep.setInt(_prepcolumn, Integer.parseInt(value));
                        break;
                    }
                    case 91: {
                        prep.setDate(_prepcolumn, new Date(Utilities.parseDate(value, "MM/dd/yyyy").getTime()));
                        break;
                    }
                    case 92: {
                        prep.setTime(_prepcolumn, new Time(Utilities.parseDate(value, "HH:mm:ss").getTime()));
                        break;
                    }
                    case 93: {
                        prep.setTimestamp(_prepcolumn, new Timestamp(Utilities.parseDate(value, "MM/dd/yyyy HH:mm:ss").getTime()));
                        break;
                    }
                    case 8: {
                        prep.setDouble(_prepcolumn, Double.parseDouble(value));
                    }
                }
            } else {
                prep.setNull(_prepcolumn, type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getCommentSQL() {
        String retorno = new String();
        if (this.getDescription().length() > 0) {
            retorno = "COMMENT ON TABLE " + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return retorno;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getConnection().getQueryGenerator().getTableDescription(this.getName());
        }
        return this.description;
    }

    public void setDescription(String _description) {
        this.description = _description != null ? _description : new String();
    }

    public void refresh() {
        this.search(this.getName());
    }
}

