/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.TableColumn;

public class TableIndex
extends DBObject {
    private boolean clustered = false;
    private boolean keytype = false;
    private boolean unique = false;
    private boolean primary = false;
    private Vector columns = null;
    private String description = null;

    public TableIndex(DBObject owner, String _name) {
        super(owner);
        this.search(_name);
    }

    public String getDeleteSQL() {
        StringBuffer retorno = new StringBuffer(50);
        retorno.append(" DROP INDEX ");
        retorno.append(this.getName()).append(";\n");
        return retorno.toString();
    }

    public String getInsertSQL() {
        StringBuffer retorno = new StringBuffer();
        if (this.isPrimary()) {
            retorno.append("CONSTRAINT ");
            retorno.append(this.getName());
            retorno.append(" PRIMARY KEY (");
            retorno.append(this.getColumnsText());
            retorno.append(" ) \n");
        } else {
            retorno.append("CREATE ");
            if (this.isUnique()) {
                retorno.append("UNIQUE ");
            }
            retorno.append("INDEX ");
            retorno.append(this.getName());
            retorno.append(" ON ");
            retorno.append(this.getOwner().getName());
            retorno.append(" ( ");
            retorno.append(this.getColumnsText());
            retorno.append(" ); \n");
        }
        retorno.append(this.getCommentSQL());
        return retorno.toString();
    }

    public String getUpdateSQL() {
        return new String();
    }

    public boolean search(String _name) {
        boolean retorno = false;
        try {
            ResultSet rs = this.getConnection().getQueryGenerator().getIndex(_name);
            if (rs != null && rs.next()) {
                this.setName(rs.getString("INDEX_NAME"));
                this.setClustered(rs.getBoolean("INDEX_CLUSTER"));
                this.setHasKeyType(rs.getBoolean("INDEX_HASH"));
                this.setUnique(rs.getBoolean("INEDEX_UNIQUE"));
                this.setPrimary(rs.getBoolean("INDEX_PRIMARY"));
                retorno = true;
            }
            rs.close();
            rs.getStatement().close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return retorno;
    }

    public void initialize() {
        super.initialize();
        this.clustered = false;
        this.keytype = false;
        this.unique = false;
        this.primary = false;
        this.columns = null;
        this.description = null;
    }

    public Vector getColumns() {
        if (this.columns == null) {
            this.columns = new Vector();
            try {
                ResultSet rs = this.getConnection().getQueryGenerator().getColumnNames(this.getName());
                while (rs != null && rs.next()) {
                    TableColumn tc = new TableColumn(this, rs.getString("COLUMN_NAME"));
                    this.columns.add(tc);
                }
                rs.close();
                rs.getStatement().close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return this.columns;
    }

    public String getColumnsText() {
        StringBuffer retorno = new StringBuffer();
        int i = 0;
        while (i < this.getColumns().size()) {
            TableColumn tc = (TableColumn)this.columns.get(i);
            retorno.append(tc.getName());
            if (i < this.columns.size() - 1) {
                retorno.append(", ");
            }
            ++i;
        }
        return retorno.toString();
    }

    public int getColumnIndex(String _column_name) {
        _column_name = _column_name.toUpperCase();
        int retorno = -1;
        if (_column_name != null) {
            int i = 0;
            while (i < this.getColumns().size() && retorno < 0) {
                TableColumn tc = (TableColumn)this.columns.get(i);
                if (tc.getName().toUpperCase().equals(_column_name)) {
                    retorno = i;
                }
                ++i;
            }
        }
        return retorno;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setClustered(boolean _clustered) {
        this.clustered = _clustered;
    }

    private void setHasKeyType(boolean _keytype) {
        this.keytype = _keytype;
    }

    public boolean hasKeyType() {
        return this.keytype;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean _unique) {
        this.unique = _unique;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean _primary) {
        this.primary = _primary;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = this.getConnection().getQueryGenerator().getTableDescription(this.getName());
        }
        return this.description;
    }

    private String getCommentSQL() {
        String retorno = new String();
        if (this.getDescription().length() > 0) {
            retorno = "COMMENT ON INDEX " + this.getName() + " IS '" + this.getDescription() + "'; \n";
        }
        return retorno;
    }

    protected void setDescription(String _description) {
        this.description = _description != null ? _description : new String();
    }

    public void refresh() {
        this.search(this.getName());
    }
}

