/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.postgresql.Connection;
import org.postgresql.ResultSet;
import org.postgresql.util.PSQLException;

public class Serialize {
    protected Connection conn;
    protected String tableName;
    protected String className;
    protected Class ourClass;
    private static final String[][] tp = new String[][]{{"boolean", "bool"}, {"double", "float8"}, {"float", "float4"}, {"int", "int4"}, {"long", "int8"}, {"short", "int2"}, {"java.lang.String", "text"}, {"java.lang.Integer", "int4"}, {"java.lang.Float", "float4"}, {"java.lang.Double", "float8"}, {"java.lang.Short", "int2"}, {"char", "char"}, {"byte", "int2"}};

    public Serialize(Connection connection, Class clazz) throws SQLException {
        this(connection, clazz.getName());
    }

    public Serialize(Connection connection, Object object) throws SQLException {
        this(connection, object.getClass().getName());
    }

    public Serialize(Connection connection, String string) throws SQLException {
        try {
            this.conn = connection;
            DriverManager.println("Serialize: initializing instance for type: " + string);
            this.tableName = Serialize.toPostgreSQL(string);
            this.className = string;
            this.ourClass = Class.forName(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            DriverManager.println("Serialize: " + this.className + " java class not found");
            throw new PSQLException("postgresql.serial.noclass", (Object)string);
        }
        boolean bl = false;
        java.sql.ResultSet resultSet = this.conn.ExecSQL("select typname from pg_type,pg_class where typname=relname and typname='" + this.tableName + "'");
        if (resultSet != null) {
            if (resultSet.next()) {
                bl = true;
                DriverManager.println("Serialize: " + this.tableName + " table found");
            }
            resultSet.close();
        }
        if (!bl) {
            DriverManager.println("Serialize: " + this.tableName + " table not found");
            throw new PSQLException("postgresql.serial.table", (Object)string);
        }
    }

    public static void create(Connection connection, Class clazz) throws SQLException {
        if (clazz.isInterface()) {
            throw new PSQLException("postgresql.serial.interface");
        }
        String string = Serialize.toPostgreSQL(clazz.getName());
        java.sql.ResultSet resultSet = connection.ExecSQL("select relname from pg_class where relname = '" + string + "'");
        if (resultSet.next()) {
            DriverManager.println("Serialize.create: table " + string + " exists, skipping");
            resultSet.close();
            return;
        }
        DriverManager.println("Serialize.create: table " + string + " not found, creating");
        StringBuffer stringBuffer = new StringBuffer("create table ");
        stringBuffer.append(string);
        int n = 40;
        Field[] fieldArray = clazz.getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            Class<?> clazz2 = fieldArray[n2].getType();
            if (!fieldArray[n2].getName().equals("oid")) {
                stringBuffer.append((char)n);
                stringBuffer.append(fieldArray[n2].getName());
                stringBuffer.append(' ');
                n = 44;
                if (!clazz2.isArray()) {
                    String string2 = clazz2.getName();
                    int n3 = 0;
                    while (n3 < tp.length && !tp[n3][0].equals(string2)) {
                        ++n3;
                    }
                    if (n3 < tp.length) {
                        stringBuffer.append(tp[n3][1]);
                    } else {
                        Serialize.create(connection, clazz2);
                        stringBuffer.append(Serialize.toPostgreSQL(string2));
                    }
                }
            }
            ++n2;
        }
        stringBuffer.append(")");
        DriverManager.println("Serialize.create: " + stringBuffer);
        connection.ExecSQL(stringBuffer.toString());
    }

    public static void create(Connection connection, Object object) throws SQLException {
        Serialize.create(connection, object.getClass());
    }

    public Object fetch(int n) throws SQLException {
        try {
            Object object;
            DriverManager.println("Serialize.fetch: attempting to instantiate object of type: " + this.ourClass.getName());
            Object t = this.ourClass.newInstance();
            DriverManager.println("Serialize.fetch: instantiated object of type: " + this.ourClass.getName());
            Field[] fieldArray = this.ourClass.getFields();
            boolean bl = false;
            int n2 = -1;
            StringBuffer stringBuffer = new StringBuffer("select");
            int n3 = 32;
            int n4 = 0;
            while (n4 < fieldArray.length) {
                object = fieldArray[n4].getName();
                if (((String)object).equals("oid")) {
                    bl = true;
                    n2 = n4;
                }
                stringBuffer.append((char)n3);
                stringBuffer.append((String)object);
                n3 = 44;
                ++n4;
            }
            stringBuffer.append(" from ");
            stringBuffer.append(this.tableName);
            stringBuffer.append(" where oid=");
            stringBuffer.append(n);
            DriverManager.println("Serialize.fetch: " + stringBuffer.toString());
            object = this.conn.ExecSQL(stringBuffer.toString());
            if (object != null) {
                if (object.next()) {
                    int n5 = 0;
                    while (n5 < fieldArray.length) {
                        if (!Modifier.isFinal(fieldArray[n5].getModifiers())) {
                            if (fieldArray[n5].getType().getName().equals("short")) {
                                fieldArray[n5].setShort(t, object.getShort(n5 + 1));
                            } else if (fieldArray[n5].getType().getName().equals("char")) {
                                fieldArray[n5].setChar(t, object.getString(n5 + 1).toCharArray()[0]);
                            } else if (fieldArray[n5].getType().getName().equals("byte")) {
                                fieldArray[n5].setByte(t, object.getByte(n5 + 1));
                            } else if (fieldArray[n5].getType().getName().equals("boolean")) {
                                if (object.getString(n5 + 1).equals("t")) {
                                    fieldArray[n5].setBoolean(t, true);
                                } else {
                                    fieldArray[n5].setBoolean(t, false);
                                }
                            } else {
                                fieldArray[n5].set(t, object.getObject(n5 + 1));
                            }
                        }
                        ++n5;
                    }
                }
            } else {
                throw new PSQLException("postgresql.unexpected");
            }
            object.close();
            return t;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException.toString());
        }
        catch (InstantiationException instantiationException) {
            throw new SQLException(instantiationException.toString());
        }
    }

    private String fixString(String string) {
        StringTokenizer stringTokenizer;
        StringBuffer stringBuffer;
        int n = -1;
        if (string == null) {
            return "";
        }
        n = string.indexOf("'");
        if (n > -1) {
            stringBuffer = new StringBuffer();
            stringTokenizer = new StringTokenizer(string, "'");
            if (n > 0) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("''").append(stringTokenizer.nextToken());
            }
            string = stringBuffer.toString();
        }
        if ((n = string.indexOf("\\")) > -1) {
            stringBuffer = new StringBuffer();
            stringTokenizer = new StringTokenizer(string, "\\");
            if (n > 0) {
                stringBuffer.append(stringTokenizer.nextToken());
            }
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append("\\\\").append(stringTokenizer.nextToken());
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public int store(Object object) throws SQLException {
        return (int)this.storeObject(object);
    }

    public long storeObject(Object object) throws SQLException {
        try {
            Object object2;
            CharSequence charSequence;
            Field[] fieldArray = this.ourClass.getFields();
            boolean bl = false;
            int n = -1;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < fieldArray.length) {
                charSequence = fieldArray[n2].getName();
                if (((String)charSequence).equals("oid")) {
                    bl = true;
                    n = n2;
                    bl2 = fieldArray[n2].getInt(object) > 0;
                }
                ++n2;
            }
            charSequence = new StringBuffer(bl2 ? "update " + this.tableName + " set" : "insert into " + this.tableName + " ");
            int n3 = bl2 ? 32 : 40;
            int n4 = 0;
            while (n4 < fieldArray.length) {
                object2 = fieldArray[n4].getName();
                if (!((String)object2).equals("oid")) {
                    ((StringBuffer)charSequence).append((char)n3);
                    n3 = 44;
                    ((StringBuffer)charSequence).append((String)object2);
                    if (bl2) {
                        ((StringBuffer)charSequence).append('=');
                        if (fieldArray[n4].get(object) == null) {
                            ((StringBuffer)charSequence).append("null");
                        } else if (fieldArray[n4].getType().getName().equals("java.lang.String") || fieldArray[n4].getType().getName().equals("char")) {
                            ((StringBuffer)charSequence).append('\'');
                            ((StringBuffer)charSequence).append(this.fixString(fieldArray[n4].get(object).toString()));
                            ((StringBuffer)charSequence).append('\'');
                        } else {
                            ((StringBuffer)charSequence).append(fieldArray[n4].get(object).toString());
                        }
                    }
                }
                ++n4;
            }
            if (bl2) {
                ((StringBuffer)charSequence).append(" where oid = " + fieldArray[n].getInt(object));
            }
            if (!bl2) {
                ((StringBuffer)charSequence).append(") values ");
                n3 = 40;
                int n5 = 0;
                while (n5 < fieldArray.length) {
                    String string = fieldArray[n5].getName();
                    if (!string.equals("oid")) {
                        ((StringBuffer)charSequence).append((char)n3);
                        n3 = 44;
                        if (fieldArray[n5].get(object) == null) {
                            ((StringBuffer)charSequence).append("null");
                        } else if (fieldArray[n5].getType().getName().equals("java.lang.String") || fieldArray[n5].getType().getName().equals("char")) {
                            ((StringBuffer)charSequence).append('\'');
                            ((StringBuffer)charSequence).append(this.fixString(fieldArray[n5].get(object).toString()));
                            ((StringBuffer)charSequence).append('\'');
                        } else {
                            ((StringBuffer)charSequence).append(fieldArray[n5].get(object).toString());
                        }
                    }
                    ++n5;
                }
                ((StringBuffer)charSequence).append(')');
            }
            DriverManager.println("Serialize.store: " + ((StringBuffer)charSequence).toString());
            object2 = (ResultSet)((Object)this.conn.ExecSQL(((StringBuffer)charSequence).toString()));
            if (bl2) {
                if (object2 != null) {
                    ((ResultSet)object2).close();
                }
                return fieldArray[n].getInt(object);
            }
            long l = ((ResultSet)object2).getLastOID();
            ((ResultSet)object2).close();
            if (bl) {
                fieldArray[n].setLong(object, l);
            }
            return l;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException.toString());
        }
    }

    public static String toClassName(String string) throws SQLException {
        string = string.toLowerCase();
        return string.replace('_', '.');
    }

    public static String toPostgreSQL(String string) throws SQLException {
        if ((string = string.toLowerCase()).indexOf("_") > -1) {
            throw new PSQLException("postgresql.serial.underscore");
        }
        if (string.length() > 31 && (string = string.substring(string.lastIndexOf(".") + 1)).length() > 31) {
            throw new PSQLException("postgresql.serial.namelength", (Object)string, new Integer(string.length()));
        }
        return string.replace('.', '_');
    }
}

