/*
 * Decompiled with CFR 0.152.
 */
package components.database;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import pgclibrary.objects.Database;
import pgclibrary.utilities.SUtilities;
import pgclibrary.utilities.Utilities;

public class DatabasePanel
extends JTabbedPane {
    Database database_object = null;
    JTextField name = new JTextField(20);
    JTextField owner = new JTextField(20);
    JTextField encoding = new JTextField(20);
    JTextField location = new JTextField(20);
    JTextField template = new JTextField(20);
    JTextField istemplate = new JTextField(20);
    JTextField allowconn = new JTextField(20);
    JTextArea sql = new JTextArea();

    public DatabasePanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setDatabase(Database database) {
        this.database_object = database;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
    }

    public void refreshProperties() {
        this.refreshDefaultPanel();
    }

    private void insertDefaultTab() {
        this.name.setEditable(false);
        this.owner.setEditable(false);
        this.encoding.setEditable(false);
        this.location.setEditable(false);
        this.template.setEditable(false);
        this.istemplate.setEditable(false);
        this.allowconn.setEditable(false);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.setResizeWeight(0.5);
        this.sql.setEditable(false);
        jSplitPane.setBottomComponent(new JScrollPane(this.sql));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(SUtilities.getHorPanel("Database Name :", this.name));
        jPanel.add(SUtilities.getHorPanel("Is Template :", this.istemplate));
        jPanel.add(SUtilities.getHorPanel("Allow Connections :", this.allowconn));
        jPanel.add(SUtilities.getHorPanel("Encoding :", this.encoding));
        jPanel.add(SUtilities.getHorPanel("Location :", this.location));
        jPanel.add(SUtilities.getHorPanel("Template :", this.template));
        jPanel.add(SUtilities.getHorPanel("Database DBA :", this.owner));
        jSplitPane.setTopComponent(SUtilities.centerComponent(jPanel));
        this.addTab("General", jSplitPane);
    }

    private void refreshDefaultPanel() {
        this.name.setText(this.database_object.getName());
        this.owner.setText(this.database_object.getCreator().getName());
        this.istemplate.setText(Utilities.formatBoolean(this.database_object.isTemplate()));
        this.allowconn.setText(Utilities.formatBoolean(this.database_object.allowConnections()));
        this.sql.setText(this.database_object.getInsertSQL());
        this.encoding.setText(this.database_object.getEncoding());
        this.location.setText(this.database_object.getLocation());
        this.template.setText(this.database_object.getTemplate());
        this.repaint();
    }
}

