/*
 * Decompiled with CFR 0.152.
 */
package components.view;

import components.SQLTable;
import components.SQLTableModel;
import components.view.DataPanelListener;
import components.view.DataPanelOrderDialog;
import components.view.DataPanelToolbar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pgclibrary.dataaccess.dataSourceResultSet;
import pgclibrary.objects.View;

public class DataPanel
extends JPanel {
    private View view = null;
    private SQLTable data_view = new SQLTable();
    private Hashtable tales_order = new Hashtable(100);
    private DataPanelListener listener = null;

    public DataPanel() {
        this.data_view = new SQLTable();
        this.listener = new DataPanelListener(this);
        this.initPanel();
    }

    private void initPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        SQLTableModel sQLTableModel = new SQLTableModel(this.data_view);
        this.data_view.setModel(sQLTableModel);
        this.add((Component)new DataPanelToolbar(this), "North");
        this.add((Component)new JScrollPane(this.data_view), "Center");
    }

    public void refresh() {
        dataSourceResultSet dataSourceResultSet2 = new dataSourceResultSet(this.view.getConnection(), this.generateSQL());
        ((SQLTableModel)this.data_view.getModel()).setDataSource(dataSourceResultSet2);
        this.repaint();
    }

    public void refresh(View view) {
        this.view = view;
        this.refresh();
    }

    private String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.view != null) {
            stringBuffer.append("SELECT * FROM ").append(this.view.getName());
            Vector vector = this.getOrder();
            if (vector.size() > 0) {
                stringBuffer.append(" ORDER BY ");
                int n = 0;
                while (n < vector.size()) {
                    stringBuffer.append(vector.get(n));
                    if (n < vector.size() - 1) {
                        stringBuffer.append(", ");
                    } else {
                        stringBuffer.append(" ");
                    }
                    ++n;
                }
            }
        }
        return stringBuffer.toString();
    }

    public void addOrder(String string) {
        Vector vector = this.getOrder();
        if (string != null && this.getOrderPos(string) < 0) {
            vector.add(string);
        }
    }

    public void clearOrder() {
        this.getOrder().removeAllElements();
    }

    public int getOrderPos(String string) {
        int n = -1;
        Vector vector = this.getOrder();
        int n2 = 0;
        while (n2 < vector.size() && n < 0) {
            if (((String)vector.get(n2)).equals(string)) {
                n = n2;
            }
            ++n2;
        }
        return n;
    }

    public Vector getOrder() {
        Vector vector = (Vector)this.tales_order.get(this.view.getName());
        if (vector == null) {
            vector = new Vector();
            this.tales_order.put(this.view.getName(), vector);
        }
        return vector;
    }

    public View getView() {
        return this.view;
    }

    public DataPanelListener getListener() {
        return this.listener;
    }

    public void showOrderDialog() {
        new DataPanelOrderDialog(this).show();
    }

    public void newRecord() {
    }

    public void editRecord() {
    }

    public void deleteRecord() {
    }
}

