/*
 * Decompiled with CFR 0.152.
 */
package frames;

import frames.PrincipalFrame;
import frames.SQLExecutionComponent;
import frames.SQLExecutionListener;
import frames.SQLExecutionMenu;
import frames.SQLExecutionToolbar;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.sql.SQLException;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.dataaccess.dataSourceResultSet;
import pgclibrary.utilities.SQLTextParser;
import pgclibrary.utilities.Utilities;

public class SQLExecutionFrame
extends JFrame {
    PrincipalFrame frame = null;
    SQLExecutionListener listener = null;
    SQLExecutionMenu menu = null;
    SQLExecutionToolbar toolbar = null;
    SQLExecutionComponent component = null;
    FileWriter log_writer = null;
    BufferedWriter log_output = null;

    public SQLExecutionFrame(PrincipalFrame principalFrame) {
        super("SQL Execution");
        this.frame = principalFrame;
        this.listener = new SQLExecutionListener(this);
        this.menu = new SQLExecutionMenu(this);
        this.setJMenuBar(this.menu);
        this.toolbar = new SQLExecutionToolbar(this);
        this.getContentPane().add((Component)this.toolbar, "North");
        this.component = new SQLExecutionComponent(this);
        this.getContentPane().add((Component)this.component, "Center");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SQLExecutionFrame.this.close();
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                int n = keyEvent.getKeyCode();
                if (n == 116) {
                    SQLExecutionFrame.this.execute();
                }
                if (n == 115) {
                    SQLExecutionFrame.this.executeAll();
                }
                if (n == 10 && (keyEvent.getModifiers() & 2) != 0) {
                    SQLExecutionFrame.this.execute();
                }
                if (n == 90 && (keyEvent.getModifiers() & 2) != 0) {
                    SQLExecutionFrame.this.undo();
                }
                if (n == 82 && (keyEvent.getModifiers() & 2) != 0) {
                    SQLExecutionFrame.this.redo();
                }
            }
        });
        this.enableEvents(1004L);
        this.pack();
    }

    public void close() {
        this.cancelLog();
        this.disableEvents(1004L);
        this.dispose();
    }

    public void refreshValidation() {
        if (this.frame != null) {
            this.menu.refreshValidation();
            this.toolbar.refreshValidation();
            this.component.refreshValidation();
        }
    }

    public void saveFile() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            try {
                FileWriter fileWriter = new FileWriter(jFileChooser.getSelectedFile().getAbsolutePath(), false);
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                bufferedWriter.write(this.component.getText().getText());
                bufferedWriter.close();
                fileWriter.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), "File operation error", 0);
            }
        }
    }

    public void openFile() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0 && jFileChooser.getSelectedFile().isFile()) {
            try {
                FileReader fileReader = new FileReader(jFileChooser.getSelectedFile().getAbsolutePath());
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                this.component.getText().setText("");
                String string = bufferedReader.readLine();
                while (string != null) {
                    this.component.appendText(string);
                    this.component.appendText("\n");
                    string = bufferedReader.readLine();
                }
                bufferedReader.close();
                fileReader.close();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), "File operation error", 0);
            }
        }
    }

    public boolean isLogActive() {
        return this.log_writer != null && this.log_output != null;
    }

    private void writeLog(String string) {
        if (this.isLogActive()) {
            try {
                this.log_output.write(string);
                this.log_output.write("\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void initLog() {
        JFileChooser jFileChooser;
        int n;
        if (!this.isLogActive() && (n = (jFileChooser = new JFileChooser()).showOpenDialog(this)) == 0) {
            try {
                this.log_writer = new FileWriter(jFileChooser.getSelectedFile().getAbsolutePath(), true);
                this.log_output = new BufferedWriter(this.log_writer);
                this.writeLog("Log initialized At :" + Utilities.formatDate(new Date(), "MM/dd/yyyy HH:mm:ss"));
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(this, exception.getMessage(), "File operation error", 0);
                this.log_writer = null;
                this.log_output = null;
            }
        }
        this.refreshValidation();
    }

    public void cancelLog() {
        if (this.isLogActive()) {
            try {
                this.log_writer.flush();
                this.log_output.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.log_writer.close();
                this.log_output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.log_writer = null;
            this.log_output = null;
        }
        this.refreshValidation();
    }

    public void executeAll() {
        MainConnection mainConnection = new MainConnection(this.frame.getDatabase().getConnection());
        boolean bl = true;
        try {
            mainConnection.getConnection().setAutoCommit(false);
            SQLTextParser sQLTextParser = new SQLTextParser(this.component.getText());
            String string = sQLTextParser.getFirstCommand();
            while (string.length() > 0 && bl) {
                bl = this.execute(mainConnection, string);
                string = sQLTextParser.getNextCommand();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        try {
            if (bl) {
                mainConnection.getConnection().commit();
            } else {
                mainConnection.getConnection().rollback();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        mainConnection.close();
    }

    public void execute() {
        try {
            JTextPane jTextPane = this.component.getText();
            SQLTextParser sQLTextParser = new SQLTextParser(this.component.getText());
            String string = sQLTextParser.getCommand(jTextPane.getCaretPosition());
            this.execute(this.frame.getDatabase().getConnection(), string);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean execute(MainConnection mainConnection, String string) {
        boolean bl = true;
        if ((string = string.trim()).length() > 0) {
            if (MainConnection.isQuery(string)) {
                dataSourceResultSet dataSourceResultSet2 = new dataSourceResultSet(mainConnection, string);
                try {
                    dataSourceResultSet2.requery();
                    this.component.getTable().getTableModel().setDataSource(dataSourceResultSet2);
                }
                catch (SQLException sQLException) {
                    this.component.getTable().getTableModel().setDataSource(null);
                    JOptionPane.showMessageDialog(this, sQLException.getMessage(), "SQL error", 0);
                    bl = false;
                }
            } else {
                this.component.getTable().getTableModel().setDataSource(null);
                try {
                    int n = mainConnection.executeUpdate(string);
                    JOptionPane.showMessageDialog(this, "Query executed \n rows updated: " + String.valueOf(n), "SQL message", 1);
                }
                catch (SQLException sQLException) {
                    JOptionPane.showMessageDialog(this, sQLException.getMessage(), "SQL error", 0);
                    bl = false;
                }
            }
            this.writeLog(string + ";");
        }
        return bl;
    }

    public void processFocusEvent(FocusEvent focusEvent) {
        this.refreshValidation();
        super.processFocusEvent(focusEvent);
    }

    public SQLExecutionListener getListener() {
        return this.listener;
    }

    public PrincipalFrame getPrincipalFrame() {
        return this.frame;
    }

    public void undo() {
        this.component.undo();
    }

    public void redo() {
        this.component.redo();
    }
}

