/*
 * Decompiled with CFR 0.152.
 */
package pgclibrary.objects;

import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JOptionPane;
import pgclibrary.dataaccess.MainConnection;
import pgclibrary.objects.DBObject;
import pgclibrary.objects.User;

public class Database
extends DBObject {
    protected static MainConnection connection = null;
    private String encoding = new String();
    private String template = new String();
    private String location = new String();
    private boolean isTemplate = false;
    private boolean allowConnections = false;

    public Database(MainConnection mainConnection) {
        super(null);
        Database.setConnection(mainConnection);
        if (this.validate()) {
            this.search(this.getConnection().getDatabaseName());
        }
    }

    public Database(MainConnection mainConnection, String string) {
        super(null);
        Database.setConnection(mainConnection);
        this.search(string);
    }

    public boolean Drop() {
        boolean bl = false;
        if (this.validate()) {
            try {
                bl = this.getConnection().executeUpdate("DROP DATABASE " + this.getName()) > 0;
            }
            catch (SQLException sQLException) {
                JOptionPane.showMessageDialog(null, sQLException.getMessage(), "Can't drop object", 0);
            }
        }
        return bl;
    }

    public String getDeleteSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DROP DATABASE ");
        stringBuffer.append(this.getName());
        stringBuffer.append(";\n ");
        return stringBuffer.toString();
    }

    public String getInsertSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CREATE DATABASE ");
        stringBuffer.append(this.getName()).append(" ");
        if (this.getLocation().length() > 0 || this.getTemplate().length() > 0 || this.getEncoding().length() > 0) {
            stringBuffer.append("WITH ");
            if (this.getLocation().length() > 0) {
                stringBuffer.append("LOCATION='").append(this.getLocation()).append("' ");
            }
            if (this.getTemplate().length() > 0) {
                stringBuffer.append("TEMPLATE=").append(this.getTemplate()).append(" ");
            }
            if (this.getEncoding().length() > 0) {
                stringBuffer.append("ENCODING=").append(this.getEncoding()).append(" ");
            }
        }
        stringBuffer.append(";\n ");
        return stringBuffer.toString();
    }

    public boolean search(String string) {
        boolean bl = false;
        if (this.validate()) {
            try {
                this.initialize();
                ResultSet resultSet = this.getConnection().getQueryGenerator().getDatabases(string);
                if (resultSet != null && resultSet.next()) {
                    this.setName(resultSet.getString("database_name"));
                    this.setDBA(resultSet.getString("database_dba"));
                    this.setTemplate(resultSet.getBoolean("database_template"));
                    this.setAllowConnections(resultSet.getBoolean("database_allowconn"));
                    bl = true;
                }
                resultSet.close();
                resultSet.getStatement().close();
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
            }
        }
        return bl;
    }

    protected void initialize() {
        super.initialize();
        this.isTemplate = false;
        this.allowConnections = false;
    }

    public boolean isTemplate() {
        return this.isTemplate;
    }

    public boolean allowConnections() {
        return this.allowConnections;
    }

    public User getDBA() {
        return this.getCreator();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getTemplate() {
        return this.template;
    }

    public String getLocation() {
        return this.location;
    }

    public MainConnection getConnection() {
        return connection;
    }

    public static MainConnection getMainConnection() {
        return connection;
    }

    public boolean validate() {
        return connection != null;
    }

    public void refresh() {
        this.search(this.getName());
    }

    private static void setConnection(MainConnection mainConnection) {
        connection = mainConnection;
    }

    private void setDBA(String string) {
        this.setCreator(new User((DBObject)this, string));
    }

    private void setTemplate(boolean bl) {
        this.isTemplate = bl;
    }

    private void setAllowConnections(boolean bl) {
        this.allowConnections = bl;
    }

    private void setEncoding(String string) {
        this.encoding = string != null ? string : new String();
    }

    private void setTemplate(String string) {
        this.template = string != null ? string : new String();
    }

    private void setLocation(String string) {
        this.location = string != null ? string : new String();
    }
}

