/*
 * DatabasePanel.java
 *
 * Created on 23 de julio de 2002, 19:02
 */

package components;
import javax.swing.*;
import javax.swing.border.*;
import pgclibrary.objects.*;
import java.awt.*;
import pgclibrary.objects.*;
import pgclibrary.utilities.*;

/**
 *
 * @author  nestor
 */
public class DatabaseRootPanel extends JTabbedPane {
    Database database = null;
    
    JTextField product = new JTextField(20);
    JTextField driver = new JTextField(20);
    JTextField data = new JTextField(20);
    JTextField url = new JTextField(20);
    JTextField user = new JTextField(20);
    
    /** Creates a new instance of DatabasePanel */
    public DatabaseRootPanel() {
        initPanel();
        setPreferredSize(this.getMinimumSize());
    }
    
    private void initPanel(){
        setBorder(new EmptyBorder(10,10,10,10));
        
        product.setEditable(false);
        driver.setEditable(false);
        data.setEditable(false);
        url.setEditable(false);
        user.setEditable(false);
        
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, BoxLayout.Y_AXIS));
        general_panel.add(SUtilities.getHorPanel("Database Name :", product));
        general_panel.add(SUtilities.getHorPanel("Driver Version :", driver));
        general_panel.add(SUtilities.getHorPanel("Current Database :", data));
        general_panel.add(SUtilities.getHorPanel("URL of connection :", url));
        general_panel.add(SUtilities.getHorPanel("User connected :", user));
        
        addTab("General", SUtilities.centerComponent(general_panel));
    }
    
    public void refreshProperties(){
        if ((database != null) && (database.getConnection() != null)){
            product.setText(database.getConnection().getProductName());
            driver.setText(database.getConnection().getDriverVersion());
            data.setText(database.getConnection().getDatabaseName());
            url.setText(database.getConnection().getURL());
            user.setText(database.getConnection().getUserName());
        }
        repaint();
    }
    
    public void setDatabase(Database _database){
        database = _database;
        refreshProperties();
    }
}


