
package components;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import pgclibrary.objects.*;
import components.treeObjects.*;
import java.awt.*;
import pgclibrary.utilities.*;

/**
 *
 * @author  nestor
 */
public class TreeElementsPanel extends JPanel {
    TreeInfo tree_object = null;
    JList elements = new JList();
    JTextField title = new JTextField();
    
    /** Creates a new instance of DatabasePanel */
    public TreeElementsPanel() {
        initPanel();
        setPreferredSize(getMinimumSize());
    }
    
    public void setTreeElement(TreeInfo _tree_object){
        tree_object = _tree_object;
        refreshProperties();
    }
    
    private void initPanel(){
        setBorder(new EmptyBorder(10,10,10,10));

        JPanel panel1 = new JPanel();
        panel1.setLayout(new BoxLayout(panel1, BoxLayout.Y_AXIS));
        title.setBorder(BorderFactory.createEmptyBorder());
        title.setEditable(false);
        
        elements.setModel(new DefaultListModel());
        JScrollPane sp1 = new JScrollPane(elements);
        sp1.setPreferredSize(new Dimension(250, 300));
        
        panel1.add(title);
        panel1.add(sp1);
        add(panel1);
    }
    
    public void refreshProperties(){
        refreshDefaultPanel();
    }
    
    private void refreshDefaultPanel(){
        title.setText(tree_object.toString() + " properties");
        
        DefaultListModel model = (DefaultListModel) elements.getModel();
        model.removeAllElements();
        
        if(tree_object != null){
            for(int i=0; i<tree_object.getProperties().size(); i++){
                TreeInfo temp = (TreeInfo) tree_object.getProperties().get(i);
                model.addElement(temp.toString());
            }
        }
        repaint();
    }
}


