/*
 * IndexPanel.java
 *
 * Created on 1 de agosto de 2002, 16:34
 */

package components.table;
import components.*;
import javax.swing.*;
import java.awt.*;
import pgclibrary.objects.*;
import pgclibrary.dataaccess.*;
import pgclibrary.utilities.*;
import java.util.*;

/**
 *
 * @author  nestor
 */
public class IndexPanel extends JPanel {
    private Table table = null;
    private SQLTable data_table = new SQLTable();
    private IndexPanelListener listener = null;
    
    /** Creates a new instance of IndexPanel */
    public IndexPanel() {
        data_table = new SQLTable();
        listener = new IndexPanelListener(this);
        initPanel();
    }
    
    private void initPanel(){
        setLayout(new BorderLayout());
        setBorder(BorderFactory.createEmptyBorder(10,10,10,10));
        
        
        SQLTableModel sql_tm = new SQLTableModel(data_table);
        data_table.setModel(sql_tm);
        
        //        add(new IndexPanelToolbar(this), BorderLayout.NORTH);
        add(new JScrollPane(data_table), BorderLayout.CENTER);
    }
    public void refresh(){
        ((SQLTableModel) data_table.getModel()).setDataSource(getIndexTable());
        repaint();
    }
    public void refresh(Table table_object){
        table = table_object;
        refresh();
    }
    
    public Table getTable(){
        return table;
    }
    
    public IndexPanelListener getListener(){
        return listener;
    }
    
    public void newIndex(){
    }
    public void editIndex(){
    }
    public void deleteIndex(){
    }
    
    private dataSource getIndexTable(){
        dataSourceVector dsve = new dataSourceVector();
        dsve.addColumnName("Name");
        dsve.addColumnName("Primary");
        dsve.addColumnName("Unique");
        dsve.addColumnName("Cluster");
        dsve.addColumnName("Columns");
        dsve.addColumnSize(20);
        dsve.addColumnSize(6);
        dsve.addColumnSize(6);
        dsve.addColumnSize(6);
        dsve.addColumnSize(30);
        
        if(table != null){
            Vector temp = table.getIndexes();
            for(int i=0; i<temp.size(); i++){
                TableIndex ti = (TableIndex) temp.get(i);
                
                Vector elem = new Vector();
                elem.add(ti.getName());
                elem.add(Utilities.formatBoolean(ti.isPrimary()));
                elem.add(Utilities.formatBoolean(ti.isUnique()));
                elem.add(Utilities.formatBoolean(ti.isClustered()));
                elem.add(ti.getColumnsText());
                dsve.addElement(elem);
            }
        }
        return dsve;
    }
}

