/*
 * DatabaseList.java
 *
 * Created on 31 de julio de 2002, 10:59
 */

package components.treeObjects;
import java.sql.*;
import java.util.*;
import pgclibrary.objects.*;
/**
 *
 * @author  nestor
 */
public class DatabaseList extends TreeInfo {
    /** Creates a new instance of DatabaseList */
    public DatabaseList(RootElement source) {
        super(source);
        setIcon("/images/database.gif");
    }
    
    public void rebuildProperties() {
        removeAllProperties();
        try{
            ResultSet rs = getConnection().getQueryGenerator().getDatabaseNames();
            while((rs != null) && rs.next()){
                addProperty(new Element(this, new Database(getConnection(), rs.getString("database_name"))));
            }
            rs.close();
            rs.getStatement().close();
        } catch (SQLException e){}
    }
    
    public Object getOID() {
        return toString();
    }
    
    public String toString(){
        return "Databases";
    }
}

