/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbsequence.h"
	
	/**
 	 * Constructor
   */		
	DBSequence::DBSequence()
	{
		clear();
	} // end constructor
	
	/**
 	 * Destructor
   */		
	DBSequence::~DBSequence()
	{
	} // end destructor
	
	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void DBSequence::clear()
	{
		m_strSequenceName = "";
		m_strSequenceComment = "";
		m_strSequenceOwner = "";
	} // end clear
	
	/**
 	 * Used to set the sequence name.
   */			    	
	void DBSequence::setSequenceName(const string &rstrSequenceName)
	{
		m_strSequenceName = rstrSequenceName;
	} // end setSequenceName

	/**
 	 * Used to retrieve the sequence name.
   */			    			
	const string & DBSequence::getSequenceName() const
	{
		return m_strSequenceName;
	} // end getSequenceName

	/**
 	 * Used to set the sequence comment.
   */			    						
	void DBSequence::setSequenceComment(const string &rstrSequenceComment)
	{
		m_strSequenceComment = rstrSequenceComment;
	} // end setSequenceComment

	/**
 	 * Used to retrieve the sequence comment.
   */			    			
	const string & DBSequence::getSequenceComment() const
	{
		return m_strSequenceComment;
	} // end getSequenceComment			

	/**
 	 * Used to set the sequence owner.
   */			    						
	void DBSequence::setSequenceOwner(const string &rstrSequenceOwner)
	{
		m_strSequenceOwner = rstrSequenceOwner;
	} // end setSequenceOwner

	/**
 	 * Used to retrieve the Sequence owner.
   */			    			
	const string & DBSequence::getSequenceOwner() const
	{
		return m_strSequenceOwner;
	} // end getSequenceOwner			

