/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbtablecolumn.h"
	
	const string DBTableColumn::NUMERIC_FIELD_NAME = "numeric";
	
	/**
 	 * Constructor
   */		
	DBTableColumn::DBTableColumn()
	{
		clear();
	} // end constructor
	
	/**
 	 * Destructor
   */		
	DBTableColumn::~DBTableColumn()
	{
		// do nothing
	} // end destructor	

	/**
	 * This function will clear out variables in this object, so that it can be used again.
	 */
	void DBTableColumn::clear()
	{
		m_strFieldName = "";
		m_strFieldType = "";
		m_nFieldSize = 0;	
		m_nNumericPrecision = 0;		
		m_nNumericDecimal = 0;
		m_bPrimaryKey = false;				
		m_bFieldNullable = false;
		m_strFieldDefault = "";
		m_strFieldComment = "";		
	} // end clear
	
	/**
 	 * Copy Constructor
 	 * Implemented for the vector class.
   */		
	DBTableColumn::DBTableColumn(const DBTableColumn &roDBTableColumn)
	{
		// use assignment operator
		this->operator=(roDBTableColumn);
	} // end copy constructor

	/**
 	 * Assignment operator
 	 * Implemented for the vector class.
   */		
	DBTableColumn & DBTableColumn::operator=(const DBTableColumn &roDBTableColumn)
	{
		// copy all variables
		m_strFieldName = roDBTableColumn.m_strFieldName;
		m_strFieldType = roDBTableColumn.m_strFieldType;
		m_nFieldSize = roDBTableColumn.m_nFieldSize;	
		m_nNumericPrecision = roDBTableColumn.m_nNumericPrecision;		
		m_nNumericDecimal = roDBTableColumn.m_nNumericDecimal;
		m_bPrimaryKey = roDBTableColumn.m_bPrimaryKey;				
		m_bFieldNullable = roDBTableColumn.m_bFieldNullable;
		m_strFieldDefault = roDBTableColumn.m_strFieldDefault;
		m_strFieldComment = roDBTableColumn.m_strFieldComment;
		return (*this);	
	} // end assignment operator
	
	/**
	 * Equivalence operator
	 * Implemented for the vector class.
	 * If both table columns have the same column name, then they are equivalent.
	 */
	bool DBTableColumn::operator==(DBTableColumn &roDBTableCol)
	{
		return (this->m_strFieldName == roDBTableCol.m_strFieldName);
	} // end operator==

	/**
	 * Less than operator
	 * Implemented for the vector class.
	 * This makes a lexical comparison on the column name. If the left column
	 * has a column name that is lexically less than the right column, it will
	 * return true, otherwise false.
	 */
	bool DBTableColumn::operator<(DBTableColumn &roDBTableCol)
	{
		return (this->m_strFieldName < roDBTableCol.m_strFieldName);	
	} // end operator<
			
	/**
 	 * Used to set field details. For numeric types use the other method.
   */			    						
	void DBTableColumn::setFieldDetails(const string &rstrFieldName, const string &rstrFieldType,
												int nFieldSize, bool bPrimaryKey, bool bFieldNullable, const string &rstrFieldDefault,
												const string &rstrFieldComment)
	{
		m_strFieldName = rstrFieldName;
		m_strFieldType = rstrFieldType;
		m_nFieldSize = nFieldSize;
		m_bPrimaryKey = bPrimaryKey;
		m_bFieldNullable = bFieldNullable;
		m_strFieldDefault = rstrFieldDefault;
		m_strFieldComment = rstrFieldComment;
		// clear numeric details
		m_nNumericPrecision = 0;
		m_nNumericDecimal = 0;
	} // end setFieldDetails

	/**
 	 * Used to set numeric field details. This method should be used when the field being added
 	 * is of the numeric type.
   */			    						
	void DBTableColumn::setNumericFieldDetails(const string &rstrFieldName, int nNumericSize,
												int nDecimalSize,  bool bPrimaryKey, bool bFieldNullable, const string &rstrFieldDefault,
												const string &rstrFieldComment)
	{
		m_strFieldName = rstrFieldName;
		m_strFieldType = DBTableColumn::NUMERIC_FIELD_NAME;
		m_nNumericPrecision = nNumericSize;
		m_nNumericDecimal = nDecimalSize;				
		m_bPrimaryKey = bPrimaryKey;
		m_bFieldNullable = bFieldNullable;		
		m_strFieldDefault = rstrFieldDefault;
		m_strFieldComment = rstrFieldComment;
		// clear unused fields
		m_nFieldSize = 0;		
	} // end setNumericFieldDetails
												
												
	/**
 	 * Used to retrieve the field name.
   */			    			
	const string & DBTableColumn::getFieldName() const
	{
		return m_strFieldName;
	} // end getFieldName			

	/**
 	 * Used to retrieve the field type.
   */			    			
	const string & DBTableColumn::getFieldType() const
	{
		return m_strFieldType;
	} // end getFieldType			

	/**
 	 * Used to retrieve the field size.
   */			    			
	int DBTableColumn::getFieldSize() const
	{
		return m_nFieldSize;
	} // end getFieldSize			

	/**
	 * Used to check if the field type is numeric.
	 */
	bool DBTableColumn::isNumeric() const
	{
		return (m_strFieldType ==	DBTableColumn::NUMERIC_FIELD_NAME);
	} // end isNumeric
	
	/**
 	 * Used to retrieve the precision size of a numeric type.
   */			    			
	int DBTableColumn::getNumericPrecision() const
	{
		return m_nNumericPrecision;
	} // end getNumericPrecision			

	/**
 	 * Used to retrieve the decimal size of a numeric type.
   */			    			
	int DBTableColumn::getNumericDecimal() const
	{
		return m_nNumericDecimal;
	} // end getNumericDecimal			
		
	/**
 	 * Used to identify if a field is a primary key
   */			    			
	bool DBTableColumn::isPrimaryKey() const
	{
		return m_bPrimaryKey;
	} // end isPrimaryKey			
	
	/**
 	 * Used to retrieve if a field is nullable.
   */			    			
	bool DBTableColumn::isFieldNullable() const
	{
		return m_bFieldNullable;
	} // end isFieldNullable			

	/**
 	 * Used to retrieve a field default.
   */			    			
	const string & DBTableColumn::getFieldDefault() const
	{
		return m_strFieldDefault;
	} // end getFieldDefault			

	/**
 	 * Used to retrieve a field comment.
   */			    			
	const string & DBTableColumn::getFieldComment() const
	{
		return m_strFieldComment;
	} // end getFieldComment			


