/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef DBTRIGGERMANAGER_H
#define DBTRIGGERMANAGER_H

#include <string>
#include "../../../exceptions/sqlexception.h"
#include "dbtriggerset.h"
#include "../../dbconnection.h"
#include "../../dbbasemanager.h"
#include "dbtriggerset.h"

/**
 * This class is used to manage operations concerning database indicies. The class
 * provides many generic functions that can be used to retrieve/create/modify
 * database triggers.
 */
class DBTriggerManager : public DBBaseManager
{
protected:
	string m_strClassName;
						
public:

	/**
 	 * Constructor
   */		
  DBTriggerManager();

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBTriggerManager(DBConnection *poDBConn);
	
	/**
 	 * Destructor
   */		
	~DBTriggerManager();

	/**
	 * Used to retrieve the list of triggers for current table.
	 * @return	a DBTriggerSet object that contains the trigger details
	 * @exception SQLException if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void retrieveListOfTriggers(const string & rstrTableName, DBTriggerSet & roDBTriggerSet,
				bool bForeignKeysOnly = false) throw (SQLException, DBConnectionException);

	/**
	 * Used to modify the trigger comment.
	 * @param			rstrTriggerName		the name of the trigger
	 * @param			rstrTableName			the table name for the trigger	
	 * @param			rstrComment				the comment to set for the trigger
	 * @exception SQLException 			if it cannot retrieve results
	 * @exception DBConnectionException if cannot connect
	 */
	void modifyTriggerComment(const string & rstrTriggerName, const string & rstrTableName,
				const string & rstrComment)
				throw (SQLException, DBConnectionException);
						
};

#endif

