/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "sqlexception.h"

	SQLException::SQLException(const string & rstrSQL, const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName)
		: VPSystemException(rstrDescription, rstrClassName, rstrMethodName)
	{
		m_strSQL = rstrSQL;	// sql statement
		m_strName = "SQLException";	// exception name
	} // end constructor
	
	SQLException::SQLException(const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName)
		: VPSystemException(rstrDescription, rstrClassName, rstrMethodName)
	{
		m_strSQL = "";
		m_strName = "SQLException";	// exception name
	} // end constructor

	SQLException::SQLException(const SQLException &roException)
		: VPSystemException(roException)
	{
		m_strSQL = roException.getSQL();
	} // end copy constructor

	SQLException & SQLException::operator=(const SQLException &roException)
	{
		// make copies of the strings
		m_strDescription = roException.getExceptionDescription();
		m_strClassName = roException.getExceptionClassName();
		m_strMethodName = roException.getExceptionMethodName();
		m_strName = roException.getExceptionName();
		m_strSQL = roException.getSQL();		
		return *this;	// return a reference to the calling object

	} // end operator=
	
	const string & SQLException::getSQL() const
	{
		return m_strSQL;
	} // end getSQL