/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef VPSYSTEMEXCEPTION_H
#define VPSYSTEMEXCEPTION_H

#include "vpexception.h"
#include <string>


/**
 * This class is the based class used by all system exceptions in the VisualPsql application.
 * There are two main base classes, this one and VPApplicationException. All exceptions
 * which are related to system problems should inherit this class. e.g. Failure to connect
 * to database, sql query failure. Application exception are more user and internal logic errors.
 * An application exception might be used to capture invalid input.
 */
class VPSystemException: public VPException
{

public:
	
	/**
 	 * Constructor
 	 *
 	 * @param	rstrDescription	used to indicate what the exception was
 	 * @param	rstrClassName		the class that the exception was initially thrown from
 	 * @param	rstrMethodName		the method that the exception was initially thrown from
   */		
	VPSystemException(const string &rstrDescription, const string &rstrClassName, const string &rstrMethodName);
			
};


#endif

