/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "functiongrouplistviewitem.h"
#include "functionlistviewitem.h"
#include "functiongroupitempopup.h"
#include "../common/infodialogs.h"
#include "../../utils/debugger.h"
#include "../../dataaccess/functions/dbfunctionmanager.h"
#include "../../dataaccess/functions/dbfunctionset.h"

#include <iostream.h>

	FunctionGroupListViewItem::FunctionGroupListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBMasterManagerRef()
	{
		setText(0, "Functions");
		m_qstrDescription = "<h1>Functions</h1><hr><p>Lists all the functions and its properties in this database.</p>";
	} // end constructor

	FunctionGroupListViewItem::FunctionGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBMasterManagerRef()
	{
		setText(0, "Functions");
		m_qstrDescription = "<h1>Functions</h1><hr><p>Lists all the functions and its properties in this database.</p>";		
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void FunctionGroupListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "FunctionGroupListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new FunctionGroupItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
					
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void FunctionGroupListViewItem::initChildren()
	{	
		string strMethodName = "FunctionGroupListViewItem::initChildren";
		
		Debugger::entered(strMethodName);

		// temporary function set
		DBFunctionSet oDBFunctionSet;
		
		try
		{		
			getDBMasterManager()->getDBFunctionManager()->retrieveListOfFunctions(oDBFunctionSet);
		} // end try
		catch (SQLException e)
		{
			Debugger::logException(strMethodName, e);
			// report error to user
			InfoDialogs::infoSQLException(listView(), e);			
			return;
		} // end catch
		while (oDBFunctionSet.next())
		{
			FunctionListViewItem *poFunctionItem = new FunctionListViewItem(this);
			// retrieve Function details
			oDBFunctionSet.getDBFunction(*poFunctionItem);
			poFunctionItem->setText(0, poFunctionItem->getFunctionName().c_str());					
			// set database connection
			poFunctionItem->setDBMasterManager(getDBMasterManager());
			// update the description
			poFunctionItem->updateDescription();
		} // end while more
				
		Debugger::exited(strMethodName);		
	} // end initChildren
	