/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "indexgrouplistviewitem.h"
#include "indexgroupitempopup.h"
#include "indexlistviewitem.h"
#include "../../common/infodialogs.h"
#include "../../../utils/debugger.h"
#include <iostream.h>

	IndexGroupListViewItem::IndexGroupListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBMasterManagerRef()
	{
		m_strTableName = "";
		QString qstrIndices("Indices");
		setText(0, qstrIndices);
		m_qstrDescription = "<h1>Indices</h1><hr><p>Lists all the indices for this database table.</p>";		
	} // end constructor

	IndexGroupListViewItem::IndexGroupListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBMasterManagerRef()
	{
		m_strTableName = "";
		QString qstrIndices("Indices");
		setText(0, qstrIndices);
		m_qstrDescription = "<h1>Indices</h1><hr><p>Lists all the indices for this database table.</p>";		
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void IndexGroupListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "IndexGroupListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new IndexGroupItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
	
	/**
 	 * Used to set the table name.
 	 * @param rstrTableName	the table name
   */			    	
	void IndexGroupListViewItem::setTableName(const string & rstrTableName)
	{
		m_strTableName = rstrTableName;
	} // end setTableName
	
	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void IndexGroupListViewItem::initChildren()
	{	
		string strMethodName = "IndexGroupListViewItem::initChildren";	
		
		Debugger::entered(strMethodName);
		
		DBIndexSet oDBIndexSet;
		
		try
		{		
			getDBMasterManager()->getDBIndexManager()->retrieveListOfIndicies(m_strTableName, oDBIndexSet);
		} // end try
		catch (SQLException e)
		{
			Debugger::logException(strMethodName, e);		
			// report error to user
			InfoDialogs::infoSQLException(listView(), e);			
			return;
		} // end catch
		while (oDBIndexSet.next())
		{
			IndexListViewItem *poIndexItem = new IndexListViewItem(this);
			// retrieve index details
			oDBIndexSet.getDBIndex(*poIndexItem);
			poIndexItem->setText(0, QString(poIndexItem->getIndexName().c_str()));					
			// set master manager
			poIndexItem->setDBMasterManager(getDBMasterManager());
			poIndexItem->updateDescription();
		} // end while more

		Debugger::exited(strMethodName);
	} // end initChildren
	