/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "triggerlistviewitem.h"
#include "triggeritempopup.h"
#include "../../../utils/debugger.h"
#include "../../../utils/converter.h"
#include "../../../utils/stringutils.h"
#include "../../common/constants.h"

#include <iostream.h>

	TriggerListViewItem::TriggerListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBTrigger(), DBMasterManagerRef()
	{
	} // end constructor

	TriggerListViewItem::TriggerListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBTrigger(), DBMasterManagerRef()
	{
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void TriggerListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "TriggerListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new TriggerItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
		
	/**
 	 * Used to update the description.
   */			    	
	void TriggerListViewItem::updateDescription()
	{
		string strMethodName = "TriggerListViewItem::updateDescription";
		Debugger::entered(strMethodName);
		// check to see that description has been setup
			
 		// format string to appear on description
 		string strOutputDesc = "<h1>Trigger</h1><hr><p><strong>Name</strong><br>"														
 													 + StringUtils::htmlstr(getTriggerName()) + "</p>"
 													 "<p><strong>Comment</strong><br>";
 		if (getTriggerComment().size() == 0)
 		{
 			strOutputDesc += StringUtils::htmlstr(Constants::NO_COMMENT);				
 		} // end if no comment
 		else
 		{
 			strOutputDesc += StringUtils::htmlstr(getTriggerComment());
 		} // end else comment exists
 		strOutputDesc +=			 "</p><p><strong>Executes</strong><br>"
 													 + StringUtils::htmlstr(getProcedureName()) + "</p>";
 		// lets look for trigger type
 		string strTriggerType;
 		Debugger::logTrace(strMethodName, "Trigger type = " + Converter::intToString(getTriggerType()));
 		if (getTriggerType() == DBTrigger::AFTER_INSERT)
 		{
 			strTriggerType = "After Insert ";
 		} // end if after insert type
 		else if (getTriggerType() == DBTrigger::BEFORE_INSERT)
 		{
 			strTriggerType = "Before Insert ";
 		} // end else if before insert type
 		else if (getTriggerType() == DBTrigger::AFTER_DELETE)
 		{
 			strTriggerType = "After Delete ";
 		} // end else if after delete type
 		else if (getTriggerType() == DBTrigger::BEFORE_DELETE)
 		{
 			strTriggerType = "Before Delete ";
 		} // end else if before delete type			
 		else if (getTriggerType() == DBTrigger::AFTER_UPDATE)
 		{
 			strTriggerType = "After Update ";
 		} // end else if after update type
 		else if (getTriggerType() == DBTrigger::BEFORE_UPDATE)
 		{
 			strTriggerType = "Before Update ";
 		} // end else if before update type			
 		strOutputDesc += "<p><strong>Trigger Type</strong><br>" + strTriggerType + "("
 											+ Converter::intToString(getTriggerType()) + ")</p>";											
			
 		strOutputDesc += "<p><strong>Constraint</strong><br>";
 		if (isConstraint())
 		{
 			strOutputDesc += Constants::YES;
 		} // end if constraint
 		else
 		{
 			strOutputDesc += Constants::NO;			
 		} // end else not constraint
 		strOutputDesc += "</p>";
 		// if constraint is yes then also show trigger arguments
 		if (isConstraint())
 		{
 			string strTriggerArgs;
 			for (int nArgsIdx = 0; nArgsIdx < getNumberOfArguments(); nArgsIdx++)
 			{
 				if (nArgsIdx == 0)
 				{
 					strTriggerArgs = getTriggerArgument(nArgsIdx);
 				} // end if first one
 				else
 				{
 					strTriggerArgs += ", " + getTriggerArgument(nArgsIdx);
 				} // end else not first one
 			} // end for more trigger arguments
 			strOutputDesc += "<p><strong>Trigger Arguments</strong><br>" + StringUtils::htmlstr(strTriggerArgs) + "</p>";
 		} // end if is constraint
			
 		m_qstrDescription = strOutputDesc.c_str();
		
		Debugger::exited(strMethodName);

	} // end getDescription
			
	