/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "viewlistviewitem.h"
#include "../../utils/stringutils.h"
#include "../../utils/debugger.h"
#include "../common/constants.h"
#include "viewitempopup.h"
#include <iostream.h>

	ViewListViewItem::ViewListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBView(), DBMasterManagerRef()
	{
	} // end constructor

	ViewListViewItem::ViewListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBView(), DBMasterManagerRef()
	{
	} // end constructor

	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void ViewListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		string strMethodName = "ViewListViewItem::showRightPressedMenu";
		Debugger::entered(strMethodName);
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new ViewItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
		Debugger::exited(strMethodName);
	} // end showRightPressedMenu		
	
	/**
 	 * Used to update the description.
   */			    	
	void ViewListViewItem::updateDescription()
	{
 		// format string to appear on description
 		string strOutputDesc = "<h1>View</h1><hr><p><strong>Name</strong><br>"
 														+ StringUtils::htmlstr(getViewName()) +
 														"</p><p><strong>Comment</strong><br>";
 		if (getViewComment().size() == 0)
 		{
 			strOutputDesc += StringUtils::htmlstr(Constants::NO_COMMENT);
 		} // end if no comment															
 		else
 		{
 			strOutputDesc	+= StringUtils::htmlstr(getViewComment());
 		} // end else comment exists
			
 		strOutputDesc +=				"</p><p><strong>Owner</strong><br>"
 														+ getViewOwner() + "</p>";
 		m_qstrDescription = strOutputDesc.c_str();
	} // end getDescription
			
