/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "dbmastermanager.h"

	/**
 	 * Constructor
 	 * It is assumed that the database connection object will remain alive during
 	 * the life of this object. Be very careful to ensure that no methods are called
 	 * on this object if the connection object no longer exists. If the connection
 	 * object has already been destroyed then unpredictable results will be returned. 	
   */		
  DBMasterManager::DBMasterManager()
  	: DBBaseManager()
  {
		// nothing to do
  } // end constructor
	
	/**
 	 * Destructor
   */		
	DBMasterManager::~DBMasterManager()
	{
		// nothing to do
	} // end destructor

	/**
	 * Used to set the database connection object of itself and its managers.
	 * This method overrides its parent.
	 * @param poDBConn
	 */
	void DBMasterManager::setDBConnection(DBConnection * poDBConn)
	{
		// call parent version
		DBBaseManager::setDBConnection(poDBConn);
  	m_oDBTableMgr.setDBConnection(m_poDBConn);
  	m_oDBIndexMgr.setDBConnection(m_poDBConn);
  	m_oDBTriggerMgr.setDBConnection(m_poDBConn);	
  	m_oDBForeignKeyMgr.setDBConnection(m_poDBConn);	
  	m_oDBViewMgr.setDBConnection(m_poDBConn);
  	m_oDBFunctionMgr.setDBConnection(m_poDBConn);
  	m_oDBSequenceMgr.setDBConnection(m_poDBConn);  	  	
	} // end setDBConnection
			
	/**
	 * Used to get a pointer reference to a table manager
	 * @return a pointer to a table manager
	 */
	DBTableManager * DBMasterManager::getDBTableManager()
	{
		return &m_oDBTableMgr;
	} // end getDBTableManager

	/**
	 * Used to get a pointer reference to a index manager
	 * @return a pointer to a index manager
	 */
	DBIndexManager * DBMasterManager::getDBIndexManager()
	{
		return &m_oDBIndexMgr;
	} // end getDBIndexManager

	/**
	 * Used to get a pointer reference to a trigger manager
	 * @return a pointer to a trigger manager
	 */
	DBTriggerManager * DBMasterManager::getDBTriggerManager()
	{
		return &m_oDBTriggerMgr;
	} // end getDBTriggerManager
	
	/**
	 * Used to get a pointer reference to a foreign key manager
	 * @return a pointer to a foreign key manager
	 */
	DBForeignKeyManager * DBMasterManager::getDBForeignKeyManager()
	{
		return &m_oDBForeignKeyMgr;
	} // end getDBForeignKeyManager

	/**
	 * Used to get a pointer reference to a view manager
	 * @return a pointer to a view manager
	 */
	DBViewManager * DBMasterManager::getDBViewManager()
	{
		return &m_oDBViewMgr;
	} // end getDBViewManager
	
	/**
	 * Used to get a pointer reference to a function manager
	 * @return a pointer to a function manager
	 */
	DBFunctionManager * DBMasterManager::getDBFunctionManager()
	{
		return &m_oDBFunctionMgr;
	} // end getDBFunctionManager

	/**
	 * Used to get a pointer reference to a sequence manager
	 * @return a pointer to a sequence manager
	 */
	DBSequenceManager * DBMasterManager::getDBSequenceManager()
	{
		return &m_oDBSequenceMgr;
	} // end getDBSequenceManager
	