/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef INDEXITEMPOPUP_H
#define INDEXITEMPOPUP_H

#include <qpopupmenu.h>
#include <qstring.h>
#include "indexlistviewitem.h"

/**
 * This popup menu is fired when a user right clicks on a index item in the list viewer.
 */
class IndexItemPopup: public QPopupMenu
{
	Q_OBJECT
	
protected:
	IndexListViewItem * m_poIndexListViewItem;	
	
public:
	/**
	 * Constructor
	 */
	IndexItemPopup(QWidget *pqoParent, IndexListViewItem *poIndexListViewItem);

	/**
	 * Used to get a reference to the Index item that this popup was generated from.
	 */
	IndexListViewItem * getIndexListViewItem() const;
		
protected slots:	
	/**
	 * This slot is called by the popup menu itself when edit comment is selected.
	 */
	void editComment();
	
private:

};


#endif

