/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "tablegroupitempopup.h"
#include "tablegrouplistviewitem.h"
#include "tableschemaform.h"

	/**
	 * Constructor
	 */
	TableGroupItemPopup::TableGroupItemPopup(QWidget *pqoParent, TableGroupListViewItem *poTableGroupItem)
		: QPopupMenu(pqoParent)
	{
		m_poTableGroupItem = poTableGroupItem;	// keep a reference to the table group item
		
		// setup all the items and their slots
		insertItem("New Table", this, SLOT(createDBTable()));
		insertSeparator();
		insertItem("Refresh", this, SLOT(refreshListOfTables()));		
	} // end constructor

	/**
	 * Used to access the table group list view item.
	 */
	TableGroupListViewItem * TableGroupItemPopup::getTableGroupListViewItem() const
	{
		return m_poTableGroupItem;
	} // end getTableGroupListViewItem
	
	/**
 	 * This slot is called by the popup menu itself when a new table is to be created.
   */	
	void TableGroupItemPopup::createDBTable()
	{
		// bring up schema viewer
		TableSchemaForm *poTableSchemaForm = new TableSchemaForm(this, *((m_poTableGroupItem->getDBMasterManager())->getDBConnection()), "NewTable");		
		poTableSchemaForm->show();			
	} // end createDBTable
		
	/**
 	 * This slot is called by the popup menu itself when it needs to refresh the table list.
   */	
	void TableGroupItemPopup::refreshListOfTables()
	{
		// lets refresh the list as requested
		m_poTableGroupItem->refreshList();
	} // end refreshListOfTables
