/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#include "tablelistviewitem.h"
#include "indicies/indexgrouplistviewitem.h"
#include "triggers/triggergrouplistviewitem.h"
#include "foreignkeys/foreignkeygrouplistviewitem.h"
#include "tableschemaform.h"
#include "tableitempopup.h"
#include "../../utils/stringutils.h"
#include "../../utils/debugger.h"
#include "../common/constants.h"
#include <iostream.h>

	TableListViewItem::TableListViewItem(QListViewItem *pqoListViewItem)
		: BaseListViewItem(pqoListViewItem), DBTable(), DBMasterManagerRef()
	{
	} // end constructor

	TableListViewItem::TableListViewItem(QListViewItem *pqoListViewItem, QListViewItem *pqoAfterItem)
		: BaseListViewItem(pqoListViewItem, pqoAfterItem), DBTable(), DBMasterManagerRef()
	{
	} // end constructor
	
	/**
 	 * Used to update the description.
   */			    	
	void TableListViewItem::updateDescription()
	{
 		// format string to appear on description
 		string strOutputDesc = "<h1>Table</h1><hr><p><strong>Name</strong><br>"
 														+ StringUtils::htmlstr(getTableName()) +
 														"</p><p><strong>Comment</strong><br>";
 		if (getTableComment().size() == 0)
 		{
 			strOutputDesc += StringUtils::htmlstr(Constants::NO_COMMENT);
 		} // end if no comment															
 		else
 		{
 			strOutputDesc	+= StringUtils::htmlstr(getTableComment());
 		} // end else comment exists
			
 		strOutputDesc +=				"</p><p><strong>Owner</strong><br>"
 														+ getTableOwner() + "</p>";
 		m_qstrDescription = strOutputDesc.c_str();
	
	} // end updateDescription
			
	/**
 	 * Displays the right pressed menu for this item.
   */			    	
	void TableListViewItem::showRightPressedMenu(const QPoint & rqoLocation, int nColumn)
	{
		
		// check to see if menu has been brought up previously
		if (m_pqoPopupMenu == 0)
		{
			m_pqoPopupMenu = new TableItemPopup(listView(), this);
		} // end if popup already created
		m_pqoPopupMenu->popup(rqoLocation);
		
	} // end showRightPressedMenu

	/**
 	 * Used to create all the first level children of the current item.
   */			    						
	void TableListViewItem::initChildren()
	{	
		string strMethodName = "TableListViewItem::initChildren";

		Debugger::entered(strMethodName);
		
		// initialise all children items
		IndexGroupListViewItem * poIndexGroupItem = new IndexGroupListViewItem(this);		
		// set master manager
		poIndexGroupItem->setDBMasterManager(getDBMasterManager());
		poIndexGroupItem->setTableName(m_strTableName);
		
		TriggerGroupListViewItem * poTriggerGroupItem = new TriggerGroupListViewItem(this);		
		// set master manager
		poTriggerGroupItem->setDBMasterManager(getDBMasterManager());
		poTriggerGroupItem->setTableName(m_strTableName);

		ForeignKeyGroupListViewItem * poForeignKeyGroupItem = new ForeignKeyGroupListViewItem(this);		
		// set master manager
		poForeignKeyGroupItem->setDBMasterManager(getDBMasterManager());
		poForeignKeyGroupItem->setTableName(m_strTableName);
		
		Debugger::exited(strMethodName);				
	} // end initChildren
	