/**
 * ==========
 * pgExplorer
 * ==========
 * This source file is subject to the license specified in the
 * LICENSE file that is included in this package.
 *
 * @copyright 2000, 2001 Keith Wong
 * @author Keith Wong
 * @email keith@e-magine.com.au
 */

#ifndef STRINGUTILS_H
#define STRINGUTILS_H

#include <string>
#include <vector>

/**
 * This class contains some string manipulation utilities.
 */
class StringUtils
{
				
public:	
		
	/**
 	 * Used to tokenize a string.
 	 * @param		rstrInput 			the input string that contains the strings to tokenize
 	 * @param		rstrDelimeter	the delimiter string used to tokenize the string
 	 * @param		rvstrTokens		the tokens resulting from the string/delimiter
   */			    	
	static void tokenize(const string & rstrInput, const string & rstrDelimeter, vector<string> & rvstrTokens);

	/**
 	 * Used to replace the occurence of a substring with another substring.
 	 * @param		rstrReplaceBy		the string to be replaced by
 	 * @param		rstrToReplace		the string to get replaced
 	 * @param		rstrInput				the input string that needs to be formatted
 	 * @return	the formatted string
   */			    	
	static string replace(const string & rstrReplaceBy, const string & rstrToReplace, const string & rstrInput);	
	
	/**
 	 * Used to prepare a string for html output. This will convert any html entity characters
 	 * into its html displayable format.
 	 * @param		rstrInput 		the input string to format
 	 * @return	the converted string into html format
   */			    	
	static string htmlstr(const string & rstrInput);

	/**
 	 * Used to prepare a string for database string input. This will convert any characters that need to
 	 * be escaped for a database insert (i.e. quote characters).
 	 * @param		rstrInput 		the input string to format
 	 * @return	the converted string into a database string format
   */			    	
	static string databasestr(const string & rstrInput);

	/**
 	 * Used to remove slashes from the string.
 	 * @param		rstrInput 		the input string to format
 	 * @return	the converted string removed of slashes
   */			    	
	static string stripSlashes(const string & rstrInput);

	/**
 	 * Used to trim all the white space from the beginning and end of the string.
 	 * @param		rstrInput 		the input string to trim
 	 * @return	the trimmed string
   */			    	
	static string trim(const string & rstrInput);
							
};


#endif

