<?
/* users.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

if (!isset($usertype)) { $usertype = "pf"; }

$DOC_TITLE = "Users_Management";
include("header.php");

switch (nvl($mode)) {
	case "details" :
		show_user_details($username);
		break;

	case "add" :
		print_add_user_form($usertype);
		break;

	case "edit" :
		print_edit_user_form($username);
		break;

	case "del" :
		delete_user($username);
		print_user_list();
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_username($HTTP_POST_VARS["username"], &$errors, &$errormsg);
		validate_priv($HTTP_POST_VARS["priv"], &$errors, &$errormsg);
		if ($HTTP_POST_VARS["usertype"] == "pf") {
			validate_firstname($HTTP_POST_VARS["firstname"], &$errors, &$errormsg);
			validate_lastname($HTTP_POST_VARS["lastname"], &$errors, &$errormsg);
			if (!empty($HTTP_POST_VARS["fiscalcode"])) {
				validate_fiscalcode($HTTP_POST_VARS["fiscalcode"], &$errors, &$errormsg);
			}
		} else if ($HTTP_POST_VARS["usertype"] == "az") {
			validate_ragionesociale($HTTP_POST_VARS["firstname"], &$errors, &$errormsg);
			validate_partitaiva($HTTP_POST_VARS["fiscalcode"], &$errors, &$errormsg);
		}
		validate_address($HTTP_POST_VARS["address"], &$errors, &$errormsg);
		validate_number($HTTP_POST_VARS["number"], &$errors, &$errormsg);
		validate_city($HTTP_POST_VARS["city"], &$errors, &$errormsg);
		validate_country($HTTP_POST_VARS["country"], &$errors, &$errormsg);
		validate_zip_code($HTTP_POST_VARS["zip_code"], &$errors, &$errormsg);
		validate_phone($HTTP_POST_VARS["phone"], &$errors, &$errormsg);
		validate_fax($HTTP_POST_VARS["fax"], &$errors, &$errormsg);
		validate_mobilephone($HTTP_POST_VARS["mobilephone"], &$errors, &$errormsg);
		validate_email($HTTP_POST_VARS["email"], &$errors, &$errormsg);
		validate_notes($HTTP_POST_VARS["notes"], &$errors, &$errormsg);
		validate_ournotes($HTTP_POST_VARS["ournotes"], &$errors, &$errormsg);
		if (username_exists($HTTP_POST_VARS["username"])) {
			$errors->username = true;
			$errormsg = "<li>" . $the_username . " <b>" . ov($HTTP_POST_VARS["username"]) ."</b> " . $already_exists . $errormsg;
		}
/*
		if (email_exists($HTTP_POST_VARS["email"])) {
			$errors->email = true;
			$errormsg .= "<li>" . $the_email_address . " <b>" . ov($HTTP_POST_VARS["email"]) ."</b> " . $already_exists;
		}
*/
		if (empty($errormsg)) {
			insert_user($HTTP_POST_VARS);
			print_user_list();
		} else {
			$frm["username"] = $HTTP_POST_VARS["username"];
			$frm["usertype"] = $HTTP_POST_VARS["usertype"];
			$frm["priv"] = $HTTP_POST_VARS["priv"];
			$frm["firstname"] = $HTTP_POST_VARS["firstname"];
			$frm["lastname"] = $HTTP_POST_VARS["lastname"];
			$frm["fiscalcode"] = $HTTP_POST_VARS["fiscalcode"];
			$frm["address"] = $HTTP_POST_VARS["address"];
			$frm["number"] = $HTTP_POST_VARS["number"];
			$frm["city"] = $HTTP_POST_VARS["city"];
			$frm["country"] = $HTTP_POST_VARS["country"];
			$frm["zip_code"] = $HTTP_POST_VARS["zip_code"];
			$frm["phone"] = $HTTP_POST_VARS["phone"];
			$frm["fax"] = $HTTP_POST_VARS["fax"];
			$frm["mobilephone"] = $HTTP_POST_VARS["mobilephone"];
			$frm["email"] = $HTTP_POST_VARS["email"];
			$frm["authdata"] = $HTTP_POST_VARS["authdata"];
			$frm["acceptadvert"] = $HTTP_POST_VARS["acceptadvert"];
			$frm["notes"] = $HTTP_POST_VARS["notes"];
			$frm["ournotes"] = $HTTP_POST_VARS["ournotes"];
			$frm["newmode"] = "insert";
			$frm["submit_caption"] = "Add_User";
			include("$CFG->dirroot"."/form_header.php");
			load_user_form_template($frm, $HTTP_POST_VARS["usertype"], $page_number, $errors);
		}
		break;

	case "update" :
		$errors = new Object;
		$errormsg = "";
		validate_priv($HTTP_POST_VARS["priv"], &$errors, &$errormsg);
		if ($HTTP_POST_VARS["usertype"] == "pf") {
			validate_firstname($HTTP_POST_VARS["firstname"], &$errors, &$errormsg);
			validate_lastname($HTTP_POST_VARS["lastname"], &$errors, &$errormsg);
			if (!empty($HTTP_POST_VARS["fiscalcode"])) {
				validate_fiscalcode($HTTP_POST_VARS["fiscalcode"], &$errors, &$errormsg);
			}
		} else if ($HTTP_POST_VARS["usertype"] == "az") {
			validate_ragionesociale($HTTP_POST_VARS["firstname"], &$errors, &$errormsg);
			validate_partitaiva($HTTP_POST_VARS["fiscalcode"], &$errors, &$errormsg);
		}
		validate_address($HTTP_POST_VARS["address"], &$errors, &$errormsg);
		validate_number($HTTP_POST_VARS["number"], &$errors, &$errormsg);
		validate_city($HTTP_POST_VARS["city"], &$errors, &$errormsg);
		validate_country($HTTP_POST_VARS["country"], &$errors, &$errormsg);
		validate_zip_code($HTTP_POST_VARS["zip_code"], &$errors, &$errormsg);
		validate_phone($HTTP_POST_VARS["phone"], &$errors, &$errormsg);
		validate_fax($HTTP_POST_VARS["fax"], &$errors, &$errormsg);
		validate_mobilephone($HTTP_POST_VARS["mobilephone"], &$errors, &$errormsg);
		validate_email($HTTP_POST_VARS["email"], &$errors, &$errormsg);
		validate_notes($HTTP_POST_VARS["notes"], &$errors, &$errormsg);
		validate_ournotes($HTTP_POST_VARS["ournotes"], &$errors, &$errormsg);
/*
		if ($HTTP_POST_VARS["old_email"] != $HTTP_POST_VARS["email"]
		     && email_exists($HTTP_POST_VARS["email"])) {
			$errors->email = true;
			$errormsg .= "<li>" . $the_email_address . " <b>" . ov($HTTP_POST_VARS["email"]) ."</b> " . $already_exists;
		}
*/
		if (empty($errormsg)) {
			update_user($HTTP_POST_VARS);
			print_user_list();
		} else {
			$frm["username"] = $HTTP_POST_VARS["username"];
			$frm["usertype"] = $HTTP_POST_VARS["usertype"];
			$frm["priv"] = $HTTP_POST_VARS["priv"];
			$frm["firstname"] = $HTTP_POST_VARS["firstname"];
			$frm["lastname"] = $HTTP_POST_VARS["lastname"];
			$frm["fiscalcode"] = $HTTP_POST_VARS["fiscalcode"];
			$frm["address"] = $HTTP_POST_VARS["address"];
			$frm["number"] = $HTTP_POST_VARS["number"];
			$frm["city"] = $HTTP_POST_VARS["city"];
			$frm["country"] = $HTTP_POST_VARS["country"];
			$frm["zip_code"] = $HTTP_POST_VARS["zip_code"];
			$frm["phone"] = $HTTP_POST_VARS["phone"];
			$frm["fax"] = $HTTP_POST_VARS["fax"];
			$frm["mobilephone"] = $HTTP_POST_VARS["mobilephone"];
			$frm["email"] = $HTTP_POST_VARS["email"];
			$frm["old_email"] = $HTTP_POST_VARS["old_email"];
			$frm["authdata"] = $HTTP_POST_VARS["authdata"];
			$frm["acceptadvert"] = $HTTP_POST_VARS["acceptadvert"];
			$frm["notes"] = $HTTP_POST_VARS["notes"];
			$frm["ournotes"] = $HTTP_POST_VARS["ournotes"];
			$frm["newmode"] = "update";
			$frm["submit_caption"] = "Save_Changes";
			include("$CFG->dirroot"."/form_header.php");
			load_user_form_template($frm, $HTTP_POST_VARS["usertype"], $page_number, $errors);
		}
		break;

	case "resetpw" :
		$return = reset_user_password($username);
		if ($return == 0) {
			$t = new Template();
			$t->set_file(array("page" => "templates/".$SESSION["lang"]."/user_password_reset.ihtml"));
			$t->set_var("username", ov($username));
			$t->pparse("out", "page");
//			include("templates/".$SESSION["lang"]."/user_password_reset.ihtml");
		} else {
			include("templates/".$SESSION["lang"]."/password_not_reset.ihtml");
		}
		print_user_list();
		break;

	case "import" :
		print_import_users_form();
		break;

	case "update_imp" :
		if ($userfile == 'none')
			print_import_users_form();
		else
			import_users($userfile);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_user_list();
		break;
}

include("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function load_user_form_template($frm, $usertype, $page_number, $errors) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$t = new Template();
	$t->set_file(array("page" => "templates/user_form-".$usertype.".ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
			"page_number"		=> $page_number,
			"frm_newmode"		=> $frm["newmode"],
			"frm_old_email"		=> $frm["old_email"],
			"frm_username"		=> ov($frm["username"]),
			"errors_username"	=> errmsg($errors->username),
			"frm_priv"		=> ov($frm["priv"]),
			"errors_priv"		=> errmsg($errors->priv),
			"frm_firstname"		=> ov($frm["firstname"]),
			"errors_firstname"	=> errmsg($errors->firstname),
			"frm_lastname"		=> ov($frm["lastname"]),
			"errors_lastname"	=> errmsg($errors->lastname),
			"frm_fiscalcode"	=> ov($frm["fiscalcode"]),
			"errors_fiscalcode"	=> errmsg($errors->fiscalcode),
			"frm_address"		=> ov($frm["address"]),
			"errors_address"	=> errmsg($errors->address),
			"frm_number"		=> ov($frm["number"]),
			"errors_number"		=> errmsg($errors->number),
			"frm_city"		=> ov($frm["city"]),
			"errors_city"		=> errmsg($errors->city),
			"frm_country"		=> ov($frm["country"]),
			"errors_country"	=> errmsg($errors->country),
			"frm_zip_code"		=> ov($frm["zip_code"]),
			"errors_zip_code"	=> errmsg($errors->zip_code),
			"frm_phone"		=> ov($frm["phone"]),
			"errors_phone"		=> errmsg($errors->phone),
			"frm_fax"		=> ov($frm["fax"]),
			"errors_fax"		=> errmsg($errors->fax),
			"frm_mobilephone"	=> ov($frm["mobilephone"]),
			"errors_mobilephone"	=> errmsg($errors->mobilephone),
			"frm_email"		=> ov($frm["email"]),
			"errors_email"		=> errmsg($errors->email),
			"frm_authdata"		=> $frm["authdata"] ? "checked" : "" ,
			"frm_acceptadvert"	=> $frm["acceptadvert"] ? "checked" : "" ,
			"frm_notes"		=> ov($frm["notes"]),
			"errors_notes"		=> errmsg($errors->notes),
			"frm_ournotes"		=> ov($frm["ournotes"]),
			"errors_ournotes"	=> errmsg($errors->ournotes),
			"frm_description"	=> ov($frm["description"]),
			"errors_description"	=> errmsg($errors->brand_description),
			"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->set_block("page", "username_notok", "username_notok_blck");
	$t->set_var("username_notok_blck", "");
	$t->set_block("page", "username_ok", "username_ok_blck");
	$t->set_var("username_ok_blck", "");
	if ($frm["username"] == "" || $errors->username)
		$t->parse("username_notok_blck", "username_notok", true);
	else
		$t->parse("username_ok_blck", "username_ok", true);
	$t->pparse("out", "page");
//	include("templates/user_form-".$HTTP_POST_VARS["usertype"].".ihtml");
}

function show_user_details($username) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$qid = db_query("SELECT * FROM users WHERE username = '$username'");
	$frm = db_fetch_array($qid, 0);

	$t = new Template();
	$t->set_file(array("page" => "templates/user_details-".$frm["usertype"].".ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var(array(
			"frm_username"		=> ov($frm[username]),
			"frm_priv"		=> ov($frm[priv]),
			"frm_firstname"		=> ov($frm[firstname]),
			"frm_lastname"		=> ov($frm[lastname]),
			"frm_fiscalcode"	=> ov($frm[fiscalcode]),
			"frm_address"		=> ovwbr($frm[address]),
			"frm_number"		=> ov($frm[number]),
			"frm_city"		=> ov($frm[city]),
			"frm_country"		=> ov($frm[country]),
			"frm_zip_code"		=> ov($frm[zip_code]),
			"frm_phone"		=> ov($frm[phone]),
			"frm_fax"		=> ov($frm[fax]),
			"frm_mobilephone"	=> ov($frm[mobilephone]),
			"frm_email"		=> ov($frm[email]),
			"frm_authdata"		=> $frm["authdata"] ? strtoupper($yes) : "" ,
			"frm_acceptadvert"	=> $frm["acceptadvert"] ? strtoupper($yes) : "" ,
			"frm_notes"		=> ovwbr($frm[notes]),
			"frm_ournotes"		=> ovwbr($frm[ournotes]),
			"frm_date"		=> ov($frm[date]),
	));
	$t->pparse("out", "page");
//	include("templates/user_details-".$frm["usertype"].".ihtml");
}

function print_add_user_form($usertype) {
/* print a blank user form so we can add a new user */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
//	include ($CFG->globalerror);

	/* set default values for the reset of the fields */
	$frm["username"] = "";
	$frm["firstname"] = "";
	$frm["lastname"] = "";
	$frm["address"] = "";
	$frm["number"] = "";
	$frm["city"] = "";
	$frm["country"] = "";
	$frm["zip_code"] = "";
	$frm["phone"] = "";
	$frm["fax"] = "";
	$frm["mobilephone"] = "";
	$frm["email"] = "";
	$frm["authdata"] = 0;
	$frm["acceptadvert"] = 1;
	$frm["notes"] = "";

	$frm["newmode"] = "insert";
	$frm["submit_caption"] = "Add_User";

	load_user_form_template($frm, $usertype, $page_number, $errors);
}

function print_edit_user_form($username) {
/* print a user form so we can edit the selected user */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
//	include ($CFG->globalerror);

	/* load up the information for the user */
	$qid = db_query("
	SELECT * FROM users WHERE username = '$username'
	");
	$frm = db_fetch_array($qid, 0);
	$frm["old_email"] = $frm["email"];

	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	load_user_form_template($frm, $frm["usertype"], $page_number, $errors);
}

function delete_user($username) {
/* delete the user who's login is $username */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$qid = db_query("SELECT priv FROM users WHERE username = '$username'");
	$user = db_fetch_object($qid, 0);
	if ($user->priv != "admin") {
		$qid = db_query("DELETE FROM users WHERE username = '$username'");

		$t = new Template();
		$t->set_file(array("page" => "templates/user_deleted.ihtml"));
		require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
		require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
		$t->set_var(array(
				"username"	=> ov($username),
		));
		$t->pparse("out", "page");
//		include("templates/user_deleted.ihtml");
	} else {
		include("templates/".$SESSION["lang"]."/admin_not_deleted.ihtml");
	}
}

function insert_user($frm) {
/* add a user into the database, we should really have some good validation
 * routines to check for things like bad passwords, etc., but for the purpose
 * of this tutorial it's left to the reader (you) to add them in :) */

	global $CFG, $SESSION;
	global $myday, $mymonth;
//	include ($CFG->globalerror);

	$date = $myday[date("w")] . date(" j") . "-" . date("n") . "-" . date("Y H:i:s");
	$fromip = getenv("REMOTE_ADDR");

	$password = generate_password();

	$qid = db_query("
	INSERT INTO users (
		username
		,password
		,usertype
		,priv
		,firstname
		,lastname
		,fiscalcode
		,address
		,number
		,city
		,country
		,zip_code
		,phone
		,fax
		,mobilephone
		,email
		,authdata
		,acceptadvert
		,notes
		,ournotes
		,date
		,fromip
		)
	VALUES (
		 '$frm[username]'
		,'" . md5($password) ."'
		,'$frm[usertype]'
		,'$frm[priv]'
		,'$frm[firstname]'
		,'$frm[lastname]'
		,'$frm[fiscalcode]'
		,'$frm[address]'
		,'$frm[number]'
		,'$frm[city]'
		,'$frm[country]'
		,'$frm[zip_code]'
		,'$frm[phone]'
		,'$frm[fax]'
		,'$frm[mobilephone]'
		,'$frm[email]'
		,'$frm[authdata]'
		,'$frm[acceptadvert]'
		,'$frm[notes]'
		,'$frm[ournotes]'
		,'$date'
		,'$fromip'
	)");

	$t = new Template();
	$t->set_file(array("page" => "templates/user_added.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var(array(
			"frm_username"	=> ov($frm[username]),
	));
	$t->pparse("out", "page");
//	include("templates/user_added.ihtml");
}

function update_user($frm) {
/* update the user record in the database */

	global $CFG, $SESSION;
	global $username;
//	include ($CFG->globalerror);

	$qid = db_query("
	UPDATE users SET
		 priv = '$frm[priv]'
		,firstname = '$frm[firstname]'
		,lastname = '$frm[lastname]'
		,fiscalcode = '$frm[fiscalcode]'
		,address = '$frm[address]'
		,number = '$frm[number]'
		,city = '$frm[city]'
		,country = '$frm[country]'
		,zip_code = '$frm[zip_code]'
		,phone = '$frm[phone]'
		,fax = '$frm[fax]'
		,mobilephone = '$frm[mobilephone]'
		,email = '$frm[email]'
		,authdata = '$frm[authdata]'
		,acceptadvert = '$frm[acceptadvert]'
		,notes = '$frm[notes]'
		,ournotes = '$frm[ournotes]'
	WHERE username = '$frm[username]'
	");

	$t = new Template();
	$t->set_file(array("page" => "templates/user_updated.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var(array(
			"username"	=> ov($username),
	));
	$t->pparse("out", "page");
//	include("templates/user_updated.ihtml");
}

function print_user_list() {
/* read all the categories from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $yes;
	global $page_number, $dbchanged;
//	include ($CFG->globalerror);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT username, firstname, lastname, phone, email, authdata, acceptadvert
		FROM users
		WHERE username <> 'root'
		ORDER BY username ASC
		");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["users"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["users_per_page"]) {
		$first = ($page_number-1)*$SESSION["users_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["users_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["users_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["users_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/user_list.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		require("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "user_row", "user_rows");
	$t->set_var("user_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
				"page_number"		=> $page_number,
				"session_username"	=> ov($SESSION["users"][$i]["username"]),
				"session_firstname"	=> ov($SESSION["users"][$i]["firstname"]),
				"session_lastname"	=> $SESSION["users"][$i]["lastname"] == "" ? "&nbsp;" : ov($SESSION["users"][$i]["lastname"]),
				"session_phone"		=> ov($SESSION["users"][$i]["phone"]),
				"session_email"		=> ov($SESSION["users"][$i]["email"]),
				"session_authdata"	=> $SESSION["users"][$i]["authdata"] ? strtoupper($yes) : "&nbsp;",
				"session_acceptadvert"	=> $SESSION["users"][$i]["acceptadvert"] ? strtoupper($yes) : "&nbsp;"
		));
		$t->parse("user_rows", "user_row", true);
	}
	$t->pparse("out", "page");
//	include("templates/user_list.ihtml");
}

function print_import_users_form() {
/* print the import users form so we can add/update users from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Button_Label";
	$frm["newmode"] = "update_imp";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
			"frm_newmode"			=> $frm["newmode"],
			"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
			"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
//	include("templates/data_import_form.ihtml");
}

function import_users($userfile) {
/* Import users from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* Let's open a transaction */
	$qid = db_begin();

	$fcontents = file ($userfile);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
//echo "<b>" . $line_num . "</b>:" . $line . "<br>";
		/* dangerous characters quoting */
		for ($i=0; $i<22; $i++)
			$fldarr[$i] = addslashes($fldarr[$i]);

		/* Let's see if the user already exists ... */
		$qid = db_query("
		SELECT username FROM users WHERE username = '$fldarr[0]'
		");
		if (db_num_rows($qid) == 0) {
			/* ... if it doesn't exist let's create it in the users table ... */
			$qid = db_query("
			INSERT INTO users (
				username
				,password
				,usertype
				,priv
				,firstname
				,lastname
				,fiscalcode
				,address
				,number
				,city
				,country
				,zip_code
				,phone
				,fax
				,mobilephone
				,email
				,authdata
				,acceptadvert
				,notes
				,ournotes
				,date
				,fromip
				)
			VALUES (
		 		'$fldarr[0]'
				,'" . md5($fldarr[1]) ."'
				,'$fldarr[2]'
				,'$fldarr[3]'
				,'$fldarr[4]'
				,'$fldarr[5]'
				,'$fldarr[6]'
				,'$fldarr[7]'
				,'$fldarr[8]'
				,'$fldarr[9]'
				,'$fldarr[10]'
				,'$fldarr[11]'
				,'$fldarr[12]'
				,'$fldarr[13]'
				,'$fldarr[14]'
				,'$fldarr[15]'
				,'$fldarr[16]'
				,'$fldarr[17]'
				,'$fldarr[18]'
				,'$fldarr[19]'
				,'$fldarr[20]'
				,'$fldarr[21]'
			)");
		}
		else {
			/* ... otherwise let's update it in the products table ... */
			$qid = db_query("
			UPDATE users SET
				usertype = '$fldarr[2]'
				,priv = '$fldarr[3]'
				,firstname = '$fldarr[4]'
				,lastname = '$fldarr[5]'
				,fiscalcode = '$fldarr[6]'
				,address = '$fldarr[7]'
				,number = '$fldarr[8]'
				,city = '$fldarr[9]'
				,country = '$fldarr[10]'
				,zip_code = '$fldarr[11]'
				,phone = '$fldarr[12]'
				,fax = '$fldarr[13]'
				,mobilephone = '$fldarr[14]'
				,email = '$fldarr[15]'
				,authdata = '$fldarr[16]'
				,acceptadvert = '$fldarr[17]'
				,notes = '$fldarr[18]'
				,ournotes = '$fldarr[19]'
				,date = '$fldarr[20]'
				,fromip = '$fldarr[21]'
			WHERE username = '$fldarr[0]'
			");
		}
	}

	/* Let's close the transaction */
	$qid = db_commit();
	
	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
//	include("templates/data_import_end.ihtml");

}

?>
