<?
/* change_settings.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();

/* form has been submitted, check if it the user login information is correct */
if (match_referer() && isset($HTTP_POST_VARS) && !isset($from_menu)) {
	$frm = $HTTP_POST_VARS;
	$errormsg = validate_form($frm, $errors);

	if (empty($errormsg)) {
		update_settings($frm);
		$noticemsg = "Settings_Change_Successful";
	}
} else {
	$frm = load_user_profile();
}

$DOC_TITLE = "Change_Settings";

include("$CFG->dirroot"."/header.php");

include("$CFG->dirroot"."/form_header.php");

$t = new Template();
$t->set_file(array("page" => "templates/change_settings_form-".$SESSION["user"]["usertype"].".ihtml"));
require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
$t->set_var("ME", $ME);
$t->set_var(array(
		"session_user_username"		=> ov($SESSION["user"]["username"]),
		"session_user_firstname"	=> ov($SESSION["user"]["firstname"]),
		"frm_fiscalcode"		=> ov($frm["fiscalcode"]),
		"errors_fiscalcode"		=> errmsg($errors->fiscalcode),
		"frm_address"			=> ov($frm["address"]),
		"errors_address"		=> errmsg($errors->address),
		"frm_number"			=> ov($frm["number"]),
		"errors_number"			=> errmsg($errors->number),
		"frm_city"			=> ov($frm["city"]),
		"errors_city"			=> errmsg($errors->city),
		"frm_country"			=> ov($frm["country"]),
		"errors_country"		=> errmsg($errors->country),
		"frm_zip_code"			=> ov($frm["zip_code"]),
		"errors_zip_code"		=> errmsg($errors->zip_code),
		"frm_phone"			=> ov($frm["phone"]),
		"errors_phone"			=> errmsg($errors->phone),
		"frm_fax"			=> ov($frm["fax"]),
		"errors_fax"			=> errmsg($errors->fax),
		"frm_mobilephone"		=> ov($frm["mobilephone"]),
		"errors_mobilephone"		=> errmsg($errors->mobilephone),
		"frm_email"			=> ov($frm["email"]),
		"errors_email"			=> errmsg($errors->email),
		"frm_authdata"			=> $frm["authdata"] ? "checked" : "",
		"frm_acceptadvert"		=> $frm["acceptadvert"] ? "checked" : "",
		"frm_notes"			=> ov($frm["notes"]),
));
if ($SESSION["user"]["usertype"] == "pf") {
	$t->set_var("session_user_lastname", ov($SESSION["user"]["lastname"]));
	if ($SESSION["country"] == "it") {
		$t->set_block("page", "italy", "italy_blck");
		$t->set_var("italy_blck", "");
		$t->parse("italy_blck", "italy", true);
	}
}
$t->pparse("out", "page");
//include("templates/change_settings_form-".$SESSION["user"]["usertype"].".ihtml");

include("$CFG->dirroot"."/footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_form(&$frm, &$errors) {

	global $CFG, $SESSION;
	include ($CFG->globalerror);

	$errors = new Object;
	$msg = "";

	if ($SESSION["user"]["usertype"] == "pf" && $SESSION["country"] == "it") {
		validate_fiscalcode($frm["fiscalcode"], &$errors, &$msg);
	} else if ($SESSION["user"]["usertype"] == "az") {
		validate_partitaiva($frm["fiscalcode"], &$errors, &$msg);
	}
	validate_address($frm["address"], &$errors, &$msg);
	validate_number($frm["number"], &$errors, &$msg);
	validate_city($frm["city"], &$errors, &$msg);
	validate_country($frm["country"], &$errors, &$msg);
	validate_zip_code($frm["zip_code"], &$errors, &$msg);
	validate_phone($frm["phone"], &$errors, &$msg);
	validate_fax($frm["fax"], &$errors, &$msg);
	validate_mobilephone($frm["mobilephone"], &$errors, &$msg);
	validate_email($frm["email"], &$errors, &$msg);
	validate_notes($frm["notes"], &$errors, &$msg);

/*
	if (email_exists($frm["email"]) && $frm["email"] != $SESSION["user"]["email"]) {
		$errors->email = true;
		$msg .= "<li>" . $the_email_address . " <b>" . ov($frm["email"]) . "</b> " . $already_exists;
	}
*/
	
	return $msg;
}

function update_settings(&$frm) {

	global $SESSION;
	
	$username = $SESSION["user"]["username"];

	$qid = db_query("
	UPDATE users SET
		 fiscalcode = '$frm[fiscalcode]'
		,address = '$frm[address]'
		,number = '$frm[number]'
		,city = '$frm[city]'
		,country = '$frm[country]'
		,zip_code = '$frm[zip_code]'
		,phone = '$frm[phone]'
		,fax = '$frm[fax]'
		,mobilephone = '$frm[mobilephone]'
		,email = '$frm[email]'
		,authdata = '$frm[authdata]'
		,acceptadvert = '$frm[acceptadvert]'
		,notes = '$frm[notes]'
	WHERE username = '$username'
	");
}

?>
