<?
/* (c) 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */
/* with contribution for the script structure 
   from categories.php (c) 2000 Ying Zhang (ying@zippydesign.com) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

$DOC_TITLE = "Brands_Management";
include("header.php");

switch (nvl($mode)) {
	case "add" :
		print_add_brand_form();
		break;

	case "edit" :
		if (!($id == 0))
			print_edit_brand_form($id);
		break;

	case "del" :
		if (!($id == 0))
			delete_brand($id);
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_brand_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_brand_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_brand($HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["newmode"] = "insert";
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["submit_caption"] = "Add_Brand";
			include("$CFG->dirroot"."/form_header.php");
			load_brand_form_template($frm, $id, $errors);
		}
		break;

	case "update" :
		if ($id == 0)
			break;
		$errors = new Object;
		$errormsg = "";
		validate_brand_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_brand_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_brand($id, $HTTP_POST_VARS);
		} else {
			/* set default values for the reset of the fields */
			$frm["newmode"] = "update";
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["submit_caption"] = "Save_Changes";
			include("$CFG->dirroot"."/form_header.php");
			load_brand_form_template($frm, $id, $errors);
		}
		break;

	case "import" :
		print_import_brands_form();
		break;

	case "update_imp" :
		if ($userfile == 'none')
			print_import_brand_form();
		else
			import_brands($userfile);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_brands_list();
		break;
}

include("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function load_brand_form_template($frm, $id, $errors) {

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$t = new Template();
	$t->set_file(array("page" => "templates/brand_form.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
			"frm_newmode"		=> $frm["newmode"],
			"brand_id"		=> $id,
			"frm_name"		=> ov($frm["name"]),
			"errors_name"		=> errmsg($errors->brand_name),
			"frm_description"	=> ov($frm["description"]),
			"errors_description"	=> errmsg($errors->brand_description),
			"frm_submit_caption"	=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
//	include("templates/brand_form.ihtml");
}

function print_add_brand_form() {
/* print a blank brand form so we can add a new brand */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	/* set default values for the reset of the fields */
	$frm["newmode"] = "insert";
	$frm["name"] = "";
	$frm["description"] = "";
	$frm["submit_caption"] = "Add_Brand";
	load_brand_form_template($frm, $id, $errors);
}

function print_edit_brand_form($id) {
/* print a brand form so we can edit the selected brand */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	/* load up the information for the brand */
	$qid = new DB_Sql;
//	$qid = db_query("
	$qid->Query("SELECT name, description FROM brands WHERE id = '$id'");
//	$frm = db_fetch_array($qid, 0);
	$qid->next_record();
	$frm["name"] = $qid->f("name");
	$frm["description"] = $qid->f("description");

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";
	load_brand_form_template($frm, $id, $errors);
}

function delete_brand($id) {
// delete the brand specified by $id, and reset to 0
// the brand_id for all products of this brand

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	$qid = new DB_Sql;
//	$qid = db_begin();
	$qid->begin();

	/* find out the brand name */
//	$qid = db_query("
	$qid->Query("SELECT name from brands WHERE id = '$id'");
//	$frm = db_fetch_array($qid, 0);
	$qid->next_record();
	$frm["name"] = $qid->f("name");

	/* delete this brand */
//	$qid = db_query("
	$qid->Query("DELETE FROM brands WHERE id = '$id'");

	// reset to 0 the brand_id for all products of this brand
//	$qid = db_query("
	$qid->Query("UPDATE products SET brand_id = 0 WHERE brand_id = '$id'");

//	$qid = db_commit();
	$qid->commit();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/brand_deleted.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var(array(
			"frm_name"	=> ov($frm[name]),
			"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
//	include("templates/brand_deleted.ihtml");
}

function insert_brand($frm) {
/* add a new brand.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = new DB_Sql;
//	$qid = db_query("
	$qid->Query("
		INSERT INTO brands (name, description)
		VALUES ('$frm[name]', '$frm[description]')
	");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/brand_added.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	$t->set_var(array(
			"frm_name"	=> ov($frm[name]),
			"backurl"	=> $backurl
	));
	$t->pparse("out", "page");
//	include("templates/brand_added.ihtml");
}

function update_brand($id, $frm) {
/* update the brand $id with new values.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = new DB_Sql;
//	$qid = db_query("
	$qid->Query("
		UPDATE brands SET
			name = '$frm[name]'
			,description = '$frm[description]'
		WHERE id = '$id'
	");

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/brand_updated.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var(array(
			"http_post_vars_name"	=> ov($frm[name]),
			"backurl"		=> $backurl
	));
	$t->pparse("out", "page");
//	include("templates/brand_updated.ihtml");
}

function print_brands_list() {
/* read all the brands from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
//	include ($CFG->globalerror);

	if (!isset($page_number) || $dbchanged) {
		$qid = new DB_Sql;
//		$qid = db_query("
		$qid->Query("
			SELECT id, name, description
			FROM brands
			WHERE id > 0
			ORDER BY name
		");

//		$SESSION["numr"] = db_num_rows($qid);
		$SESSION["numr"] = $qid->num_rows();
		for ($i=0; $i<$SESSION["numr"]; $i++) {
//			$SESSION["brands"][$i] = db_fetch_array($qid, $i);
			$qid->seek($i);
			$qid->next_record();
			$SESSION["brands"][$i]["id"] = $qid->f("id");
			$SESSION["brands"][$i]["name"] = $qid->f("name");
			$SESSION["brands"][$i]["description"] = $qid->f("description");
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["brands_per_page"]) {
		$first = ($page_number-1)*$SESSION["brands_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["brands_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["brands_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["brands_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/brand_list.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		require("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "brand_row", "brand_rows");
	$t->set_var("brand_rows", "");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var(array(
				"session_brands_name"		=> ov($SESSION["brands"][$i]["name"]),
				"session_brands_id"		=> $SESSION["brands"][$i]["id"],
				"session_brands_description"	=> ovwbr($SESSION["brands"][$i]["description"])
		));
		$t->parse("brand_rows", "brand_row", true);
	}
	$t->pparse("out", "page");
//	include("templates/brand_list.ihtml");
}

function print_import_brands_form() {
/* print the import brand form so we can add/update brands from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Button_Label";
	$frm["newmode"] = "update_imp";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
			"frm_newmode"			=> $frm["newmode"],
			"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
			"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
//	include("templates/data_import_form.ihtml");
}

function import_brands($userfile) {
/* Import brands from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);
	$errors = new Object;

	$qid = new DB_Sql;
//	$qid = db_begin();
	$qid->begin();

	$fcontents = file ($userfile);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
		/* dangerous characters quoting */
		for ($i=0; $i<2; $i++)
			$fldarr[$i] = addslashes($fldarr[$i]);

		/* ... and let's see if the brand already exists ... */
//		$qid = db_query("
		$qid->Query("SELECT id FROM brands WHERE name = '$fldarr[0]'");
//		if (db_num_rows($qid) == 0) {
		if ($qid->num_rows() == 0) {
			/* ... if it doesn't exist let's create it ... */
//			$qid = db_query("
			$qid->Query("
				INSERT INTO brands (name, description)
				VALUES ('$fldarr[0]', '$fldarr[1]')
			");
		} else {
			/* ... otherwise let's save its ID ... */
//			$arr = db_fetch_array($qid,0);
//			$sid = $arr[0];
			$qid->next_record();
			$qid = $qid->f("id");
			/* ... and update ... */
//			$qid = db_query("
			$qid->Query("
				UPDATE brands SET description = '$fldarr[1]'
				WHERE id = '$sid'
			");
		}
	}

	/* Let's close the transaction */
//	$qid = db_commit();
	$qid->commit();
	
	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
	require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
//	include("templates/data_import_end.ihtml");

}

?>
