<?
/* index.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the 
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");

$DOC_TITLE = "Shopping_Catalog";
$SESSION["goback"]["request_uri"] = $REQUEST_URI;
$SESSION["goback"]["query_string"] = $QUERY_STRING;
include("$CFG->dirroot"."/header.php");

setdefault($id, 1);
$qid_bcp = new DB_Sql;
build_category_path(&$qid_bcp, $id, $category_path);
$qid_bcp->close();

/* get the name and description of all the sub-categories under this one */
$qid_c = new DB_Sql;
$qid_c->Query("
	SELECT id, name, special_level, description
	FROM categories
	WHERE parent_id = '$id' AND id > 1
	ORDER BY special_level, name
");
/* get all the products under this category */
$qid_p = new DB_Sql;
$qid_p->Query("
	SELECT
		 p.id
		,p.name AS name
		,p.price
		,p.discount
		,p.discqty
		,p.weight
		,p.special_flag
		,p.special_level
		,p.description
		,p.thumbwidth
		,p.thumbheight
		,pc.category_id
		,b.name AS bname
		,i.iva
	FROM products p, products_categories pc, brands b, iva i
	WHERE p.id = pc.product_id AND p.brand_id = b.id AND p.iva_id = i.id AND pc.category_id = '$id'
	ORDER BY p.special_level ASC
	");

$t = new Template();
$t->set_file(array("page" => "templates/index.ihtml"));
require($CFG->localedir . $SESSION["lang"] . "/global-common.inc.php");
require($CFG->localedir . $SESSION["lang"] . "/global-shopping.inc.php");
require($CFG->localedir . $SESSION["lang"] . "/global-admin.inc.php");
$t->set_var("wwwroot", $CFG->wwwroot);
$t->set_var("productswww", $CFG->productswww);
$t->set_var("ME", $ME);
$t->set_var("id", $id);

$t->set_var("category_path", $category_path);

$t->set_block("page", "noframes", "noframes_blck");
$t->set_var("noframes_blck", "");
$t->set_block("page", "noframes2", "noframes2_blck");
$t->set_var("noframes2_blck", "");
if (!$SESSION["frames_used"] || has_priv("admin")){
	$t->parse("noframes_blck", "noframes", true);
	$t->set_block("noframes2", "no_sub_categories", "no_sub_categories_blck");
	$t->set_block("noframes2", "category_row", "category_rows");
	$t->set_block("noframes2", "adminnoframes2", "adminnoframes2_blck");
	$t->set_var("no_sub_categories_blck", "");
	$t->set_var("category_rows", "");
//	if (($numr = db_num_rows($qid_c)) == 0)
	if ($qid_c->num_rows() == 0)
		$t->parse("no_sub_categories_blck", "no_sub_categories", true);
	else {
//		for ($i=0; $i<$numr; $i++) {
		while ($qid_c->next_record()) {
//			$cat = db_fetch_object($qid_c, $i);
			if (has_priv("admin")) {
				$t->set_var(array(
					"c_special_level"	=> $qid_c->f("special_level") . " - ",
					"category_id"		=> $qid_c->f("id"),
					"cname"			=> ov($qid_c->f("name"))
				));
			} else {
				$t->set_var(array(
					"c_special_level"	=> "",
					"category_id"		=> $qid_c->f("id"),
					"cname"			=> ov($qid_c->f("name"))
				));
			}
			$t->parse("category_rows", "category_row", true);
		}
	}
	$t->set_var("adminnoframes2_blck", "");
	if (has_priv("admin"))
		$t->parse("adminnoframes2_blck", "adminnoframes2", true);
	$t->parse("noframes2_blck", "noframes2", true);
}

$t->set_block("page", "products", "products_blck");
$t->set_var("products_blck", "");
$t->set_block("page", "no_products", "no_products_blck");
$t->set_var("no_products_blck", "");
//if (($numr = db_num_rows($qid_p)) == 0)
if ($qid_p->num_rows() == 0)
	$t->parse("no_products_blck", "no_products", true);
else {
// Let us define blocks nested inside a product_row...
// We indent the code to highlight the blocks' hierarchical nesting...
	$t->set_block("products", "product_row", "product_rows");
		$t->set_block("product_row", "adminprod", "adminprod_blck");
			$t->set_block("adminprod", "adminprodimage", "adminprodimage_blck");
			$t->set_block("adminprod", "special_flag", "special_flag_blck");
		$t->set_block("product_row", "notadminprod", "notadminprod_blck");
			$t->set_block("notadminprod", "notadminprodimage", "notadminprodimage_blck");
		$t->set_block("product_row", "brand_used", "brand_used_blck");
		$t->set_block("product_row", "iva_used", "iva_used_blck");
		$t->set_block("product_row", "discount_block", "discount_block_blck");
			$t->set_block("discount_block", "discqty_block", "discqty_block_blck");
		$t->set_block("product_row", "weight_used", "weight_used_blck");
// ... end of the blocks :)
	$t->set_var("product_rows", "");	// Now let us reset the product rows container...
//	for ($i=0; $i<$numr; $i++) {
	while ($qid_p->next_record()) {
// Now let us reset the blocks contents...
// We indent the code to highlight the blocks' hierarchical nesting...
		$t->set_var("adminprod_blck", "");
			$t->set_var("adminprodimage_blck", "");
			$t->set_var("special_flag_blck", "");
		$t->set_var("notadminprod_blck", "");
			$t->set_var("notadminprodimage_blck", "");
		$t->set_var("brand_used_blck", "");
		$t->set_var("iva_used_blck", "");
		$t->set_var("discount_block_blck", "");
			$t->set_var("discqty_block_blck", "");
		$t->set_var("weight_used_blck", "");
// ... now we have reset all nested blocks :)
//		$prod = db_fetch_object($qid_p, $i);
		$t->set_var(array(
			"id"		=> $id,
			"product_id"	=> $qid_p->f("id"),
			"pname"		=> ov($qid_p->f("name")),
			"price"		=> price,
			"fprice"	=> formatted_price($qid_p->f("price")),
			"description"	=> ovwbr($qid_p->f("description"))
		));
		if (has_priv("admin")) {
			if (file_exists($CFG->productsdir.string_cleanup($qid_p->f("id")).".thumb.jpg")) {
				$t->set_var(array(
					"imagefilename"	=> string_cleanup($qid_p->f("id")),
					"thumbwidth"	=> $qid_p->f("thumbwidth"),
					"thumbheight"	=> $qid_p->f("thumbheight")
				));
				$t->parse("adminprodimage_blck", "adminprodimage", true);
			}
			$t->set_var("p_special_level", $qid_p->f("special_level"));
			if ($qid_p->f("special_flag"))
				$t->parse("special_flag_blck", "special_flag", true);
			$t->parse("adminprod_blck", "adminprod", true);
		} else {
			if (file_exists($CFG->productsdir.string_cleanup($qid_p->f("id")).".thumb.jpg")) {
				$t->set_var(array(
					"imagefilename"	=> string_cleanup($qid_p->f("id")),
					"thumbwidth"	=> $qid_p->f("thumbwidth"),
					"thumbheight"	=> $qid_p->f("thumbheight")
				));
				$t->parse("notadminprodimage_blck", "notadminprodimage", true);
			}
			$t->parse("notadminprod_blck", "notadminprod", true);
		}
		if ($SESSION["brand_used"] && $qid_p->f("bname") != "") {
			$t->set_var("bname", ov($qid_p->f("bname")));
			$t->parse("brand_used_blck", "brand_used", true);
		}
		if ($SESSION["iva_used"]) {
			$t->set_var("iva", $qid_p->f("iva"));
			$t->parse("iva_used_blck", "iva_used", true);
		}
		if ($qid_p->f("discount") > 0) {
			$t->set_var("discount", $qid_p->f("discount"));
			if ($qid_p->f("discqty") > 1) {
				$t->set_var("discqty", $qid_p->f("discqty"));
				$t->parse("discqty_block_blck", "discqty_block", true);
			}
			$t->parse("discount_block_blck", "discount_block", true);
		}
		if ($SESSION["weight_used"]) {
			$t->set_var(array(
				"weight"	=> $qid_p->f("weight"),
				"fweight"	=> formatted_weight($qid_p->f("weight"))
			));
			$t->parse("weight_used_blck", "weight_used", true);
		}
		$t->parse("product_rows", "product_row", true);
	}
	$t->parse("products_blck", "products", true);
}

$t->pparse("out", "page");
//include("templates/index.ihtml");

include("$CFG->dirroot"."/footer.php");

?>
