<?php
/* products.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi <pratesi@telug.it> */
/* (c) 2000, 2001 Fabio Molinari <fabio.m@mclink.it> */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include ("../application.inc.php");
require_login();
require_priv("admin");

$qid = new PGM_Sql;

$DOC_TITLE = "Products_Management";
include ("header.php");

switch (nvl($mode)) {
	case "details" :
		print_product_details($product_id);
		break;

	case "add" :
		print_add_product_form(nvl($category_id, 1));
		break;

	case "edit" :
		print_edit_product_form($product_id);
		break;

	case "del" :
		delete_product($product_id);
//		print_product_list();
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_product_form(&$HTTP_POST_VARS, &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_product($HTTP_POST_VARS, $HTTP_POST_FILES);
//			print_product_list();
		} else {
			/* set default values for the reset of the fields */
			$frm = $HTTP_POST_VARS;
			$frm["newmode"] = "insert";
			$frm["submit_caption"] = "Add_Product";
			/* build the categories listbox options, preselect the top item */
			$qid->begin();
			build_category_tree(&$qid, &$category_options, $frm["categories"]);
			$qid->commit();
			include ("$CFG->dirroot" . "/form_header.php");
			load_product_form_template($frm, $category_options, $errors);
		}
		break;

	case "update" :
		$errors = new Object;
		$errormsg = "";
		validate_product_form(&$HTTP_POST_VARS, &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_product($HTTP_POST_VARS, $HTTP_POST_FILES);
//			print_product_list();
		} else {
			/* set default values for the reset of the fields */
			$frm = $HTTP_POST_VARS;
			$frm["newmode"] = "update";
			$frm["submit_caption"] = "Save_Changes";
			/* build the categories listbox options, preselect the top item */
			$qid->begin();
			build_category_tree(&$qid, &$category_options, $frm["categories"]);
			$qid->commit();
			include ("$CFG->dirroot" . "/form_header.php");
			load_product_form_template($frm, $category_options, $errors);
		}
		break;

	case "import" :
		print_import_products_form();
		break;

	case "update_imp" :
		if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none")
			print_import_products_form();
		else
			import_products($HTTP_POST_FILES);
		break;

	case "imgimport" :
		print_import_images_form();
		break;

	case "update_impimg" :
		if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none")
			print_import_images_form();
		else
			import_images($HTTP_POST_FILES);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_product_list();
		break;
}

$qid->close();

include ("footer.php");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function validate_product_form(&$frm, &$errors, &$errormsg) {

	global $SESSION;

	validate_product_code($frm["code"], &$errors, &$errormsg);
	validate_product_name($frm["name"], &$errors, &$errormsg);
	validate_price($frm["price"], &$errors, &$errormsg);
	validate_discount($frm["discount"], $frm["discqty"], &$errors, &$errormsg);
	if($SESSION["weight_used"])
		validate_weight($frm["weight"], &$errors, &$errormsg);
	validate_special_level($frm["special_level"], &$errors, &$errormsg);
	validate_product_description($frm["description"], &$errors, &$errormsg);
	validate_product_extended_description($frm["extended_description"], &$errors, &$errormsg);
}

function load_product_form_template($frm, $category_options, $errors) {

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
//	include ($CFG->globalerror);
	global $qid;

	$t = new Template();
	$t->set_file(array("page" => "templates/product_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"			=> $frm["newmode"],
		"frm_product_id"		=> $frm["product_id"],
		"frm_old_imagetype"		=> $frm["old_imagetype"],
		"frm_old_imagewidth"		=> $frm["old_imagewidth"],
		"frm_old_imageheight"		=> $frm["old_imageheight"],
		"frm_old_thumbwidth"		=> $frm["old_thumbwidth"],
		"frm_old_thumbheight"		=> $frm["old_thumbheight"],
		"session_max_file_size_images"	=> $SESSION["max_file_size_images"],
		"category_options"		=> $category_options,
		"frm_product_id"		=> $frm["product_id"],
		"errors_product_id"		=> errmsg($errors->product_id),
		"frm_product_code"		=> ov($frm["code"]),
		"errors_product_code"		=> errmsg($errors->product_code),
		"frm_product_name"		=> ov($frm["name"]),
		"errors_product_name"		=> errmsg($errors->product_name),
		"frm_product_price"		=> $frm["price"],
		"errors_product_price"		=> errmsg($errors->price),
		"frm_product_discount"		=> $frm["discount"],
		"errors_product_discount"	=> errmsg($errors->discount),
		"frm_product_discqty"		=> $frm["discqty"],
		"errors_product_discqty"	=> errmsg($errors->discqty),
		"frm_special_flag"		=> $frm["special_flag"] ? "checked" : "",
		"frm_product_special_level"	=> $frm["special_level"],
		"errors_product_special_level"	=> errmsg($errors->special_level),
		"frm_product_description"	=> ov($frm["description"]),
		"errors_product_description"	=> errmsg($errors->description),
		"frm_product_extended_description"	=> ov($frm["extended_description"]),
		"errors_product_extended_description"	=> errmsg($errors->extended_description),
		"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->set_block("page", "brand_used", "brand_used_blck");
	$t->set_var("brand_used_blck", "");
	if($SESSION["brand_used"]) {
		// load up all the brands
		$qid->Query("SELECT id, name FROM brands");
		$frm["brands"] = array();
		$numr = $qid->num_rows();
		$t->set_block("brand_used", "brand_used_option", "brand_used_options");
		$t->set_var("brand_used_options", "");
		for ($i=0; $i<$numr; $i++) {
//			$qid->seek($i);
			$qid->next_record();
			$t->set_var(array(
				"frm_brand_id"		=> $qid->f("id"),
				"frm_brand_selected"	=> $frm["brand_id"] == $qid->f("id") ? "selected" : "",
				"frm_brand_name"	=> $qid->f("name")
			));
			$t->parse("brand_used_options", "brand_used_option", true);
		}
		$t->parse("brand_used_blck", "brand_used", true);
	}
	$t->set_block("page", "iva_used", "iva_used_blck");
	$t->set_var("iva_used_blck", "");
	if($SESSION["iva_used"]) {
		// load up all the iva percentages
		$qid->Query("SELECT id, iva FROM iva ORDER BY iva");
		$frm["iva"] = array();
		$numr = $qid->num_rows();
		$t->set_block("iva_used", "iva_used_option", "iva_used_options");
		$t->set_var("iva_used_options", "");
		for ($i=0; $i<$numr; $i++) {
//			$qid->seek($i);
			$qid->next_record();
			$t->set_var(array(
				"frm_iva_id"		=> $qid->f("id"),
				"frm_iva_selected"	=> $frm["iva_id"] == $qid->f("id") ? "selected" : "",
				"frm_iva_iva"		=> $qid->f("iva")
			));
			$t->parse("iva_used_options", "iva_used_option", true);
		}
		$t->parse("iva_used_blck", "iva_used", true);
	}
	$t->set_block("page", "weight_used", "weight_used_blck");
	$t->set_var("weight_used_blck", "");
	if($SESSION["weight_used"]) {
		$t->set_var(array(
			"frm_product_weight"	=> $frm["weight"],
			"errors_product_weight"	=> errmsg($errors->weight)
		));
		$t->parse("weight_used_blck", "weight_used", true);
	}
	$t->set_block("page", "delete_current_image", "delete_current_image_blck");
	$t->set_var("delete_current_image_blck", "");
	if ($frm["newmode"] == "update" && $frm["old_imagetype"] != "") {
		$t->set_var("frm_delete_image_checked", $frm["delete_image"] ? "checked" : "");
		$t->parse("delete_current_image_blck", "delete_current_image", true);
	}
	$t->pparse("out", "page");
}

function print_product_details($product_id) {
/* print a product form so we can edit the selected product */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
//	include ($CFG->globalerror);
	global $qid;

	/* load up the information for the product */
	$qid->Query("
		SELECT p.*, b.name AS bname, i.iva
		FROM products p, brands b, iva i
		WHERE p.brand_id = b.id AND p.iva_id = i.id AND p.id = '$product_id'
	");
	$qid->next_record();
	$frm["id"] = $qid->f("id");
	$frm["code"] = $qid->f("code");
	$frm["name"] = $qid->f("name");
	$frm["brand_id"] = $qid->f("brand_id");
	$frm["price"] = $qid->f("price");
	$frm["iva_id"] = $qid->f("iva_id");
	$frm["discount"] = $qid->f("discount");
	$frm["discqty"] = $qid->f("discqty");
	$frm["weight"] = $qid->f("weight");
	$frm["special_flag"] = $qid->f("special_flag");
	$frm["special_level"] = $qid->f("special_level");
	$frm["description"] = $qid->f("description");
	$frm["extended_description"] = $qid->f("extended_description");
	$frm["imagetype"] = $qid->f("imagetype");
	$frm["imagewidth"] = $qid->f("imagewidth");
	$frm["imageheight"] = $qid->f("imageheight");
	$frm["thumbwidth"] = $qid->f("thumbwidth");
	$frm["thumbheight"] = $qid->f("thumbheight");
	$frm["bname"] = $qid->f("bname");
	$frm["iva"] = $qid->f("iva");

	/* load up the categories for the product */
	$qid->Query("
		SELECT category_id
		FROM products_categories
		WHERE product_id = '$product_id'
	");

	$frm["categories"] = array();
	$numr = $qid->num_rows();
	for ($i=0; $i<$numr; $i++) {
//		$qid->seek($i);
		$qid->next_record();
		$frm["categories"][] = $qid->f("category_id");
	}

	/* build the categories listbox options, preselect the selected item */
	$qid->begin();
	build_category_tree(&$qid, &$category_options, $frm["categories"]);
	$qid->commit();

	$t = new Template();
	$t->set_file(array("page" => "templates/product_details.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	if (!empty($SESSION["goback"]["query_string"]))
		$t->set_var("MEargs", "?" . $SESSION["goback"]["query_string"]);
	else
		$t->set_var("MEargs", "");
	$t->set_var(array(
		"frm_name"			=> ov($frm[name]),
		"product_id"			=> $product_id,
		"frm_product_code"		=> ov($frm[code]),
		"frm_extended_description"	=> ovwbr($frm["extended_description"]),
		"frm_price"			=> $frm["price"],
		"frm_fprice"			=> formatted_price($frm["price"]),
		"frm_special_level"		=> $frm["special_level"],
	));
	$t->set_block("page", "brand_used", "brand_used_blck");
	$t->set_var("brand_used_blck", "");
	$t->set_block("page", "iva_used", "iva_used_blck");
	$t->set_var("iva_used_blck", "");
	$t->set_block("page", "discount_block", "discount_block_blck");
	$t->set_var("discount_block_blck", "");
		$t->set_block("discount_block", "discqty_block", "discqty_block_blck");
		$t->set_var("discqty_block_blck", "");
	$t->set_block("page", "weight_used", "weight_used_blck");
	$t->set_var("weight_used_blck", "");
	$t->set_block("page", "special_flag", "special_flag_blck");
	$t->set_var("special_flag_blck", "");
	$t->set_block("page", "adminprodimage", "adminprodimage_blck");
	$t->set_var("adminprodimage_blck", "");
	if ($SESSION["brand_used"] && $frm["bname"] != "") {
		$t->set_var("bname", ov($frm["bname"]));
		$t->parse("brand_used_blck", "brand_used", true);
	}
	if ($SESSION["iva_used"]) {
		$t->set_var("iva", $frm["iva"]);
		$t->parse("iva_used_blck", "iva_used", true);
	}
	if ($frm["discount"] > 0) {
		$t->set_var("discount", $frm["discount"]);
		if ($frm["discqty"] > 1) {
			$t->set_var("discqty", $frm["discqty"]);
			$t->parse("discqty_block_blck", "discqty_block", true);
		}
		$t->parse("discount_block_blck", "discount_block", true);
	}
	if ($SESSION["weight_used"]) {
		$t->set_var(array(
			"weight"	=> $frm["weight"],
			"fweight"	=> formatted_weight($frm["weight"])
		));
		$t->parse("weight_used_blck", "weight_used", true);
	}
	if ($SESSION["special_flag"])
		$t->parse("special_flag_blck", "special_flag", true);
	if (file_exists("$CFG->productsdir" . $product_id . "." . $frm["imagetype"])) {
		$t->set_var(array(
			"imagefilename"	=> $product_id,
			"imagetype"	=> $frm["imagetype"],
			"imagewidth"	=> $prod->imagewidth,
			"imageheight"	=> $prod->imageheight
		));
		$t->parse("adminprodimage_blck", "adminprodimage", true);
	}
	$t->pparse("out", "page");
}

function print_add_product_form($category_id = 1) {
/* print a blank product form so we can add a new product */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
//	include ($CFG->globalerror);
	global $qid;

	/* set default values for the reset of the fields */
	$frm["categories"] = array($category_id);
	$frm["newmode"] = "insert";
	$frm["code"] = "";
	$frm["name"] = "";
	$frm["brand_id"] = "";
	$frm["price"] = "";
	$frm["iva_id"] = "";
	$frm["discount"] = "";
	$frm["discqty"] = "";
	$frm["weight"] = "";
	$frm["special_flag"] = 0;
	$frm["special_level"] = "";
	$frm["description"] = "";
	$frm["extended_description"] = "";
	$frm["submit_caption"] = "Add_Product";

	/* build the categories listbox options, preselect the top item */
	$qid->begin();
	build_category_tree(&$qid, &$category_options, $frm["categories"]);
	$qid->commit();
	load_product_form_template($frm, $category_options, $errors);
}

function print_edit_product_form($product_id) {
/* print a product form so we can edit the selected product */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
//	include ($CFG->globalerror);
	global $qid;

	/* load up the information for the product */
	$qid->Query("SELECT * FROM products WHERE id = '$product_id'");
	$qid->next_record();
	$frm["id"] = $qid->f("id");
	$frm["code"] = $qid->f("code");
	$frm["name"] = $qid->f("name");
	$frm["brand_id"] = $qid->f("brand_id");
	// workaround to avoid ".00" with MySQL 3.22.32
	// and "2.5e+07" with MySQL 3.23.36
	// ereg_replace is needed with PHP 4.0.0 and 4.0.1pl2
	if ($SESSION["price_must_be_integer"])
		$frm["price"] = ereg_replace (",", "", number_format ($qid->f("price"), 0, "", ""));
	else
		$frm["price"] = $qid->f("price");
	$frm["iva_id"] = $qid->f("iva_id");
	$frm["discount"] = $qid->f("discount");
	$frm["discqty"] = $qid->f("discqty");
	$frm["weight"] = $qid->f("weight");
	$frm["special_flag"] = $qid->f("special_flag");
	$frm["special_level"] = $qid->f("special_level");
	$frm["description"] = $qid->f("description");
	$frm["extended_description"] = $qid->f("extended_description");
	$frm["imagetype"] = $qid->f("imagetype");
	$frm["imagewidth"] = $qid->f("imagewidth");
	$frm["imageheight"] = $qid->f("imageheight");
	$frm["thumbwidth"] = $qid->f("thumbwidth");
	$frm["thumbheight"] = $qid->f("thumbheight");
	$frm["old_product_id"] = $product_id;
	$frm["old_imagetype"] = $frm["imagetype"];
	$frm["old_imagewidth"] = $frm["imagewidth"];
	$frm["old_imageheight"] = $frm["imageheight"];
	$frm["old_thumbwidth"] = $frm["thumbwidth"];
	$frm["old_thumbheight"] = $frm["thumbheight"];
	$frm["product_id"] = $product_id;

	/* load up the categories for the product */
	$qid->Query("
		SELECT category_id
		FROM products_categories
		WHERE product_id = '$product_id'
	");

	$frm["categories"] = array();
	$numr = $qid->num_rows();
	for ($i=0; $i<$numr; $i++) {
//		$qid->seek($i);
		$qid->next_record();
		$frm["categories"][] = $qid->f("category_id");
	}

	/* set values for the form */
	$frm["newmode"] = "update";
	$frm["submit_caption"] = "Save_Changes";

	/* build the categories listbox options, preselect the selected item */
	$qid->begin();
	build_category_tree(&$qid, &$category_options, $frm["categories"]);
	$qid->commit();
	load_product_form_template($frm, $category_options, $errors);
}

function delete_product($product_id) {
/* delete the product specified by $product_id, we have to delete the product and then
 * the appropriate entries from the products_categories table.  this should be
 * wrapped inside a transaction, unfortunately MySQL currently does not support
 * transactions. */

	global $CFG, $ME;
	global $SESSION;
//	include ($CFG->globalerror);
	global $qid;

	$qid->begin();

	/* load up the information for the product */
	$qid->Query("
		SELECT name, imagetype
		FROM products
		WHERE id = '$product_id'
	");
	$qid->next_record();
	$prod->name = $qid->f("name");
	$prod->imagetype = $qid->f("imagetype");

	/* delete this product */
	$qid->Query("DELETE FROM products WHERE id = '$product_id'");

// Remove the product image
	if ($prod->imagetype != "") {
		$upload_path = "$CFG->productsdir";
		$upload_name = $upload_path . $product_id;
		$upload_name_thumb = $upload_name . ".thumb.jpg";
		$upload_name .= "." . $prod->imagetype;
		system ("rm -f $upload_name $upload_name_thumb", $result);
	}

	/* delete this product from the products_categories table */
	$qid->Query("
		DELETE FROM products_categories
		WHERE product_id = '$product_id'
	");

	$qid->commit();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/product_deleted.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	$t->set_var(array(
		"prod_name"	=> ov($prod->name),
		"backurl"	=> $backurl
	));
        $t->pparse("out", "page");
}

function insert_product($frm, $HTTP_POST_FILES) {
/* add a new product.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME, $SESSION;
	include ($CFG->globalerror);
	global $qid;

	if ($frm[extended_description] == "")
		$frm[extended_description] = $frm[description];
	while (list($key, $val) = each($frm))
		if (is_string($val)) $frm[$key] = addslashes($val);

	/* add the product into the products table */
	$qid->begin();

	$qid->lock("products");
	$qid->Query("
		INSERT INTO products (
			 code
			,name
			,brand_id
			,price
			,iva_id
			,discount
			,discqty
			,weight
			,special_flag
			,special_level
			,description
			,extended_description
		)
		VALUES (
			'$frm[code]'
			,'$frm[name]'
			,'$frm[brand_id]'
			,'$frm[price]'
			,'$frm[iva_id]'
			,'$frm[discount]'
			,'$frm[discqty]'
			,'$frm[weight]'
			,'$frm[special_flag]'
			,'$frm[special_level]'
			,'$frm[description]'
			,'$frm[extended_description]'
		)
	");
	$qid->Query("SELECT id FROM products ORDER BY id DESC");
	$qid->next_record();
	$inserted_product_id = $qid->f("id");
	$qid->unlock();

	/* add this product under the specified categories */
	for ($i=0; $i<count($frm["categories"]); $i++)
		$qid->Query("
			INSERT INTO products_categories (category_id, product_id)
			VALUES ('{$frm["categories"][$i]}', '$inserted_product_id')
		");

	if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none") {
		$type = "";
		echo "<div class=normal>" . $no_product_image_chosen . "</div>";
	} else {
		$size = getimagesize ($HTTP_POST_FILES['userfile']['tmp_name']);
		switch ($size[2]) {
			case 1 :
				$type = "gif";
				$convert = "giftopnm";
				break;
			case 2 :
				$type = "jpg";
				$convert = "djpeg";
				break;
			case 3 :
				$type = "png";
				$convert = "pngtopnm";
				break;
			default:
				$type = "";
				echo "<div class=warning>" . $unsupported_image_type . "</div>";
		}
		if ($type != "") {
			$upload_path = "$CFG->productsdir";
			$upload_name = $upload_path . $inserted_product_id;
			$upload_thumb_name = $upload_name . ".thumb.jpg";
			$upload_name .= "." . $type;
			system("$CFG->pnmpath/$convert " . $HTTP_POST_FILES['userfile']['tmp_name'] . " | " .
				"$CFG->pnmpath/pnmscale -xysize 100 80 | " .
				"$CFG->pnmpath/cjpeg -optimize -progressive -quality 85 > " .
				$upload_thumb_name, $result);
			$thumbsize = getimagesize ($upload_thumb_name);
			if (!copy($HTTP_POST_FILES['userfile']['tmp_name'], $upload_name)) {
				echo "<div class=warning>" . $image_upload_failed . "</div>";
			} else {
				system ("chmod 644 $upload_name", $result);
			}
		}
	}

	$qid->Query("
		UPDATE products SET
			 imagetype = '$type'
			,imagewidth = '$size[0]'
			,imageheight = '$size[1]'
			,thumbwidth = '$thumbsize[0]'
			,thumbheight = '$thumbsize[1]'
		WHERE id = '$inserted_product_id'
	");

	$qid->commit();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/product_added.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	$t->set_var(array(
		"frm_product_id"	=> $inserted_product_id,
		"backurl"		=> $backurl
	));
        $t->pparse("out", "page");
}

function update_product($frm, $HTTP_POST_FILES) {
/* update a product with new values.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->globalerror);
	global $qid;

	$type = $frm["old_imagetype"];
	$imagewidth = $frm["old_imagewidth"];
	$imageheight = $frm["old_imageheight"];
	$thumbwidth = $frm["old_thumbwidth"];
	$thumbheight = $frm["old_thumbheight"];

/* does PHP 4.0.4pl1 have a bug causing $HTTP_POST_FILES['userfile']['type'] == "" ?
echo ";".$HTTP_POST_FILES['userfile']['name'].";";
echo     $HTTP_POST_FILES['userfile']['tmp_name'].";";
echo     $HTTP_POST_FILES['userfile']['size'].";";
echo     $HTTP_POST_FILES['userfile']['type'].";";
echo "<br><br>";
foreach($HTTP_POST_FILES['userfile'] as $k => $v) {
	echo "\$HTTP_POST_FILES['userfile'][$k] => ;$v;";
	echo "<br>";
}
*/

	if ($frm[delete_image]) {
		$upload_path = "$CFG->productsdir";
		$upload_name = $upload_path . $frm[product_id];
		$upload_name_thumb = $upload_name . ".thumb.jpg";
		system ("rm -f $upload_name_thumb", $result);
		$upload_name .= "." . $frm["old_imagetype"];
		system ("rm -f $old_upload_name", $result);
		$imagewidth = "";
		$imageheight = "";
		$thumbwidth = "";
		$thumbheight = "";
		$type = "";
	} else if ($HTTP_POST_FILES['userfile']['tmp_name'] == "none") {
		echo "<div class=normal>" . $no_product_image_chosen . "</div>";
	} else {
		$size = getimagesize ($HTTP_POST_FILES['userfile']['tmp_name']);
		switch ($size[2]) {
			case 1 :
				$newtype = "gif";
				$convert = "giftopnm";
				break;
			case 2 :
				$newtype = "jpg";
				$convert = "djpeg";
				break;
			case 3 :
				$newtype = "png";
				$convert = "pngtopnm";
				break;
			default:
				$newtype = "";
				echo "<div class=warning>" . $unsupported_image_type . "</div>";
		}
		if ($newtype != "") {
			$upload_path = "$CFG->productsdir";
			$upload_name = $upload_path . $frm[product_id];
			$upload_thumb_name = $upload_name . ".thumb.jpg";
			$upload_name .= "." . $newtype;
			$type = $newtype;
			$imagewidth = $size[0];
			$imageheight = $size[1];
			system("$CFG->pnmpath/$convert " . $HTTP_POST_FILES['userfile']['tmp_name'] . " | " .
				"$CFG->pnmpath/pnmscale -xysize 100 80 | " .
				"$CFG->pnmpath/cjpeg -optimize -progressive -quality 85 > " .
				$upload_thumb_name, $result);
			$thumbsize = getimagesize ($upload_thumb_name);
			$thumbwidth = $thumbsize[0];
			$thumbheight = $thumbsize[1];
			if (!copy($HTTP_POST_FILES['userfile']['tmp_name'], $upload_name))
				echo "<div class=warning>" . $image_upload_failed . "</div>";
			else
				system ("chmod 644 $upload_name", $result);
		}
	}

	$qid->begin();

	/* update the products table with the new information */
	if ($frm[extended_description] == "")
		$frm[extended_description] = $frm[description];
	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid->Query("
		UPDATE products SET
			 code = '$frm[code]'
			,name = '$frm[name]'
			,brand_id = '$frm[brand_id]'
			,price = '$frm[price]'
			,iva_id = '$frm[iva_id]'
			,discount = '$frm[discount]'
			,discqty = '$frm[discqty]'
			,weight = '$frm[weight]'
			,special_flag = '$frm[special_flag]'
			,special_level = '$frm[special_level]'
			,description = '$frm[description]'
			,extended_description = '$frm[extended_description]'
			,imagetype = '$type'
			,imagewidth = '$imagewidth'
			,imageheight = '$imageheight'
			,thumbwidth = '$thumbwidth'
			,thumbheight = '$thumbheight'
		WHERE id = '$frm[product_id]'
	");

	/* delete all the categories this product was associated with */
	$qid->Query("
		DELETE FROM products_categories
		WHERE product_id = '$frm[product_id]'
	");

	/* add associations for all the categories this product belongs to, if
 	* no categories were selected, we will make it belong to the top
 	* category */
	if (count($frm["categories"]) == 0) {
		$frm["categories"][] = 1;
	}

	for ($i=0; $i<count($frm["categories"]); $i++) {
		$qid->Query("
			INSERT INTO products_categories (category_id, product_id)
			VALUES ('{$frm["categories"][$i]}', '$frm[product_id]')
		");
	}

	$qid->commit();

	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";

	$t = new Template();
	$t->set_file(array("page" => "templates/product_updated.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	$t->set_var(array(
		"frm_product_id"	=> ov($frm[product_id]),
		"backurl"		=> $backurl
	));
        $t->pparse("out", "page");
}

function print_product_list() {
/* read all the products from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $weightunity;
	global $page_number, $dbchanged;
//	include ($CFG->globalerror);
	global $qid;

	if (!isset($page_number) || $dbchanged) {
		$qid->Query("
			SELECT
				p.id AS product_id
				,p.code
				,p.name
				,p.price
				,p.discount
				,p.discqty
				,p.weight
				,p.imagetype
				,p.imagewidth
				,p.imageheight
				,p.thumbwidth
				,p.thumbheight
				,c.name AS category
				,i.iva
			FROM products p, products_categories pc, categories c, iva i
			WHERE p.id = pc.product_id AND c.id = pc.category_id AND p.iva_id = i.id ORDER BY c.name
  		");
		$SESSION["numr"] = $qid->num_rows();
		for ($i=0; $i<$SESSION["numr"]; $i++) {
//			$qid->seek($i);
			$qid->next_record();
			$SESSION["products"][$i]["product_id"] = $qid->f("product_id");
			$SESSION["products"][$i]["code"] = $qid->f("code");
			$SESSION["products"][$i]["name"] = $qid->f("name");
			$SESSION["products"][$i]["price"] = $qid->f("price");
			$SESSION["products"][$i]["discount"] = $qid->f("discount");
			$SESSION["products"][$i]["discqty"] = $qid->f("discqty");
			$SESSION["products"][$i]["weight"] = $qid->f("weight");
			$SESSION["products"][$i]["magetype"] = $qid->f("magetype");
			$SESSION["products"][$i]["imagewidth"] = $qid->f("imagewidth");
			$SESSION["products"][$i]["imageheight"] = $qid->f("imageheight");
			$SESSION["products"][$i]["thumbwidth"] = $qid->f("thumbwidth");
			$SESSION["products"][$i]["thumbheight"] = $qid->f("thumbheight");
			$SESSION["products"][$i]["category"] = $qid->f("category");
			$SESSION["products"][$i]["iva"] = $qid->f("iva");
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["products_per_page"]) {
		$first = ($page_number-1)*$SESSION["products_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["products_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["products_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["products_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	$t = new Template();
	$t->set_file(array("page" => "templates/product_list.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
		$t->set_block("page", "pages_links_top", "pages_links_top_blck");
	$t->set_var("pages_links_top_blck", "");
	$t->set_block("page", "pages_links_bottom", "pages_links_bottom_blck");
	$t->set_var("pages_links_bottom_blck", "");
	if ($num_pages > 1) {
		include ("pages_links.php");
		$t->set_var("pages_links", $pages_links);
		$t->parse("pages_links_top_blck", "pages_links_top", true);
		$t->parse("pages_links_bottom_blck", "pages_links_bottom", true);
	}
	$t->set_block("page", "weight_used_th", "weight_used_th_blck");
	$t->set_var("weight_used_th_blck", "");
	if($SESSION["weight_used"])
		$t->parse("weight_used_th_blck", "weight_used_th", true);
	$t->set_block("page", "product_row", "product_rows");
	$t->set_var("product_rows", "");
		$t->set_block("product_row", "adminprodimage", "adminprodimage_blck");
		$t->set_block("product_row", "adminprodnoimage", "adminprodnoimage_blck");
		$t->set_block("product_row", "iva_used", "iva_used_blck");
		$t->set_block("product_row", "weight_used_td", "weight_used_td_blck");
	for ($i=$first; $i<=$last; $i++) {
		$t->set_var("adminprodimage_blck", "");
		$t->set_var("adminprodnoimage_blck", "");
		$t->set_var("iva_used_blck", "");
		$t->set_var("weight_used_td_blck", "");
		$t->set_var(array(
			"session_product_id"		=> ov($SESSION["products"][$i]["product_id"]),
			"session_product_code"		=> ov($SESSION["products"][$i]["code"]),
			"session_products_name"		=> ov($SESSION["products"][$i]["name"]),
			"session_products_category"	=> ov($SESSION["products"][$i]["category"]),
			"session_products_price"	=> $SESSION["products"][$i]["price"],
			"session_products_fprice"	=> formatted_price($SESSION["products"][$i]["price"])
		));
		if (file_exists("$CFG->productsdir" . $SESSION["products"][$i]["product_id"] . ".thumb.jpg")) {
			$t->set_var(array(
				"imagefilename"	=> $SESSION["products"][$i]["product_id"],
				"thumbwidth"	=> $SESSION["products"][$i]["thumbwidth"],
				"thumbheight"	=> $SESSION["products"][$i]["thumbheight"]
			));
			$t->parse("adminprodimage_blck", "adminprodimage", true);
		} else
			$t->parse("adminprodnoimage_blck", "adminprodnoimage", true);
		if ($SESSION["iva_used"]) {
			$t->set_var("session_products_iva", $SESSION["products"][$i]["iva"]);
			$t->parse("iva_used_blck", "iva_used", true);
		}
		if($SESSION["weight_used"]) {
			$t->set_var(array(
				"session_products_weight"	=> $SESSION["products"][$i]["weight"],
				"session_products_fweight"	=> formatted_weight($SESSION["products"][$i]["weight"])
			));
			$t->parse("weight_used_td_blck", "weight_used_td", true);
		}
		$t->parse("product_rows", "product_row", true);
	}
	$t->pparse("out", "page");
}

function print_import_products_form() {
/* print the import products form so we can add/update products from a text file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Button_Label";
	$frm["newmode"] = "update_imp";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"			=> $frm["newmode"],
		"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
		"frm_submit_caption"		=> $t->get_var($frm["submit_caption"])
	));
	$t->pparse("out", "page");
}

function import_products($HTTP_POST_FILES) {
/* Import products from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->globalerror);
	global $qid;

	/* Let's open a transaction */
	$qid->begin();

	$fcontents = file ($HTTP_POST_FILES['userfile']['tmp_name']);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
		$fldarr = split("\t",ereg_replace("\n$","",$line));
//echo "<b>" . $line_num . "</b>:" . $line . "<br>";
		/* dangerous characters quoting */
		for ($i=0; $i<13; $i++)
			$fldarr[$i] = addslashes($fldarr[$i]);

		/* Let's see if the category exists ... */
		$qid->Query("SELECT id FROM categories WHERE name = '$fldarr[0]'");
		if ($qid->num_rows() == 0) {
			/* ... if it doesn't exist let's return an error ... */
			echo $line_num . $Err_ImpCat . $fldarr[0] . "'.<br>";
		} else {
			/* ... otherwise let's save its ID ... */
			$qid->next_record();
			$cid = $qid->f("id");

			if($SESSION["brand_used"]) {
				if ($fldarr[3] == "") {
					// brand not defined, set the brand_id to 0
					$fldarr[3] = 0;
				} else {
					/* Let's see if the brand exists ... */
					$qid->Query("SELECT id FROM brands WHERE name = '$fldarr[3]'");
					if ($qid->num_rows() == 0) {
						/* ... if it doesn't exist let's return an error ... */
						echo $line_num . $Err_ImpBrand . $fldarr[3] . "'.<br>";
						$fldarr[3] = "";
					} else {
						/* ... otherwise let's substitute it with its id */
						$qid->next_record();
						$fldarr[3] = $qid->f("id");
					}
				}
			}
			if($SESSION["iva_used"]) {
				if ($fldarr[5] == "") {
					// iva not defined, set it to 0 (iva_id = 0)
					$fldarr[5] = 0;
				} else {
					/* Let's see if the iva exists ... */
					$qid->Query("SELECT id FROM iva WHERE iva = '$fldarr[5]'");
					if ($qid->num_rows() == 0) {
						/* ... if it doesn't exist let's return an error ... */
						echo $line_num . $Err_ImpIVA . $fldarr[5] . "'.<br>";
						$fldarr[5] = "";
					} else {
						/* ... otherwise let's substitute it with its id */
						$qid->next_record();
						$fldarr[5] = $qid->f("id");
					}
				}
			}

			/* ... and let's see if the product already exists ... */
			$qid->Query("SELECT id FROM products WHERE code = '$fldarr[1]' ORDER BY id DESC");
			if ($qid->num_rows() == 0) {
				/* ... if it doesn't exist let's create it in the products table ... */
				if ($frm[extended_description] == "")
					$frm[extended_description] = $frm[description];
				$qid->lock("products");
				$qid->Query("
					INSERT INTO products (
						 code
						,name
						,brand_id
						,price
						,iva_id
						,discount
						,discqty
						,weight
						,special_flag
						,special_level
						,description
						,extended_description
					)
					VALUES (
						'$fldarr[1]'
						,'$fldarr[2]'
						,'$fldarr[3]'
						,'$fldarr[4]'
						,'$fldarr[5]'
						,'$fldarr[6]'
						,'$fldarr[7]'
						,'$fldarr[8]'
						,'$fldarr[9]'
						,'$fldarr[10]'
						,'$fldarr[11]'
						,'$fldarr[12]'
					)
				");
				$qid->Query("SELECT id FROM products ORDER BY id DESC");
				$qid->next_record();
				$inserted_product_id = $qid->f("id");
				$qid->unlock();
				/* ... and create it in the products_categories table ... */
				$qid->Query("
					INSERT INTO products_categories (product_id, category_id)
					VALUES ('$inserted_product_id', '$cid')
				");
			} else {
				/* ... otherwise let's update it in the products table ... */
				$qid->next_record();
				$updated_product_id = $qid->f("id");
				if ($frm[extended_description] == "")
					$frm[extended_description] = $frm[description];
				$qid->Query("
					UPDATE products SET
						 name = '$fldarr[2]'
						,brand_id = '$fldarr[3]'
						,price = '$fldarr[4]'
						,iva_id = '$fldarr[5]'
						,discount = '$fldarr[6]'
						,discqty = '$fldarr[7]'
						,weight = '$fldarr[8]'
						,special_flag = '$fldarr[9]'
						,special_level = '$fldarr[10]'
						,description = '$fldarr[11]'
						,extended_description = '$fldarr[12]'
					WHERE id = '$updated_product_id'
				");
				/* ... then, let's see if the product already exists with this category ... */
				$qid->Query("
					SELECT category_id
					FROM products_categories
					WHERE product_id = '$updated_product_id' AND category_id = '$cid'
				");
				if ($qid->num_rows() == 0) {
					/* ... if it doesn't exist let's create it in the products_categories table ... */
					$qid->Query("
						INSERT INTO products_categories (product_id, category_id)
						VALUES ('$updated_product_id', '$cid')
					");
				}
			}
		}
	}

	/* Let's close the transaction */
	$qid->commit();
	
	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
}

function print_import_images_form() {
/* print the import images form so we can add/update images from a zip file */
	global $CFG, $ME, $SESSION;
//	include ($CFG->globalerror);

	/* set values for the form */
	$frm["submit_caption"] = "Import_Images_Button_Label";
	$frm["newmode"] = "update_impimg";

	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_form.ihtml"));
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var(array(
		"frm_newmode"			=> $frm["newmode"],
		"session_max_file_size_import"	=> $SESSION["max_file_size_import"],
		"frm_submit_caption"		=> $t->get_var($frm["submit_caption"]) . " (.tar.gz, .tgz, .zip)"
	));
	$t->pparse("out", "page");
}

function import_images($HTTP_POST_FILES) {
/* Import products from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->globalerror);
	$upload_path = "$CFG->productsdir";
	global $qid;

	/* Let's open a transaction */
	$qid->begin();

	// Let's unzip the file with images into tempdir ...
	$tmpdir = "$CFG->productsdir" . "/tmp/";
	system ("rm -rf $tmpdir", $result);
	system ("mkdir " . $tmpdir, $result);
	system ("unzip -qq ".$HTTP_POST_FILES['userfile']['tmp_name']." -d " . $tmpdir, $result);
	system ("gzip -dc ".$HTTP_POST_FILES['userfile']['tmp_name']." | tar xf - -C " . $tmpdir, $result);
	// Let's manage all files in the tempdir
	$handle = opendir($tmpdir);
//echo "Directory handle: $handle\n";
//echo "Files:\n";
	while ($file = readdir($handle)) {
//echo "$file\n";
//echo strtok($file,'.') . "\n";
		$pcode = strtok($file,'.');
		if (!empty($pcode)) {
//			$appoggio = string_cleanup($pcode);
			$qid->Query("SELECT id, imagetype FROM products WHERE code = '$pcode' ORDER BY id DESC");
			if ($qid->num_rows() > 0) {
				$qid->next_record();
				$product_id = $qid->f("id");
				$oldtype = $qid->f("imagetype");
				$upload_name = $upload_path . $product_id;
				$size = getimagesize ($tmpdir . $file);
				switch ($size[2]) {
					case 1 :
						$type = "gif";
						$convert = "giftopnm";
						break;
					case 2 :
						$type = "jpg";
						$convert = "djpeg";
						break;
					case 3 :
						$type = "png";
						$convert = "pngtopnm";
						break;
					default :
						$type = "";
						echo "<div class=warning>" . $pcode . ": " . $unsupported_image_type . "</div>";
				}
				if ($type != "") {
					$upload_name_thumb = $upload_name . ".thumb.jpg";
					$upload_name_old = $upload_name . "." . $oldtype;
					$upload_name .= "." . $type;
					if (!copy($tmpdir . $file, $upload_name)) {
						echo "<div class=normal>" . $image_upload_failed . "</div>";
					} else {
						system ("chmod 644 $upload_name", $result);
						system ("$CFG->pnmpath/$convert ".$upload_name . " | ".
							"$CFG->pnmpath/pnmscale -xysize 100 80 | ".
							"$CFG->pnmpath/cjpeg -optimize -progressive -quality 85 > ".
							$upload_name_thumb, $result);
						$thumbsize = getimagesize ($upload_name_thumb);
// if we are updating a product image and the old imagetype
// is empty or different from the new one, then we remove the old image
						if ($type != $oldtype)
							system ("rm -f ".$upload_name_old, $result);

						$qid->Query("
							UPDATE products SET
								 imagetype = '$type'
								,imagewidth = '$size[0]'
								,imageheight = '$size[1]'
								,thumbwidth = '$thumbsize[0]'
								,thumbheight = '$thumbsize[1]'
							WHERE id = '$product_id'
						");
					}
				}
			} else echo "<div class=warning>" . $pcode . ": " . $no_products_with_such_code . "</div>";
		}
	}
	closedir($handle); 

	// Let's remove the temporary directory ...
	system ("rm -rf $tmpdir", $result);

	/* Let's close the transaction */
	$qid->commit();
	
	/* The End */
	if (empty($SESSION["goback"]["query_string"]))
		$backurl = $SESSION["goback"]["request_uri"] . "?dbchanged=1";
	else
		$backurl = $SESSION["goback"]["request_uri"] . "&dbchanged=1";
	$t = new Template();
	$t->set_file(array("page" => "templates/data_import_end.ihtml"));
	include ("$CFG->localelangdir" . "/global-common.inc.php");
	include ("$CFG->localelangdir" . "/global-admin.inc.php");
	$t->set_var("ME", $ME);
	$t->set_var("backurl", $backurl);
	$t->pparse("out", "page");
}

?>
