<?
/* categories.php (c) 2000 Ying Zhang (ying@zippydesign.com)
 *
 * TERMS OF USAGE:
 * This file was written and developed by Ying Zhang (ying@zippydesign.com)
 * for educational and demonstration purposes only.  You are hereby granted the
 * rights to use, modify, and redistribute this file as you like.  The only
 * requirement is that you must retain this notice, without modifications, at
 * the top of your source code.  No warranties or guarantees are expressed or
 * implied. DO NOT use this code in a production environment without
 * understanding the limitations and weaknesses pretaining to or caused by the
 * use of these scripts, directly or indirectly. USE AT YOUR OWN RISK!
 */

/* (c) 2000, 2001 Marco Pratesi (pratesi@telug.it) */
/* (c) 2000 Fabio Molinari (fabio.m@mclink.it) */

/******************************************************************************
 * MAIN
 *****************************************************************************/

include("../application.inc.php");
require_login();
require_priv("admin");

$DOC_TITLE = $Categories_Management;
include("templates/header.ihtml");

switch (nvl($mode)) {
	case "add" :
		print_add_category_form(nvl($id, 1));
		break;

	case "edit" :
		print_edit_category_form($id);
		break;

	case "del" :
		if (!($id == 1)) {
			delete_category($id);
		}
		break;

	case "insert" :
		$errors = new Object;
		$errormsg = "";
		validate_category_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_on_special($HTTP_POST_VARS["on_special"], &$errors, &$errormsg);
		validate_category_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			insert_subcategory($id, $HTTP_POST_VARS);
//			print_category_list();
		} else {
			/* set default values for the reset of the fields */
			$frm["parent"] = array($HTTP_POST_VARS["parent"]);
			$frm["categories"] = $HTTP_POST_VARS["categories"];
			$frm["newmode"] = "insert";
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["on_special"] = $HTTP_POST_VARS["on_special"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["submit_caption"] = $Add_Subcategory;
			/* build the categories listbox options, preselect the selected item */
			build_category_tree($category_options, $frm["parent"]);
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/category_form.ihtml");
		}
		break;

	case "update" :
		$errors = new Object;
		$errormsg = "";
		validate_category_name($HTTP_POST_VARS["name"], &$errors, &$errormsg);
		validate_on_special($HTTP_POST_VARS["on_special"], &$errors, &$errormsg);
		validate_category_description($HTTP_POST_VARS["description"], &$errors, &$errormsg);
		if (empty($errormsg)) {
			update_category($id, $HTTP_POST_VARS);
			include("templates/category_updated.ihtml");
		} else {
			/* set default values for the reset of the fields */
			$frm["parent"] = array($HTTP_POST_VARS["parent"]);
			$frm["categories"] = $HTTP_POST_VARS["categories"];
			$frm["newmode"] = "update";
			$frm["name"] = $HTTP_POST_VARS["name"];
			$frm["on_special"] = $HTTP_POST_VARS["on_special"];
			$frm["description"] = $HTTP_POST_VARS["description"];
			$frm["submit_caption"] = $Save_Changes;
			/* build the categories listbox options, preselect the selected item */
			build_category_tree($category_options, $frm["parent"]);
			include("$CFG->templatedir"."form_header.ihtml");
			include("templates/category_form.ihtml");
		}
		break;

	case "import" :
		print_import_category_form();
		break;

	case "update_imp" :
		if ($userfile == 'none')
			print_import_category_form();
		else
			import_category($userfile);
		break;

	default :
		$SESSION["goback"]["request_uri"] = $REQUEST_URI;
		$SESSION["goback"]["query_string"] = $QUERY_STRING;
		print_category_list();
		break;
}

include("templates/footer.ihtml");

/******************************************************************************
 * FUNCTIONS
 *****************************************************************************/

function print_add_category_form($id) {
/* print a blank category form so we can add a new category */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	/* set default values for the reset of the fields */
	$frm["parent"] = array($id);
	$frm["newmode"] = "insert";
	$frm["name"] = "";
	$frm["on_special"] = "";
	$frm["description"] = "";
	$frm["submit_caption"] = $Add_Subcategory;

	/* build the categories listbox options, preselect the selected item */
	build_category_tree($category_options, $frm["parent"]);

	include("templates/category_form.ihtml");
}

function print_edit_category_form($id) {
/* print a category form so we can edit the selected category */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	/* load up the information for the category */
	$qid = db_query("
	SELECT name, on_special, description, parent_id
	FROM categories
	WHERE id = '$id'
	");
	$frm = db_fetch_array($qid, 0);

	/* set values for the form */
	$frm["parent"] = array($frm["parent_id"]);
	$frm["newmode"] = "update";
	$frm["submit_caption"] = $Save_Changes;

	/* build the categories listbox options, preselect the selected item */
	build_category_tree($category_options, $frm["parent"]);

	include("templates/category_form.ihtml");
}

function delete_category($id) {
/* delete the category specified by $id, and move all the products under
 * that category to the immediate parent.  this should be wrapped inside a
 * transaction, unfortunately MySQL currently does not support transactions. */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	$qid = db_begin();

	/* find the parent of this category */
	$qid = db_query("
	SELECT cat.name, cat.parent_id, parent.name AS parent
	FROM categories cat, categories parent
	WHERE parent.id = cat.parent_id
		AND cat.id = '$id'
	");
	$cat = db_fetch_object($qid, 0);

	/* delete this category */
	$qid = db_query("
	DELETE FROM categories
	WHERE id = '$id'
	");

	// delete products in this category that also belong
	// to the parent category, to avoid duplicates forbidden
	// by the primary key constraint
/* Nested queries aren't still supported by MySQL :(
 *	$qid = db_query("
 *		DELETE FROM products_categories WHERE ( product_id,category_id ) IN (
 *			SELECT * FROM products_categories pc WHERE category_id = '$id' AND
 *			EXISTS (
 *				SELECT * FROM products_categories
 *				WHERE product_id = pc.product_id
 *					AND category_id = '$cat->parent_id'
 *			)
 *		)
 *	");
 * a workaround in the following */
	$qid = db_query("
		SELECT pc1.product_id
		FROM products_categories pc1 , products_categories pc2
		WHERE
			pc1.product_id = pc2.product_id
			AND pc1.category_id = '$cat->parent_id'
			AND pc2.category_id = '$id'
	");
	$numr = db_num_rows($qid);
	$toberemoved = "";
	for ($i=0; $i<$numr-1; $i++) {
		$appoggio = db_fetch_object($qid, $i);
		$toberemoved .= "'" . $appoggio->product_id . "', ";
	}
	$appoggio = db_fetch_object($qid, $numr-1);
	$toberemoved .= "'" . $appoggio->product_id . "'";
	$qid = db_query("
		DELETE FROM products_categories
		WHERE category_id = '$id' AND product_id IN ($toberemoved)
	");

	/* re-assign all the products in this category to the parent category */
	$qid = db_query("
	UPDATE products_categories
	SET category_id = $cat->parent_id
	WHERE category_id = '$id'
	");

	/* re-assign all sub categories of this category to the parent category */
	$qid = db_query("
	UPDATE categories
	SET parent_id = $cat->parent_id
	WHERE parent_id = '$id'
	");

	$qid = db_commit();

	include("templates/category_deleted.ihtml");
}

function insert_subcategory($id, $frm) {
/* add a new subcategory under the parent $id.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = db_query("
	INSERT INTO categories (parent_id, name, on_special, description)
	VALUES ('$frm[parent]', '$frm[name]', '$frm[on_special]', '$frm[description]')
	");

	include("templates/category_added.ihtml");
}

function update_category($id, $frm) {
/* update the category $id with new values.  all the fields that we want are
 * going to in the variable $frm */

	global $CFG, $ME;
	global $SESSION;
	include ($CFG->global);

	while (list($key, $val) = each($frm)){
		if (is_string($val)) $frm[$key] = addslashes($val);
	}
	$qid = db_query("
	UPDATE categories SET
		 parent_id = '$frm[parent]'
		,name = '$frm[name]'
		,on_special = '$frm[on_special]'
		,description = '$frm[description]'
	WHERE id = '$id'
	");
}

function print_category_list() {
/* read all the categories from the database and print them into a table.  we
 * will use a template to display the listings to keep this main script clean */

	global $CFG, $ME;
	global $SESSION;
	global $page_number, $dbchanged;
	include ($CFG->global);

	if (!isset($page_number) || $dbchanged) {
		$qid = db_query("
		SELECT cat.id, cat.name, cat.on_special, cat.description, parent.name AS parent
		FROM categories cat, categories parent
		WHERE parent.id = cat.parent_id AND cat.id > 1 ORDER BY cat.name
		");

		$SESSION["numr"] = db_num_rows($qid);
		for ($i=0; $i<$SESSION["numr"]; $i++) {
			$SESSION["categories"][$i] = db_fetch_array($qid, $i);
		}
		if (!isset($page_number)) {
			$page_number = 1;
		}
	}

	if ($SESSION["numr"] > $SESSION["categories_per_page"]) {
		$first = ($page_number-1)*$SESSION["categories_per_page"];
		$last = $SESSION["numr"] < $page_number*$SESSION["categories_per_page"] ? $SESSION["numr"]-1 : $page_number*$SESSION["categories_per_page"]-1;
		$num_pages = $SESSION["numr"] / $SESSION["categories_per_page"];
		if (!($num_pages == (integer) $num_pages)) {
			$num_pages = (integer) $num_pages + 1;
		}
	} else {
		$first = 0;
		$last = $SESSION["numr"] - 1;
	}

	include("templates/category_list.ihtml");
}

function print_import_category_form() {
/* print the import category form so we can add/update categories from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);

	/* set values for the form */
	$frm["submit_caption"] = $Import_Button_Label;
	$frm["newmode"] = "update_imp";

	include("templates/data_import.ihtml");
}

function import_category($userfile) {
/* Import categories from a text file */
	global $CFG, $ME, $SESSION;
	include ($CFG->global);
	$errors = new Object;

//	/* Let's open a transaction */
	$qid = db_begin();

	$fcontents = file ($userfile);
	/* Traverse the file */
	while (list ($line_num, $line) = each ($fcontents)) {
		// Microsoft Stupidity Suppression
		$line = ereg_replace(chr(13), "", $line);
//		$fldarr = split("\",\"",ereg_replace("^\"|\"..$|\".$","",$line));
		$fldarr = split("\t",ereg_replace("\n$","",$line));
		/* Empty parent = "Top" */
		if (strlen(trim($fldarr[0])) == 0)
			$fldarr[0] = "Top";

		/* Stripping dangerous characters from fields */
		$fldarr[0] = ereg_replace("\'","",$fldarr[0]);
//echo $fldarr[0] . "<BR>";

		/* Let's see if the parent category exists ... */
		$qid = db_query("
		SELECT id FROM categories WHERE name = '$fldarr[0]'
		");
		if (db_num_rows($qid) == 0) {
			/* ... if it doesn't exist let's return an error ... */
			echo $line_num . $Err_ImpCat . $fldarr[0] . "'.<br>";
		} else {
			/* ... otherwise let's save its ID ... */
			$arr = db_fetch_array($qid,0);
			$pid = $arr[0];

			/* Stripping dangerous characters from fields */
//			$fldarr[1] = ereg_replace("\'","",$fldarr[1]);
			$fldarr[1] = ereg_replace("\"","\\\"",$fldarr[1]);
			$fldarr[1] = ereg_replace("'","\'",$fldarr[1]);

//			$fldarr[3] = ereg_replace("\'","",$fldarr[3]);
			$fldarr[3] = ereg_replace("'","\'",$fldarr[3]);
			$fldarr[3] = ereg_replace("\"","\\\"",$fldarr[3]);

			/* ... and let's see if the category already exists ... */
			$qid = db_query("
			SELECT id FROM categories WHERE name = '$fldarr[1]'
			");
			if (db_num_rows($qid) == 0) {
				/* ... if it doesn't exist let's create it ... */
				$qid = db_query("
				INSERT INTO categories (parent_id, name, on_special, description)
				VALUES ('$pid', '$fldarr[1]', '$fldarr[2]', '$fldarr[3]')
				");
			} else {
				/* ... otherwise let's save its ID ... */
				$arr = db_fetch_array($qid,0);
				$sid = $arr[0];
				/* ... and update ... */
				$qid = db_query("
				UPDATE categories SET
	 				parent_id = '$pid'
					,name = '$fldarr[1]'
					,on_special = '$fldarr[2]'
					,description = '$fldarr[3]'
				WHERE id = '$sid'
				");
			}
		}
	}

	/* Let's close the transaction */
	$qid = db_commit();
	
	/* The End */
	include("templates/data_import_end.ihtml");

}

?>
