#!/usr/bin/perl -w

use strict;

use Switch;
use Env qw(HOME PATH PGDATA);
use Term::Screen;

use Fcntl;
use Proc::ProcessTable;
use Term::ReadLine;
use PGProcess;

use Dumpvalue;
my $dumper = new Dumpvalue;

use Getopt::Std;
my %Options;

getopt('',\%Options);

my $mode = ($Options{'m'})?1:0 ;
my $printHead = ($Options{'n'})?0:1;
my $printKeys = ($Options{'k'})?0:1;
my $refresh = 5;

if($Options{'h'}){
	print "PostgreSQL perl monitor. 
Based on Tcl/Tk version of pgmonitor.

Possible options:
-b	Batch mode, prints actual status and then quit
-h	This help
-m	Run in query mode
-n	No heading, do not print heading
-k	No keys, do not print available keys
-w	Web, print output as HTML table.

";
	exit 0;
}

my $process = PGProcess->new($ARGV[0]);

if($Options{'w'}){
	$process->updateProcess;
	print $process->printHtml($printHead,$mode,"border=1 cellspacing=3 cellpadding=3");
	exit 0;
}

if($Options{'b'}){
	$process->updateProcess;
	print $process->printLines($printHead,$mode);
	exit 0;
}

my $scr = new Term::Screen;
my $term = new Term::ReadLine;


sub printHeader{
	my ($head,$refresh,$mode) = @_;
	if($printKeys){
		$scr->normal->puts("Available keys:\r\n");
		$scr->bold->puts("H")->normal->puts("elp ");
		$scr->bold->puts("K")->normal->puts("ill ");
		$scr->bold->puts("S")->normal->puts("how query ");
		$scr->bold->puts("R")->normal->puts("efresh time(".$refresh.") ");
		$scr->bold->puts("M")->normal->puts("ode(".(($mode==1)?"query":"single").") ");
		$scr->bold->puts("O")->normal->puts("rder ");
		$scr->bold->puts("Q")->normal->puts("uit ");

		$scr->normal->puts("\r\n\r\n");
	}

	if($printHead){
		chomp($head);
		$scr->normal->puts($head)->puts("\r\n");
	}

}

sub printProcess{
	my ($ptable,$mode) = @_;

	foreach (@$ptable){
		$scr->normal->puts(sprintf("%5.5s %-8.8s %-4.4s%2.2s %-4.4s%9.9s %-10.10s %-10.10s %-14s %-s",$_->{pid},$_->{start},$_->{mem},$_->{status},$_->{cpu},$_->{'time'},$_->{user},$_->{database},$_->{connection},$_->{query}))->puts("\r\n");

		if(($mode == 1) and (!($_->{query} =~ /idle/i)) ){
			$scr->puts($process->fetchQuery($_->{pid}))->puts("\r\n");
		}
	}
	$scr->at(2,0);
}


sub help{
	$scr->clrscr;
	my $helpMessg =<<EOF
q\tQuit program
s\tSet refresh timeout
h\tThis screen
k\tTerminate connection
m\tSwitch between two lines (one with process info, second with query) and single mode
o\tOrder by, first selection sorting ascedenting, second one descedenting
r\tSet refresh
EOF
;
	my @helpArr = split("\n",$helpMessg);
	foreach my $line (@helpArr ){
		my @val = split("\t",$line);
		$scr->bold()->puts($val[0])->normal()->puts("\t")->puts($val[1])->puts("\r\n");
	}
	$scr->reverse()->puts("\r\n\nPress any key to continue...")->normal();
	$scr->getch;
	$scr->flush_input();
	$scr->clrscr;

}

sub getPid{
	my $new;
	$scr->at(2,0)->normal->clreol;
	$new = $term->readline("Enter PID: ");
	if($new =~ /^-?\d/){return $new+0;}else{return -1;}
}

sub getOrder{
	my ($process) = @_;
	my $strF;
	$scr->clrscr;
	my $menu = <<EOF
1\tPID
2\tStart
3\tMem
4\tStatus
5\tCPU
6\tTime
7\tUser
8\tDatabase
9\tConnection
10\tQuery
EOF
;
	my @menuArr = split("\n",$menu);
	foreach my $line (@menuArr){
		my @val = split("\t",$line);
		$scr->bold()->puts($val[0])->normal()->puts("\t")->puts($val[1])->puts("\r\n");
	}

	$scr->puts("\r\n");
	
	my $new = $term->readline("Enter choice: ");

	my $oldSort = $process->{_sortBy};
	switch($new){
		case "1" {$process->{_sortBy} = "pid";}
		case "2" {$process->{_sortBy} = "start";}
		case "3" {$process->{_sortBy} = "mem";}
		case "4" {$process->{_sortBy} = "status";}
		case "5" {$process->{_sortBy} = "cpu";}
		case "6" {$process->{_sortBy} = "time";}
		case "7" {$process->{_sortBy} = "user";}
		case "8" {$process->{_sortBy} = "database";}
		case "9" {$process->{_sortBy} = "connection";}
		case "10" {$process->{_sortBy} = "query";}
	}

	if($process->{_sortBy} eq $oldSort and ($process->{_desc} eq "")){
		$process->{_desc} = "r";
	}else{
		$process->{_desc} = "";
	}

	$scr->flush_input();
	$scr->clrscr;

}

my $first = "0";
$scr->flush_input();
do{
	my $tmp = 0;
		switch($first){
			case "h" {
				$tmp = $refresh;
    help;
			}
			case "r" {
				my $new;
				$scr->at(2,0)->normal();
				$tmp = $new = $term->readline("Enter new refresh: ");
				if (($new+0) > 0){$refresh = $new; }else{ $refresh = 5;}
			}
			case "k"{
				my $msg;
				$tmp = $refresh;
				$msg = $process->sendSignal(getPid,15);
				if($msg){ 
					$scr->puts($msg. " (Press any key)");
					$scr->getch;
				}
			}
			case "s"{
				my $msg;
				$tmp = $refresh;
				$scr->clrscr;
				$scr->puts($process->fetchQuery(getPid));
				$scr->reverse()->puts("\r\n\nPress any key to continue...")->normal()->getch;
				$scr->flush_input();
			}
			case "o"{
				my $msg;
				$tmp = $refresh;
				getOrder($process);
			}
			case "m"{
				$mode = ($mode == 1)?0:1;
			}
		}
				$scr->clrscr;
   			printHeader($process->{_psHeading},$refresh,$mode);
				printProcess($process->updateProcess,$mode);
	$first = "";
	$first = $scr->getch() if $scr->key_pressed($refresh-$tmp);
	
}until($first eq "q" );


$scr->clrscr;
