/*-------------------------------------------------------------------------
 *
 * FILE
 *    uuid_generate_nil.c
 *
 * DESCRIPTION
 *    get generating time from uuid
 *
 * Copyright (c) 2002-2003, Mike Wang <xylophone2001@hotmail.com>
 *
 *-------------------------------------------------------------------------
 */
#include <uuid.h>

#include <time.h>
#include <sys/time.h>
#include <sys/types.h>

int uuid_time(const uuid_p p, struct timeval *ret_tv)
{
	uuid_u32_t high;

	uuid_u64_t clock_reg;

	if (uuid_type(p) != UUID_TYPE_TIME_BASE)
	{
		return (-1);
	}
	
	high = p->time_mid | ((p->time_hi_and_version & 0xFFF) << 16);
	clock_reg = p->time_low | ((uuid_u64_t) high << 32);

	clock_reg -= (((uuid_u64_t) 0x01B21DD2) << 32) + 0x13814000;

	if (ret_tv != 0)
	{
		(*ret_tv).tv_sec = clock_reg / 10000000;
		(*ret_tv).tv_usec = (clock_reg % 10000000) / 10;
	}

	return (0);
}
