<?php
/* $Id: trig_properties.php,v 1.1 2000/11/23 16:34:51 dwilson Exp $ */

if (!isset($message)) {
	include("header.inc.php");
} else {
	show_message($message);
}

$sql_trigger_props = "
	SELECT 
		pt.*, pp.proname, pc.relname, py.typname
	FROM 
		pg_trigger pt, pg_proc pp, pg_class pc, pg_type py
	WHERE 
		pp.oid=pt.tgfoid
		and pt.tgtype=py.oid
		and pt.tgrelid=pc.oid
		and tgname = '$trigger'
";

if (!$res_props = pg_exec($link, pre_query($sql_trigger_props))) {
	pg_die();
} else {
	$row = @pg_fetch_array($res_props, 0);

	// Construct function definition
	$query = "?db=$db&rel_type=function&function=" . urlencode($row[proname]);
	$fn = "<a href=\"func_properties.php$query\">" . $row[proname] . "</a>";

	// Strip off trailing delimiter
	$tgargs = trim(substr($row[tgargs], 0, strlen($row[tgargs]) - 4));
	$params = explode('\000', $tgargs);

	for ($i = 0; $i < sizeof($params); $i++) {
		$params[$i] = str_replace("'", "\\'", $params[$i]);
	}
	$defn =  implode("', '", $params);

	?>
	<table border=<?php echo $cfgBorder;?>>
	<TR>
	<TH><?php echo $strTrigger; ?></TH>
	<TH><?php echo $strRetType; ?></TH>
	<TH><?php echo $strEnabled; ?></TH>
	<TH><?php echo $strIsConstraint; ?></TH>
	<TH><?php echo $strConstraintName; ?></TH>
	<TH><?php echo $strDeferrable; ?></TH>
	<TH><?php echo $strInitDeferred; ?></TH>

	</TR>

	<tr bgcolor="<?php echo $cfgBgcolorOne;?>">
	<td class=data><b><?php echo $row[tgname];?></b></td>
	<td><?php echo $row[typname]; ?></td>
	<td><?php echo ($row[tgenabled] == 't') ? 'Y' : 'N'; ?></td>
	<td><?php echo ($row[tgisconstraint] == 't') ? 'Y' : 'N'; ?></td>
	<td><?php echo $row[tgconstrname]; ?></td>
	<td><?php echo ($row[tgdeferrable] == 't') ? 'Y' : 'N'; ?></td>
	<td><?php echo ($row[tginitdeferred] == 't') ? 'Y' : 'N'; ?></td>
	<tr><th colspan=7><?php echo $strFunc;?></th></tr>
	<tr>
		<td colspan=7 bgcolor="<?php echo $cfgBgcolorTwo; ?>"><?php echo $fn, " ('", htmlspecialchars($defn), "')"; ?></td>
	</tr>
	<?php
	echo "</table>";
}

include ("footer.inc.php");
?>

