<?php // $Id: campaignhistory.plugin.php,v 1.2 2001/07/09 16:43:06 ciaccia Exp $ - #phpAdsNew Revision: 1.1 #

/************************************************************************/
/* phpPgAds - Campaign Overview Plugin 1.0                              */
/* =======================================                              */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/


// Public name of the plugin info function
$plugin_info_function		= "Plugin_CampaignhistoryInfo";


// Public info function
function Plugin_CampaignhistoryInfo()
{
	$plugininfo = array (
		"plugin-name"			=> "Campaign History",
		"plugin-description"	=> "Generate an overview of the history of the selected campaign.
									The report is exported as CSV for use in a spreadsheet.",
		"plugin-author"			=> "Niels Leenheer",
		"plugin-export"			=> "csv",
		"plugin-authorize"		=> phpAds_Admin+phpAds_Client,
		"plugin-execute"		=> "Plugin_CampaignhistoryExecute",
		"plugin-import"			=> array (
			"campaignid"			=> array (
				"title"					=> "Campaign",
				"type"					=> "campaignid-dropdown" ),
			"delimiter"		=> array (
				"title"					=> "Delimiter",
				"type"					=> "edit",
				"size"					=> 1,
				"default"				=> "," ) )
	);
	
	return ($plugininfo);
}



/*********************************************************/
/* Private plugin function                               */
/*********************************************************/

function Plugin_CampaignhistoryExecute($campaignid, $delimiter=",")
{
	global $phpAds_tbl_banners, $phpAds_tbl_adstats, $phpAds_tbl_adviews, $phpAds_tbl_adclicks;
	global $phpAds_compact_stats;
	
	header ("Content-type: application/csv\nContent-Disposition: \"attachment; filename=campaignhistory.csv\"");
	
	if ($phpAds_compact_stats)
	{
		$res_query = "
			SELECT
				$phpAds_tbl_adstats.day as day,
				sum($phpAds_tbl_adstats.views) as adviews,
				sum($phpAds_tbl_adstats.clicks) as adclicks
			FROM
				$phpAds_tbl_banners,
				$phpAds_tbl_adstats
			WHERE
				$phpAds_tbl_banners.clientid = $campaignid
				AND $phpAds_tbl_banners.bannerid = $phpAds_tbl_adstats.bannerid
			GROUP BY
				$phpAds_tbl_adstats.day
			UNION
			SELECT
				NULL as day,
				0::int4 as adviews,
				0::int4 as adclicks
			FROM
				$phpAds_tbl_banners
			WHERE
				$phpAds_tbl_banners.clientid = $campaignid
				AND $phpAds_tbl_banners.bannerid NOT IN (SELECT bannerid FROM $phpAds_tbl_adstats)
			";
		
		$res_banners = db_query($res_query) or pg_die();
		
		for ($pgc = 0; $row_banners = @pg_fetch_array($res_banners, $pgc); $pgc++)
		{
			$stats [$row_banners['day']]['views'] = $row_banners['adviews'];
			$stats [$row_banners['day']]['clicks'] = $row_banners['adclicks'];
		}
	}
	else
	{
		$res_query = "
			SELECT
				$phpAds_tbl_adviews.t_stamp::date as day,
				count($phpAds_tbl_adviews.bannerid) as adviews
			FROM
				$phpAds_tbl_banners,
				$phpAds_tbl_adviews
			WHERE
				$phpAds_tbl_banners.clientid = $campaignid
				AND $phpAds_tbl_banners.bannerid = $phpAds_tbl_adviews.bannerid
			GROUP BY
				day
			UNION
			SELECT
				NULL as day,
				0::int4 as adviews
			FROM
				$phpAds_tbl_banners
			WHERE
				$phpAds_tbl_banners.clientid = $campaignid
				AND $phpAds_tbl_banners.bannerid NOT IN (SELECT bannerid FROM $phpAds_tbl_adviews)
			";
		
		$res_banners = db_query($res_query) or pg_die();
		
		for ($pgc = 0; $row_banners = @pg_fetch_array($res_banners, $pgc); $pgc++)
		{
			$stats [$row_banners['day']]['views'] = $row_banners['adviews'];
			$stats [$row_banners['day']]['clicks'] = 0;
		}
		
		$res_query = "
			SELECT
				$phpAds_tbl_adclicks.t_stamp::date as day,
				count($phpAds_tbl_adclicks.bannerid) as adclicks
			FROM
				$phpAds_tbl_banners,
				$phpAds_tbl_adclicks
			WHERE
				$phpAds_tbl_banners.clientid = $campaignid
				AND $phpAds_tbl_banners.bannerid = $phpAds_tbl_adclicks.bannerid
			GROUP BY
				day
			UNION
			SELECT
				NULL as day,
				0::int4 as adclicks
			FROM
				$phpAds_tbl_banners
			WHERE
				$phpAds_tbl_banners.clientid = $campaignid
				AND $phpAds_tbl_banners.bannerid NOT IN (SELECT bannerid FROM $phpAds_tbl_adclicks)
			";
		
		$res_banners = db_query($res_query) or pg_die();
		
		for ($pgc = 0; $row_banners = @pg_fetch_array($res_banners, $pgc); $pgc++)
		{
			$stats [$row_banners['day']]['clicks'] = $row_banners['adclicks'];
		}
	}
	
	echo "Campaign: ".phpAds_getClientName ($campaignid)."\n\n";
	echo "Day".$delimiter."AdViews".$delimiter."AdClicks".$delimiter."CTR\n";
	
	$totalclicks = 0;
	$totalviews = 0;
	
	if (isset($stats) && is_array($stats))
	{
		for (reset($stats);$key=key($stats);next($stats))
		{
			$row = array();
			
			$row[] = $key;
			$row[] = $stats[$key]['views'];
			$row[] = $stats[$key]['clicks'];
			$row[] = phpAds_buildCTR ($stats[$key]['views'], $stats[$key]['clicks']);
			
			echo implode ($delimiter, $row)."\n";
			
			$totalclicks += $stats[$key]['clicks'];
			$totalviews += $stats[$key]['views'];
		}
	}
	
	echo "\n";
	echo "Total".$delimiter.$totalviews.$delimiter.$totalclicks.$delimiter.phpAds_buildCTR ($totalviews, $totalclicks)."\n";
}

?>