<?php // $Id: stats-index.php,v 1.3 2001/07/14 09:07:27 ciaccia Exp $ - #phpAdsNew Revision: 1.10 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/



// Include required files
require ("config.php");
require ("lib-statistics.inc.php");


// Security check
phpAds_checkAccess(phpAds_Admin+phpAds_Client);



/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

if (phpAds_isUser(phpAds_Admin))
{
	$extra = '';

	if ($phpAds_compact_stats)
	{
		// Determine left over verbose stats
		$viewresult = db_query("SELECT COUNT(*) AS cnt FROM $phpAds_tbl_adviews");
		$viewrow = @pg_fetch_array($viewresult, 0);
		if (isset($viewrow["cnt"]) && $viewrow["cnt"] != '')
			$verboseviews = $viewrow["cnt"];
		else
			$verboseviews = 0;
		
		$clickresult = db_query("SELECT COUNT(*) AS cnt FROM $phpAds_tbl_adclicks");
		$clickrow = @pg_fetch_array($viewresult, 0);
		if (isset($clickrow["cnt"]) && $clickrow["cnt"] != '')
			$verboseclicks = $clickrow["cnt"];
		else
			$verboseclicks = 0;
		
		if ($verboseviews > 0 || $verboseclicks > 0)
		{
			// Show link to verbose stats convertor
			$extra = "<br><br>
					  <table cellspacing='1' cellpadding='0' width='140' bgcolor='#000088'><tr><td>
					  <table cellspacing='4' bgcolor='#FFFFFF'><tr>
					  <td valign='top'><img src='images/info.gif' vspace='absmiddle'></td>
					  <td valign='top'><b>Alert:</b><br>
					  You have enabled the compact statistics, but your old statistics are still 
					  in verbose format. Do you want to convert your verbose statistics to the 
					  new compact format?<br><br>
					  <a href='stats-convert.php?command=frame' target='_new' onClick=\"return openWindow('stats-convert.php?command=frame','','status=yes,scrollbars=yes,resizable=yes,width=400,height=500');\">
					  <img src='images/go_blue.gif' border='0'>&nbsp;Convert</a>
					  </td>
					  </tr></table>
					  </td></tr></table>";
		}
	}
	
	phpAds_PageHeader("2", $extra);
}

if (phpAds_isUser(phpAds_Client))
{
	phpAds_PageHeader("1");
}

if (isset($message))
{
	phpAds_ShowMessage($message);
}



/*********************************************************/
/* Main code                                             */
/*********************************************************/

// Get clients & campaign and build the tree
if (phpAds_isUser(phpAds_Admin))
{
	$res_clients = db_query("
		SELECT 
			*
		FROM 
			$phpAds_tbl_clients
		ORDER BY
			parent, clientid
		") or pg_die();
}
else
{
	$res_clients = db_query("
		SELECT 
			*
		FROM 
			$phpAds_tbl_clients
		WHERE
			clientid = ".$Session["clientid"]." OR
			parent = ".$Session["clientid"]."
		ORDER BY
			parent, clientid
		") or pg_die();
}

for ($pgc = 0; $row_clients = @pg_fetch_array($res_clients, $pgc); $pgc++)
{
	if ($row_clients['parent'] == 0)
	{
		$clients[$row_clients['clientid']] = $row_clients;
		$clients[$row_clients['clientid']]['expand'] = 0;
	}
	else
	{
		$campaigns[$row_clients['clientid']] = $row_clients;
		$campaigns[$row_clients['clientid']]['expand'] = 0;
	}
}


// Get the banners for each campaign
$res_banners = db_query("
	SELECT 
		bannerid,
		clientid,
		alt,
		description,
		format,
		active
	FROM 
		$phpAds_tbl_banners
	") or pg_die();

for ($pgc = 0; $row_banners = @pg_fetch_array($res_banners, $pgc); $pgc++)
{
	if (isset($campaigns[$row_banners['clientid']]))
	{
		$banners[$row_banners['bannerid']] = $row_banners;
		$banners[$row_banners['bannerid']]['clicks'] = 0;
		$banners[$row_banners['bannerid']]['views'] = 0;
	}
}



// Get the adviews/clicks for each banner
if ($phpAds_compact_stats == 1)
{
	$res_stats = db_query("
		SELECT
			s.bannerid as bannerid,
			b.clientid as clientid, 
			sum(s.views) as views,
			sum(s.clicks) as clicks		
		FROM 
			$phpAds_tbl_adstats as s, 
			$phpAds_tbl_banners as b
		WHERE
			b.bannerid = s.bannerid
		GROUP BY
			s.bannerid,
			b.clientid
		") or pg_die();
	
	for ($pgc = 0; $row_stats = @pg_fetch_array($res_stats, $pgc); $pgc++)
	{
		if (isset($banners[$row_stats['bannerid']]))
		{
			$banners[$row_stats['bannerid']]['clicks'] = $row_stats['clicks'];
			$banners[$row_stats['bannerid']]['views'] = $row_stats['views'];
		}
	}
}
else
{
	$res_stats = db_query("
		SELECT
			v.bannerid as bannerid,
			b.clientid as clientid, 
			count(v.bannerid) as views
		FROM 
			$phpAds_tbl_adviews as v,
			$phpAds_tbl_banners as b
		WHERE
			b.bannerid = v.bannerid
		GROUP BY
			v.bannerid, b.clientid
		") or pg_die();
	
	for ($pgc = 0; $row_stats = @pg_fetch_array($res_stats, $pgc); $pgc++)
	{
		if (isset($banners[$row_stats['bannerid']]))
		{
			$banners[$row_stats['bannerid']]['views'] = $row_stats['views'];
			$banners[$row_stats['bannerid']]['clicks'] = 0;
		}
	}
	
	
	$res_stats = db_query("
		SELECT
			c.bannerid as bannerid,
			b.clientid as clientid, 
			count(c.bannerid) as clicks
		FROM 
			$phpAds_tbl_adclicks as c,
			$phpAds_tbl_banners as b
		WHERE
			b.bannerid = c.bannerid
		GROUP BY
			c.bannerid, b.clientid
		") or pg_die();
	
	for ($pgc = 0; $row_stats = @pg_fetch_array($res_stats, $pgc); $pgc++)
	{
		if (isset($banners[$row_stats['bannerid']]))
		{
			$banners[$row_stats['bannerid']]['clicks'] = $row_stats['clicks'];
		}
	}
}




// Expand tree nodes

if (isset($Session["stats_nodes"]) && $Session["stats_nodes"])
	$node_array = explode (",", $Session["stats_nodes"]);
else
	$node_array = array();

// Add ID found in expand to expanded nodes
if (isset($expand) && $expand != '')
	$node_array[] = $expand;

for ($i=0; $i < sizeof($node_array);$i++)
{
	if (isset($collapse) && $collapse == $node_array[$i])
		unset ($node_array[$i]);
	else
	{
		if (isset($clients[$node_array[$i]]))
			$clients[$node_array[$i]]['expand'] = 1;
		if (isset($campaigns[$node_array[$i]]))
			$campaigns[$node_array[$i]]['expand'] = 1;
	}
}

$Session["stats_nodes"] = implode (",", $node_array);
phpAds_SessionDataStore();




// Build Tree
if (isset($banners) && is_array($banners) && count($banners) > 0)
{
	// Add banner to campaigns
	for (reset($banners);$bkey=key($banners);next($banners))
		$campaigns[$banners[$bkey]['clientid']]['banners'][$bkey] = $banners[$bkey];
	
	unset ($banners);
}

if (isset($campaigns) && is_array($campaigns) && count($campaigns) > 0)
{
	for (reset($campaigns);$ckey=key($campaigns);next($campaigns))
		$clients[$campaigns[$ckey]['parent']]['campaigns'][$ckey] = $campaigns[$ckey];
	
	unset ($campaigns);
}



if (isset($clients) && is_array($clients) && count($clients) > 0)
{
	// Calculate statistics for clients
	for (reset($clients);$key=key($clients);next($clients))
	{
		$clientviews = 0;
		$clientclicks = 0;
		
		if (isset($clients[$key]['campaigns']) && sizeof ($clients[$key]['campaigns']) > 0)
		{
			$campaigns = $clients[$key]['campaigns'];
			
			// Calculate statistics for campaigns
			for (reset($campaigns);$ckey=key($campaigns);next($campaigns))
			{
				$campaignviews = 0;
				$campaignclicks = 0;
				
				if (isset($campaigns[$ckey]['banners']) && sizeof ($campaigns[$ckey]['banners']) > 0)
				{
					$banners = $campaigns[$ckey]['banners'];
					for (reset($banners);$bkey=key($banners);next($banners))
					{
						$campaignviews += $banners[$bkey]['views'];
						$campaignclicks += $banners[$bkey]['clicks'];
					}
				}
				
				$clientviews += $campaignviews;
				$clientclicks += $campaignclicks;
				
				$clients[$key]['campaigns'][$ckey]['views'] = $campaignviews;
				$clients[$key]['campaigns'][$ckey]['clicks'] = $campaignclicks;
			}
		}
		
		$clients[$key]['clicks'] = $clientclicks;
		$clients[$key]['views'] = $clientviews;
	}
	
	unset ($campaigns);
	unset ($banners);
}








if (isset($clients) && is_array($clients) && count($clients) > 0)
{
	echo "<table border='0' width='100%' cellpadding='0' cellspacing='0'>";	
	
	echo "<tr height='25'>";
	echo "<td height='25'><b>&nbsp;&nbsp;".$GLOBALS['strName']."</b></td>";
	echo "<td height='25'><b>".$GLOBALS['strID']."</b>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>";
	echo "<td height='25' align='right'><b>".$GLOBALS['strViews']."</b></td>";
	echo "<td height='25' align='right'><b>".$GLOBALS['strClicks']."</b></td>";
	echo "<td height='25' align='right'><b>".$GLOBALS['strCTRShort']."</b>&nbsp;&nbsp;</td>";
	echo "</tr>";
	
	echo "<tr height='1'><td colspan='5' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>";
	
	$i=0;
	for (reset($clients);$key=key($clients);next($clients))
	{
		$client = $clients[$key];
		
		echo "<tr height='25' ".($i%2==0?"bgcolor='#F6F6F6'":"").">";
		
		// Icon & name
		echo "<td height='25'>";
		if (isset($client['campaigns']))
		{
			if ($client['expand'] == '1')
				echo "&nbsp;<a href='stats-index.php?collapse=".$client['clientid']."'><img src='images/triangle-d.gif' align='absmiddle' border='0'></a>&nbsp;";
			else
				echo "&nbsp;<a href='stats-index.php?expand=".$client['clientid']."'><img src='images/triangle-l.gif' align='absmiddle' border='0'></a>&nbsp;";
		}
		else
			echo "&nbsp;<img src='images/spacer.gif' height='16' width='16'>&nbsp;";
			
		echo "<img src='images/icon-client.gif' align='absmiddle'>&nbsp;";
		echo "<a href='stats-client.php?clientid=".$client['clientid']."'>".$client['clientname']."</a>";
		echo "</td>";
		
		// ID
		echo "<td height='25'>".$client['clientid']."</td>";
		
		// Button 1
		echo "<td height='25' align='right'>".$client['views']."</td>";
		
		// Empty
		echo "<td height='25' align='right'>".$client['clicks']."</td>";
		
		// Button 3
		echo "<td height='25' align='right'>".phpAds_buildCTR($client['views'], $client['clicks'])."&nbsp;&nbsp;</td>";
		
		
		
		if (isset($client['campaigns']) && sizeof ($client['campaigns']) > 0 && $client['expand'] == '1')
		{
			$campaigns = $client['campaigns'];
			
			for (reset($campaigns);$ckey=key($campaigns);next($campaigns))
			{
				// Divider
				echo "<tr height='1'>";
				echo "<td ".($i%2==0?"bgcolor='#F6F6F6'":"")."><img src='images/spacer.gif' width='1' height='1'></td>";
				echo "<td colspan='5' bgcolor='#888888'><img src='images/break-l.gif' height='1' width='100%'></td>";
				echo "</tr>";
				
				// Icon & name
				echo "<tr height='25' ".($i%2==0?"bgcolor='#F6F6F6'":"")."><td height='25'>";
				echo "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
				
				if (isset($campaigns[$ckey]['banners']))
				{
					if ($campaigns[$ckey]['expand'] == '1')
						echo "<a href='stats-index.php?collapse=".$campaigns[$ckey]['clientid']."'><img src='images/triangle-d.gif' align='absmiddle' border='0'></a>&nbsp;";
					else
						echo "<a href='stats-index.php?expand=".$campaigns[$ckey]['clientid']."'><img src='images/triangle-l.gif' align='absmiddle' border='0'></a>&nbsp;";
				}
				else
					echo "<img src='images/spacer.gif' height='16' width='16'>&nbsp;";
				
				
				if ($campaigns[$ckey]['active'] == 't')
					echo "<img src='images/icon-campaign.gif' align='absmiddle'>&nbsp;";
				else
					echo "<img src='images/icon-campaign-d.gif' align='absmiddle'>&nbsp;";
				
				echo "<a href='stats-campaign.php?campaignid=".$campaigns[$ckey]['clientid']."'>".$campaigns[$ckey]['clientname']."</td>";
				echo "</td>";
				
				// ID
				echo "<td height='25'>".$campaigns[$ckey]['clientid']."</td>";
				
				// Button 1
				echo "<td height='25' align='right'>".$campaigns[$ckey]['views']."</td>";
				
				// Button 2
				echo "<td height='25' align='right'>".$campaigns[$ckey]['clicks']."</td>";
				
				// Button 3
				echo "<td height='25' align='right'>".phpAds_buildCTR($campaigns[$ckey]['views'], $campaigns[$ckey]['clicks'])."&nbsp;&nbsp;</td>";
				
				
				
				if ($campaigns[$ckey]['expand'] == '1' && isset($campaigns[$ckey]['banners']))
				{
					$banners = $campaigns[$ckey]['banners'];
					for (reset($banners);$bkey=key($banners);next($banners))
					{
						$name = $strUntitled;
						if (isset($banners[$bkey]['alt']) && $banners[$bkey]['alt'] != '') $name = $banners[$bkey]['alt'];
						if (isset($banners[$bkey]['description']) && $banners[$bkey]['description'] != '') $name = $banners[$bkey]['description'];
						
						$name = phpAds_breakString ($name, '30');
						
						// Divider
						echo "<tr height='1'>";
						echo "<td ".($i%2==0?"bgcolor='#F6F6F6'":"")."><img src='images/spacer.gif' width='1' height='1'></td>";
						echo "<td colspan='4' bgcolor='#888888'><img src='images/break-l.gif' height='1' width='100%'></td>";
						echo "</tr>";
						
						// Icon & name
						echo "<tr height='25' ".($i%2==0?"bgcolor='#F6F6F6'":"").">";
						echo "<td height='25'>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
						
						if ($banners[$bkey]['active'] == 't' && $campaigns[$ckey]['active'] == 't')
						{
							if ($banners[$bkey]['format'] == 'html')
							{
								echo "<img src='images/icon-banner-html.gif' align='absmiddle'>";
							}
							elseif ($banners[$bkey]['format'] == 'url')
							{
								echo "<img src='images/icon-banner-url.gif' align='absmiddle'>";
							}
							else
							{
								echo "<img src='images/icon-banner-stored.gif' align='absmiddle'>";
							}
						}
						else
						{
							if ($banners[$bkey]['format'] == 'html')
							{
								echo "<img src='images/icon-banner-html-d.gif' align='absmiddle'>";
							}
							elseif ($banners[$bkey]['format'] == 'url')
							{
								echo "<img src='images/icon-banner-url-d.gif' align='absmiddle'>";
							}
							else
							{
								echo "<img src='images/icon-banner-stored-d.gif' align='absmiddle'>";
							}
						}
						
						echo "&nbsp;<a href='stats-details.php?bannerid=".$banners[$bkey]['bannerid']."&campaignid=".$campaigns[$ckey]['clientid']."'>".$name."</a></td>";
						
						// ID
						echo "<td height='25'>".$banners[$bkey]['bannerid']."</td>";
						
						// Empty
						echo "<td height='25' align='right'>".$banners[$bkey]['views']."</td>";
						
						// Button 2
						echo "<td height='25' align='right'>".$banners[$bkey]['clicks']."</td>";
						
						// Button 1
						echo "<td height='25' align='right'>".phpAds_buildCTR($banners[$bkey]['views'], $banners[$bkey]['clicks'])."&nbsp;&nbsp;</td>";
					}
				}
			}
		}
		
		if (isset ($client['banners']) && sizeof($client['banners']) > 0)
		{
			// Divider
			echo "<tr height='1'><td colspan='1'></td><td colspan='3' bgcolor='#888888'><img src='images/break-l.gif' height='1' width='100%'></td></tr>";
			
			echo "<tr height='25' ".($i%2==0?"bgcolor='#F6F6F6'":"").">";
			echo "<td height='25'>$strBannersWithoutCampaign</td>";
			echo "<td height='25'>&nbsp;-&nbsp;</td>";
			echo "<td>&nbsp;</td>";
			echo "<td>&nbsp;</td>";
			echo "<td>&nbsp;</td>";
			echo "</tr>";
		}
		
		echo "<tr height='1'><td colspan='5' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>";
		$i++;
	}
	
	echo "<tr height='25'><td colspan='4' height='25'>";
	if (phpAds_isUser(phpAds_Admin))
	{
		echo "<img src='images/icon-weekly.gif' align='absmiddle'>&nbsp;<a href='stats-weekly.php?campaignid=0'>$strWeeklyStats</a>&nbsp;&nbsp;&nbsp;&nbsp;";
	}
	echo "</td></tr>";
	echo "</table>";
	
	
	echo "<br><br><br><br>";
}
?>


<?php if (phpAds_isUser(phpAds_Admin)) { ?>

<table width='100%' border="0" align="center" cellspacing="0" cellpadding="0">
  <tr><td height='25' colspan='4'><b><?php echo $strStats;?></b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>

<?php
	// stats today
	$adviews = db_total_views("", "day");
	$adclicks = db_total_clicks("", "day");
	$ctr = phpAds_buildCTR($adviews, $adclicks)
?>

  <tr><td height='25'><?php echo $strToday;?></td>
  	  <td height='25'><?php echo $strViews;?>: <b><?php echo $adviews;?></b></td>
      <td height='25'><?php echo $strClicks;?>: <b><?php echo $adclicks;?></b></td>
      <td height='25'><?php echo $strCTRShort;?>: <b><?php echo $ctr;?></b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break-el.gif' height='1' width='100%'></td></tr>

<?php
	// stats this week
	$adviews = db_total_views("", "week");
	$adclicks = db_total_clicks("", "week");
	$ctr = phpAds_buildCTR($adviews, $adclicks)
?>

  <tr><td height='25'><?php echo $strThisWeek;?></td>
   	  <td height='25'><?php echo $strViews;?>: <b><?php echo $adviews;?></b></td>
      <td height='25'><?php echo $strClicks;?>: <b><?php echo $adclicks;?></b></td>
      <td height='25'><?php echo $strCTRShort;?>: <b><?php echo $ctr;?></b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break-el.gif' height='1' width='100%'></td></tr>

<?php
	// stats this month
	$adviews = db_total_views("", "month");
	$adclicks = db_total_clicks("", "month");
	$ctr = phpAds_buildCTR($adviews, $adclicks)
?>

  <tr><td height='25'><?php echo $strThisMonth;?></td>
  	  <td height='25'><?php echo $strViews;?>: <b><?php echo $adviews;?></b></td>
      <td height='25'><?php echo $strClicks;?>: <b><?php echo $adclicks;?></b></td>
      <td height='25'><?php echo $strCTRShort;?>: <b><?php echo $ctr;?></b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break-el.gif' height='1' width='100%'></td></tr>
  
  
<?php
	// overall stats
	$adviews = db_total_views();
	$adclicks = db_total_clicks();
	$ctr = phpAds_buildCTR($adviews, $adclicks)
?>

  <tr><td height='25'><?php echo $strOverall;?></td>
  	  <td height='25'><?php echo $strViews;?>: <b><?php echo $adviews;?></b></td>
      <td height='25'><?php echo $strClicks;?>: <b><?php echo $adclicks;?></b></td>
      <td height='25'><?php echo $strCTRShort;?>: <b><?php echo $ctr;?></b></td></tr>
  <tr height='1'><td colspan='4' bgcolor='#888888'><img src='images/break.gif' height='1' width='100%'></td></tr>
  <tr height='25'><td colspan='4' height='25'>
	<img src='images/icon-undo.gif' align='absmiddle'>&nbsp;<a href='stats-reset.php?all=true'><?php echo $strResetStats;?></a>&nbsp;&nbsp;&nbsp;&nbsp;
  </td></tr>
  
</table>   

<?php } ?>

<br><br>

<?php

/*********************************************************/
/* HTML framework                                        */
/*********************************************************/

phpAds_PageFooter();

?>
