/* $PostgresPy: if/include/pg.h,v 1.14 2004/07/26 02:05:34 flaw Exp $
 *
 * † Instrument:
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Few Postgres utilities.
 */
#ifndef POSTGRESPY_PG_H
#define POSTGRESPY_PG_H "pg.h"
#ifdef __cplusplus
extern "C" {
#endif

/* In the old list implementation, ListCell == List */
#if defined(PG_LIST_H) && defined(FastListInit) && !defined(forboth)
#define ListCell List
#define linitial(LIST) (LIST)
#define list_length length
#define forboth(cell1, list1, cell2, list2)						\
	for (	cell1 = linitial(list1), cell2 = linitial(list2);	\
			cell1 != NULL && cell2 != NULL;							\
			cell1 = lnext(cell1), cell2 = lnext(cell2) )
#define list_make1(x1) lcons(x1, NIL)
#define list_make2(x1,x2) lcons(x1, list_make1(x2))
#define list_make3(x1,x2,x3) lcons(x1, list_make2(x2,x3))
#define list_make4(x1,x2,x3,x4) lcons(x1, list_make3(x2,x3,x4))
#endif

#define	HeapTuple_FetchTableOid(ht) (ht->t_tableOid)
#define	HeapTuple_FetchOid(ht) HeapTupleGetOid(ht)
#define	HeapTuple_FetchNatts(ht) (ht->t_data->t_natts)
#define	HeapTuple_FetchXmin(ht) HeapTupleHeaderGetXmin(ht->t_data)
#define	HeapTuple_FetchXmax(ht) HeapTupleHeaderGetXmax(ht->t_data)
#define	HeapTuple_FetchXvac(ht) HeapTupleHeaderGetXvac(ht->t_data)
#define	HeapTuple_FetchCmin(ht) HeapTupleHeaderGetCmin(ht->t_data)
#define	HeapTuple_FetchCmax(ht) HeapTupleHeaderGetCmax(ht->t_data)
#define	HeapTuple_FetchTID(ht) (ht->t_data->t_ctid)

#define	PROCSTRUCT(V) ((Form_pg_proc)GETSTRUCT(V))
#define	TYPESTRUCT(V) ((Form_pg_type)GETSTRUCT(V))
#define	LANGSTRUCT(V) ((Form_pg_language)GETSTRUCT(V))
#define	OPERSTRUCT(V) ((Form_pg_operator)GETSTRUCT(V))
#define	CASTSTRUCT(V) ((Form_pg_cast)GETSTRUCT(V))

#define	SysRelTupleDesc(F_) (RelationNameGetTupleDesc(F_##RelationName))
#define	SysTupleDesc(_F) (RelationOidGetDescr(RelOid_pg_##_F))

/* Post 7.5 */
#if (CATALOG_VERSION_NO > 200400000)
#define TupleDescInitEntry(DESC,ATTNUM,ATTNAME,TYPOID,TYPMOD,DIM,ISSET)\
	TupleDescInitEntry(DESC,ATTNUM,ATTNAME,TYPOID,TYPMOD,DIM)
#endif

#ifdef __cplusplus
}
#endif
#endif
