/* $PostgresPy: if/src/tup.h,v 1.9 2004/07/27 09:56:08 flaw Exp $
 * 
 * † Instrument:
 *     Copyright 2004, rhid development. All Rights Reserved.
 *     
 *     Usage of the works is permitted provided that this
 *     instrument is retained with the works, so that any entity
 *     that uses the works is notified of this instrument.
 *     
 *     DISCLAIMER: THE WORKS ARE WITHOUT WARRANTY.
 *     
 *     [2004, Fair License; rhid.com/fair]
 *     
 * Description:
 *    Header for htup.c
 */
#ifndef PyPg_TUP_H
#define PyPg_TUP_H "tup.h"
#ifdef __cplusplus
extern "C" {
#endif

typedef struct PyPgTuple {
	PyPgDatum_HEAD
	PyObj tup_desc;
} PyPgTuple, *PgTup;

extern PyTypeObject PyPgTuple_Type;

#define PgTup_NEW() (PgTup)PyPgTuple_Type.tp_alloc(&PyPgTuple_Type, 0)
PyObj PyPgTuple_New(HeapTuple, PyObj);

PyObj PyPgTypeTuple_FromPyObject(PyObj);
PyObj PyPgSearchSysCache(int, Datum, Datum, Datum, Datum);

HeapTuple HeapTuple_FromIterableAndTupleDesc(PyObj, TupleDesc);

#define PgTup_TypeCheck(OB) (PyObject_TypeCheck(OB, &PyPgTuple_Type))
#define PgTup_TypeCheckExact(OB) (OB->ob_type == &PyPgTuple_Type)

#define PgTup(OB) ((PgTup)OB)

/* Fetch the HeapTuple from a PyPgTuple */
#define PgTup_FetchHT(OB) ((HeapTuple) (PgTup(OB)->ob_datum))

/* Fetch the HeapTuple's Descriptor Object from a PgTup */
#define PgTup_FetchTDO(OB) (PgTup(OB)->tup_desc)

/* Fetch the TupleDesc from the TDO of the PgTup */
#define PgTup_FetchTDOTD(OB) (PgTupD_FetchTD(PgTup_FetchTDO(OB)))

/* Create a PgTup from a type's Oid */
#define PgTup_FromTypeOid(OID) PyPgSearchSysCache(TYPEOID, OID, 0, 0, 0)

#define PgTup_FetchOid(OB) HeapTuple_FetchOid(PgTup_FetchHT(OB))
#define PgTup_FetchTableOid(OB) HeapTuple_FetchTableOid(PgTup_FetchHT(OB))
#define PgTup_FetchNatts(OB) HeapTuple_FetchNatts(PgTup_FetchHT(OB))
#define PgTup_FetchXmin(OB) HeapTuple_FetchXmin(PgTup_FetchHT(OB))
#define PgTup_FetchXmax(OB) HeapTuple_FetchXmax(PgTup_FetchHT(OB))
#define PgTup_FetchXvac(OB) HeapTuple_FetchXvac(PgTup_FetchHT(OB))
#define PgTup_FetchCmin(OB) HeapTuple_FetchCmin(PgTup_FetchHT(OB))
#define PgTup_FetchCmax(OB) HeapTuple_FetchCmax(PgTup_FetchHT(OB))
#define PgTup_FetchTID(OB)  HeapTuple_FetchTID(PgTup_FetchHT(OB))

/* Create a PyPgTuple from HeapTuple of pg_type descriptor */
#define PgTypeTup_New(OB) PyPgTuple_New(OB, PyPgTypeTDO)

/* Fetch an attribute's type oid */
#define PgTup_FetchAttrTypeOid(OB, ATT) \
	(PgTup_FetchTDOTD(OB)->attrs[ATT]->atttypid)

/* Fetch an attribute's type tuple */
#define PgTup_FetchAttrTTO(OB, ATT) \
	PgTup_FromTypeOid(PgTup_FetchAttrTypeOid(OB, ATT))

#define HeapTuple_FetchAttribute(ht, attn, td, isnull) \
	(attn < 0 || attn > td->natts) ? \
	(Datum)PyErr_Format(PyExc_IndexError, \
		"Tuple has no such attribute %d.", (int)attn) \
	: heap_getattr(ht, attn + 1, td, isnull)

#define PgTup_FetchAttribute(tup, attn, isnull) \
	HeapTuple_FetchAttribute(PgTup_FetchHT(self), attn, \
			PgTup_FetchTDOTD(self), isnull)

#ifdef __cplusplus
}
#endif
#endif /* !PyPg_TUP_H */
